/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.metrics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.metrics.TenantMetricsService;
import io.confluent.catalog.util.StripedExecutorService;
import io.confluent.catalog.util.StripedRunnable;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import java.io.Closeable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.metrics.stats.WindowedSum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricsManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsManager.class);
    private static final int PERCENTILE_NUM_BUCKETS = 200;
    private static final double PERCENTILE_MAX_LATENCY_IN_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final int SCHEMA_ATTACH_RATE_UPDATE_INTERVAL_HOURS = 12;
    private static final int NUM_THREADS_SCHEMA_ATTACH_RATE = 20;
    static final String METRIC_GROUP = "data_catalog";
    static final String TENANT_TAG = "tenant";
    static final String ENTITY_TAG = "entity";
    static final String TAG_TAG = "tag";
    static final String BM_TAG = "business_metadata";
    static final String INGESTION_XFORM_ENTITIES = "ingestion-xform-entities";
    static final String INGESTION_XFORM_ERROR_ENTITIES = "ingestion-xform-error-entities";
    static final String INGESTION_TOPIC_CREATION = "ingestion-topic-creation";
    static final String INGESTION_TOPIC_DELETION = "ingestion-topic-deletion";
    static final String INGESTION_TOPIC_CREATION_ERROR = "ingestion-topic-creation-error";
    static final String INGESTION_TOPIC_DELETION_ERROR = "ingestion-topic-deletion-error";
    static final String INGESTION_CONNECTOR_CREATION = "ingestion-connector-creation";
    static final String INGESTION_CONNECTOR_DELETION = "ingestion-connector-deletion";
    static final String INGESTION_CONNECTOR_CREATION_ERROR = "ingestion-connector-creation-error";
    static final String INGESTION_CONNECTOR_DELETION_ERROR = "ingestion-connector-deletion-error";
    static final String INGESTION_PIPELINE_CREATION = "ingestion-pipeline-creation";
    static final String INGESTION_PIPELINE_DELETION = "ingestion-pipeline-deletion";
    static final String INGESTION_PIPELINE_CREATION_ERROR = "ingestion-pipeline-creation-error";
    static final String INGESTION_PIPELINE_DELETION_ERROR = "ingestion-pipeline-deletion-error";
    static final String INGESTION_CLUSTER_CREATION = "ingestion-cluster-creation";
    static final String INGESTION_CLUSTER_DELETION = "ingestion-cluster-deletion";
    static final String INGESTION_CLUSTER_CREATION_ERROR = "ingestion-cluster-creation-error";
    static final String INGESTION_CLUSTER_DELETION_ERROR = "ingestion-cluster-deletion-error";
    static final String INGESTION_CLUSTER_LINK_CREATION = "ingestion-cluster-link-creation";
    static final String INGESTION_CLUSTER_LINK_DELETION = "ingestion-cluster-link-deletion";
    static final String INGESTION_CLUSTER_LINK_CREATION_ERROR = "ingestion-cluster-link-creation-error";
    static final String INGESTION_CLUSTER_LINK_DELETION_ERROR = "ingestion-cluster-link-deletion-error";
    static final String INGESTION_ENVIRONMENT_CREATION = "ingestion-environment-creation";
    static final String INGESTION_ENVIRONMENT_DELETION = "ingestion-environment-deletion";
    static final String INGESTION_ENVIRONMENT_CREATION_ERROR = "ingestion-environment-creation-error";
    static final String INGESTION_ENVIRONMENT_DELETION_ERROR = "ingestion-environment-deletion-error";
    static final String INGESTION_INDEX_ENTITIES = "ingestion-index-entities";
    static final String INGESTION_INDEX_ERROR_ENTITIES = "ingestion-index-error-entities";
    static final String INGESTION_EVENTS_PIPELINE_TIME = "ingestion-events-pipeline-time";
    static final String NOTIFICATION_ENTITIES = "notification-entities";
    static final String NOTIFICATION_ERROR_ENTITIES = "notification-error-entities";
    static final String RECONCILIATION_CLUSTER = "reconciliation-cluster";
    static final String RECONCILIATION_CLUSTER_ERROR = "reconciliation-cluster-error";
    static final String RECONCILIATION_TOPIC = "reconciliation-topic";
    static final String RECONCILIATION_TOPIC_ERROR = "reconciliation-topic-error";
    static final String RECONCILIATION_CLUSTER_TIME = "reconciliation-cluster-time";
    static final String RECONCILIATION_TOPIC_TIME = "reconciliation-topic-time";
    static final String JANUSGRAPH_NPE_ERROR = "janusgraph-npe-error";
    static final String ENTITY_PARTIAL_UPDATES = "entity-partial-updates";
    static final String SCHEMA_ATTACH_RATE = "schema_attach_rate";
    static final String NUM_ENTITIES = "num_entities";
    static final String NUM_TAG_DEFS = "num_tag_defs";
    static final String NUM_BM_DEFS = "num_business_metadata_defs";
    static final String NUM_ACTIVE_ENTITIES_PER_TYPE = "num_active_entities_by_type";
    static final String NUM_DELETED_ENTITIES_PER_TYPE = "num_deleted_entities_by_type";
    static final String NUM_TAGS_PER_TYPE = "num_tags_by_type";
    static final String NUM_ENTITIES_PER_TAG = "num_entities_by_tag";
    static final String NUM_BM_PER_TYPE = "num_business_metadata_by_type";
    static final String NUM_ENTITIES_PER_BM = "num_entities_by_business_metadata";
    static final String NUM_ATTRS_PER_BM = "num_attrs_by_business_metadata";
    static final String SERVICE_UNAVAILABLE_COUNT = "service-unavailable-count";
    static final String SEARCH_RESTFUL_COUNT = "search_restful_count";
    static final String SEARCH_GRAPHQL_COUNT = "search_graphql_count";
    static final String CATALOG_EVENT_PROCESSING_LAG = "catalog-event-processing-lag";
    static final String LATENCY_AVG = "-latency-avg";
    static final String LATENCY_P99 = "-latency-99";
    static final String ATLAS_FIND_BY_TYPE_AND_UNIQUE_PROPERTY_NAME = "atlas-find-by-type-and-unique-property-name";
    static final String ATLAS_FIND_BY_SUPER_TYPE_AND_UNIQUE_PROPERTY_NAME = "atlas-find-by-super-type-and-unique-property-name";
    static final String ATLAS_FIND_BY_TYPE_AND_PROPERTY_NAME = "atlas-find-by-type-and-property-name";
    static final String ATLAS_FIND_BY_SUPER_TYPE_AND_PROPERTY_NAME = "atlas-find-by-super-type-and-property-name";
    static final String ATLAS_FIND_BY_UNIQUE_ATTRIBUTES = "atlas-find-by-unique-attributes";
    static final String ATLAS_GET_VERTEX_FROM_INDEX_QUERY = "atlas-get-vertex-from-index-query";
    static final String ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES = "atlas-get-guid-by-unique-attributes";
    static final String ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES_AND_STATUS = "atlas-get-guid-by-unique-attributes-and-status";
    static final String ATLAS_GET_BY_UNIQUE_ATTRIBUTES = "atlas-get-by-unique-attributes";
    private final GlobalMetrics globalMetrics = new GlobalMetrics();
    private final Map<String, TenantMetrics> tenantMetrics = new ConcurrentHashMap<String, TenantMetrics>();
    private final Metrics metrics;
    private final TenantMetricsService metricsService;
    private final int catalogMetricsNumThreads;
    private final StripedExecutorService stripedExecutor;
    private final ScheduledExecutorService schemaAttachRateUpdateScheduler;

    @Inject
    public MetricsManager(SchemaRegistry schemaRegistry, TenantMetricsService metricsService) {
        try {
            this.metrics = ((KafkaSchemaRegistry)schemaRegistry).getMetricsContainer().getMetrics();
            this.metricsService = metricsService;
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
            this.catalogMetricsNumThreads = dataCatalogConfig.catalogMetricsNumThreads();
            this.stripedExecutor = new StripedExecutorService(this.catalogMetricsNumThreads);
            this.schemaAttachRateUpdateScheduler = Executors.newScheduledThreadPool(1);
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate MetricsManager", e);
        }
    }

    public void init() {
        List<String> tenants = this.metricsService.getTenants();
        CompletableFuture.runAsync(() -> this.initTagEntityCount(tenants)).thenRun(() -> this.updateAtlasMetricsForAll(tenants));
        this.schemaAttachRateUpdateScheduler.scheduleAtFixedRate(this::updateSchemaAttachRateMetrics, 1L, 12L, TimeUnit.HOURS);
    }

    public void recordIngestionEventsPipelineTime(double seconds) {
        this.globalMetrics.record(INGESTION_EVENTS_PIPELINE_TIME, seconds);
    }

    public void recordIngestionTransform(int count) {
        this.globalMetrics.record(INGESTION_XFORM_ENTITIES, count);
    }

    public void recordIngestionIndex(int count) {
        this.globalMetrics.record(INGESTION_INDEX_ENTITIES, count);
    }

    public void recordIngestionTransformError(int count) {
        this.globalMetrics.record(INGESTION_XFORM_ERROR_ENTITIES, count);
    }

    public void recordIngestionIndexError(int count) {
        this.globalMetrics.record(INGESTION_INDEX_ERROR_ENTITIES, count);
    }

    public void recordNotificationSent(int count) {
        this.globalMetrics.record(NOTIFICATION_ENTITIES, count);
    }

    public void recordNotificationSentError(int count) {
        this.globalMetrics.record(NOTIFICATION_ERROR_ENTITIES, count);
    }

    public void recordIngestionTopicCreation(int count) {
        this.globalMetrics.record(INGESTION_TOPIC_CREATION, count);
    }

    public void recordIngestionTopicDeletion(int count) {
        this.globalMetrics.record(INGESTION_TOPIC_DELETION, count);
    }

    public void recordIngestionTopicCreationError(int count) {
        this.globalMetrics.record(INGESTION_TOPIC_CREATION_ERROR, count);
    }

    public void recordIngestionTopicDeletionError(int count) {
        this.globalMetrics.record(INGESTION_TOPIC_DELETION_ERROR, count);
    }

    public void recordIngestionConnectorCreation(int count) {
        this.globalMetrics.record(INGESTION_CONNECTOR_CREATION, count);
    }

    public void recordIngestionConnectorDeletion(int count) {
        this.globalMetrics.record(INGESTION_CONNECTOR_DELETION, count);
    }

    public void recordIngestionConnectorCreationError(int count) {
        this.globalMetrics.record(INGESTION_CONNECTOR_CREATION_ERROR, count);
    }

    public void recordIngestionConnectorDeletionError(int count) {
        this.globalMetrics.record(INGESTION_CONNECTOR_DELETION_ERROR, count);
    }

    public void recordIngestionPipelineCreation(int count) {
        this.globalMetrics.record(INGESTION_PIPELINE_CREATION, count);
    }

    public void recordIngestionPipelineDeletion(int count) {
        this.globalMetrics.record(INGESTION_PIPELINE_DELETION, count);
    }

    public void recordIngestionPipelineCreationError(int count) {
        this.globalMetrics.record(INGESTION_PIPELINE_CREATION_ERROR, count);
    }

    public void recordIngestionPipelineDeletionError(int count) {
        this.globalMetrics.record(INGESTION_PIPELINE_DELETION_ERROR, count);
    }

    public void recordIngestionClusterCreation(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_CREATION, count);
    }

    public void recordIngestionClusterDeletion(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_DELETION, count);
    }

    public void recordIngestionClusterCreationError(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_CREATION_ERROR, count);
    }

    public void recordIngestionClusterDeletionError(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_DELETION_ERROR, count);
    }

    public void recordIngestionClusterLinkCreation(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_LINK_CREATION, count);
    }

    public void recordIngestionClusterLinkDeletion(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_LINK_DELETION, count);
    }

    public void recordIngestionClusterLinkCreationError(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_LINK_CREATION_ERROR, count);
    }

    public void recordIngestionClusterLinkDeletionError(int count) {
        this.globalMetrics.record(INGESTION_CLUSTER_LINK_DELETION_ERROR, count);
    }

    public void recordIngestionEnvironmentCreation(int count) {
        this.globalMetrics.record(INGESTION_ENVIRONMENT_CREATION, count);
    }

    public void recordIngestionEnvironmentDeletion(int count) {
        this.globalMetrics.record(INGESTION_ENVIRONMENT_DELETION, count);
    }

    public void recordIngestionEnvironmentCreationError(int count) {
        this.globalMetrics.record(INGESTION_ENVIRONMENT_CREATION_ERROR, count);
    }

    public void recordIngestionEnvironmentDeletionError(int count) {
        this.globalMetrics.record(INGESTION_ENVIRONMENT_DELETION_ERROR, count);
    }

    public void recordReconciliationCluster(int count) {
        this.globalMetrics.record(RECONCILIATION_CLUSTER, count);
    }

    public void recordReconciliationClusterError(int count) {
        this.globalMetrics.record(RECONCILIATION_CLUSTER_ERROR, count);
    }

    public void recordReconciliationTopic(int count) {
        this.globalMetrics.record(RECONCILIATION_TOPIC, count);
    }

    public void recordReconciliationTopicError(int count) {
        this.globalMetrics.record(RECONCILIATION_TOPIC_ERROR, count);
    }

    public void recordReconciliationClusterTime(long ms) {
        this.globalMetrics.record(RECONCILIATION_CLUSTER_TIME, ms);
    }

    public void recordReconciliationTopicTime(long ms) {
        this.globalMetrics.record(RECONCILIATION_TOPIC_TIME, ms);
    }

    public void recordJanusGraphNullPointerExceptionError(int count) {
        this.globalMetrics.record(JANUSGRAPH_NPE_ERROR, count);
    }

    public void recordEntityPartialUpdate(String tenant, int count) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        tenantMetrics.getSensor(MetricDescriptor.ENTITY_PARTIAL_UPDATES_COUNT_MD, null, null).record(count);
    }

    public void recordServiceUnavailable() {
        this.globalMetrics.getSensor(SERVICE_UNAVAILABLE_COUNT).record(1.0);
    }

    public void recordCatalogEventProcessingLag(long seconds) {
        this.globalMetrics.record(CATALOG_EVENT_PROCESSING_LAG, seconds);
    }

    public void recordFindByTypeAndUniquePropertyName(long ms) {
        this.globalMetrics.record(ATLAS_FIND_BY_TYPE_AND_UNIQUE_PROPERTY_NAME, ms);
    }

    public void recordFindBySuperTypeAndUniquePropertyName(long ms) {
        this.globalMetrics.record(ATLAS_FIND_BY_SUPER_TYPE_AND_UNIQUE_PROPERTY_NAME, ms);
    }

    public void recordFindByTypeAndPropertyName(long ms) {
        this.globalMetrics.record(ATLAS_FIND_BY_TYPE_AND_PROPERTY_NAME, ms);
    }

    public void recordFindBySuperTypeAndPropertyName(long ms) {
        this.globalMetrics.record(ATLAS_FIND_BY_SUPER_TYPE_AND_PROPERTY_NAME, ms);
    }

    public void recordFindByUniqueAttributes(long ms) {
        this.globalMetrics.record(ATLAS_FIND_BY_UNIQUE_ATTRIBUTES, ms);
    }

    public void recordGetVertexFromIndexQuery(long ms) {
        this.globalMetrics.record(ATLAS_GET_VERTEX_FROM_INDEX_QUERY, ms);
    }

    public void recordGetGuidByUniqueAttributes(long ms) {
        this.globalMetrics.record(ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES, ms);
    }

    public void recordGetGuidByUniqueAttributesAndStatus(long ms) {
        this.globalMetrics.record(ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES_AND_STATUS, ms);
    }

    public void recordGetByUniqueAttributes(long ms) {
        this.globalMetrics.record(ATLAS_GET_BY_UNIQUE_ATTRIBUTES, ms);
    }

    public void recordRestfulSearch(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        tenantMetrics.getSensor(MetricDescriptor.SEARCH_RESTFUL_COUNT_MD, null, null).record(1.0);
    }

    public void recordGraphQLSearch(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        tenantMetrics.getSensor(MetricDescriptor.SEARCH_GRAPHQL_COUNT_MD, null, null).record(1.0);
    }

    public long getEntityCount(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        return tenantMetrics.getSensor(MetricDescriptor.NUM_ENTITIES_MD, null, null).get();
    }

    public long getTagDefCount(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        return tenantMetrics.getSensor(MetricDescriptor.NUM_TAG_DEFS_MD, null, null).get();
    }

    public long getBMDefCount(String tenant) {
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        return tenantMetrics.getSensor(MetricDescriptor.NUM_BM_DEFS_MD, null, null).get();
    }

    public void initTagEntityCount(List<String> tenants) {
        long start = System.currentTimeMillis();
        this.runOneOffTasks(tenants, this.catalogMetricsNumThreads * 2, "tag-count-init-%d", "init tag entity cache", this.metricsService::countTags);
        LOG.info("Initialized tag entity count cache for {} tenants, took {} ms", (Object)tenants.size(), (Object)(System.currentTimeMillis() - start));
    }

    public void updateAtlasMetrics(String tenant) {
        if (this.stripedExecutor.getQueueSize(tenant) == 0) {
            this.stripedExecutor.execute(new AtlasMetricsUpdateTask(tenant));
        }
    }

    public void updateSchemaAttachRateMetrics() {
        long start = System.currentTimeMillis();
        List<String> tenants = this.metricsService.getTenants();
        this.runOneOffTasks(tenants, 20, "schema-attach-rate-%d", "update schema attach rate metrics", this::updateSchemaAttachRate);
        LOG.info("Updated schema attach rate metrics for {} tenants, took {} ms", (Object)tenants.size(), (Object)(System.currentTimeMillis() - start));
    }

    private void updateAtlasMetricsForAll(List<String> tenants) {
        if (tenants == null) {
            return;
        }
        LOG.info("Init AtlasMetrics: updating {} tenants", (Object)tenants.size());
        tenants.forEach(this::updateAtlasMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOneOffTasks(List<String> tenants, int numThreads, String threadName, String description, Consumer<String> tenantProcessor) {
        if (tenants == null) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat(threadName).build());
        try {
            CompletableFuture.allOf((CompletableFuture[])tenants.stream().map(tenant -> CompletableFuture.runAsync(() -> tenantProcessor.accept((String)tenant), executor)).toArray(CompletableFuture[]::new)).join();
        }
        catch (Exception e) {
            LOG.error("Failed to {}", (Object)description, (Object)e);
        }
        finally {
            try {
                executor.shutdown();
                try {
                    if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                        executor.shutdownNow();
                    }
                }
                catch (InterruptedException ie) {
                    executor.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                LOG.error("Failed to shutdown executor", (Throwable)e);
            }
        }
    }

    private void updateSchemaAttachRate(String tenant) {
        long start = System.currentTimeMillis();
        TenantMetrics tenantMetrics = this.getOrCreateTenantMetrics(tenant);
        this.metricsService.getSchemaAttachRate(tenant).ifPresent(attachRate -> {
            tenantMetrics.getSensor(MetricDescriptor.SCHEMA_ATTACH_RATE_MD, null, null).record((double)attachRate);
            LOG.info("Updated schema attach rate for {} to {}, took {} ms", new Object[]{tenant, String.format("%.2f", attachRate), System.currentTimeMillis() - start});
        });
    }

    @Override
    public void close() {
        this.shutdownQuietly(this.stripedExecutor);
        this.metrics.close();
    }

    private void shutdownQuietly(ExecutorService executor) {
        try {
            if (executor != null) {
                executor.shutdown();
                if (!executor.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                    LOG.error("Timed out waiting for executor to shut down, exiting uncleanly");
                }
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failure in shutting down executor");
        }
    }

    private TenantMetrics getOrCreateTenantMetrics(String tenant) {
        return this.tenantMetrics.computeIfAbsent(tenant, k -> {
            try {
                this.metricsService.maybeCreateTenant(tenant);
            }
            catch (AtlasBaseException e) {
                LOG.error("Could not create tenant", (Throwable)e);
            }
            return new TenantMetrics((String)k);
        });
    }

    private static enum MetricDescriptor {
        INGESTION_XFORM_COUNT_MD("ingestion-xform-entities", "ingestion-xform-entities-delta", "data_catalog", "Windowed sum of entities during ingestion transformation", WindowedSum::new),
        INGESTION_INDEX_COUNT_MD("ingestion-index-entities", "ingestion-index-entities-delta", "data_catalog", "Windowed sum of entities during ingestion indexing", WindowedSum::new),
        INGESTION_XFORM_TOTAL_MD("ingestion-xform-entities", "ingestion-xform-entities-total", "data_catalog", "Number of transformations during ingestion", CumulativeSum::new),
        INGESTION_INDEX_TOTAL_MD("ingestion-index-entities", "ingestion-index-entities-total", "data_catalog", "Number of entities during ingestion indexing", CumulativeSum::new),
        INGESTION_XFORM_ERROR_COUNT_MD("ingestion-xform-error-entities", "ingestion-xform-error-entities-delta", "data_catalog", "Windowed sum of errored entities during ingestion transformation", WindowedSum::new),
        INGESTION_INDEX_ERROR_COUNT_MD("ingestion-index-error-entities", "ingestion-index-error-entities-delta", "data_catalog", "Windowed sum of errored entities during ingestion indexing", WindowedSum::new),
        INGESTION_XFORM_ERROR_TOTAL_MD("ingestion-xform-error-entities", "ingestion-xform-error-entities-total", "data_catalog", "Number of errored entities during ingestion transformation", CumulativeSum::new),
        INGESTION_INDEX_ERROR_TOTAL_MD("ingestion-index-error-entities", "ingestion-index-error-entities-total", "data_catalog", "Number of errored entities during ingestion indexing", CumulativeSum::new),
        NOTIFICATION_TOTAL_MD("notification-entities", "notification-entities-total", "data_catalog", "Number of entities during notification sending", CumulativeSum::new),
        NOTIFICATION_COUNT_MD("notification-entities", "notification-entities-delta", "data_catalog", "Windowed sum of entities during notification sending", WindowedSum::new),
        NOTIFICATION_ERROR_TOTAL_MD("notification-error-entities", "notification-error-entities-total", "data_catalog", "Number of errored entities during notification indexing", CumulativeSum::new),
        NOTIFICATION_ERROR_COUNT_MD("notification-error-entities", "notification-error-entities-delta", "data_catalog", "Windowed sum of errored entities during notification indexing", WindowedSum::new),
        ENTITY_PARTIAL_UPDATES_COUNT_MD("entity-partial-updates", "entity-partial-updates-count", "data_catalog", "Windowed count of requests for non-internal entity partial updates", WindowedCount::new),
        SCHEMA_ATTACH_RATE_MD("schema_attach_rate", "data_catalog", "Topic schema attach rate", Value::new),
        NUM_ENTITIES_MD("num_entities", "data_catalog", "Number of entities", Value::new),
        NUM_TAG_DEFS_MD("num_tag_defs", "data_catalog", "Number of tag definitions", Value::new),
        NUM_BM_DEFS_MD("num_business_metadata_defs", "data_catalog", "Number of business metadata definitions", Value::new),
        NUM_ACTIVE_ENTITIES_PER_TYPE_MD("num_active_entities_by_type", "data_catalog", "Number of active entities per type", Value::new),
        NUM_DELETED_ENTITIES_PER_TYPE_MD("num_deleted_entities_by_type", "data_catalog", "Number of deleted entities per type", Value::new),
        NUM_TAGS_PER_TYPE_MD("num_tags_by_type", "data_catalog", "Number of tags per type", Value::new),
        NUM_ENTITIES_PER_TAG_MD("num_entities_by_tag", "data_catalog", "Number of entities per tag", Value::new),
        NUM_BM_PER_TYPE_MD("num_business_metadata_by_type", "data_catalog", "Number of business metadata per type", Value::new),
        NUM_ENTITIES_PER_BM_MD("num_entities_by_business_metadata", "data_catalog", "Number of entities per business metadata", Value::new),
        NUM_ATTRS_PER_BM_MD("num_attrs_by_business_metadata", "data_catalog", "Number of attributes per business metadata", Value::new),
        SERVICE_UNAVAILABLE_COUNT_MD("service-unavailable-count", "data_catalog", "Number of data catalog requests that got rejected due to uninitialized metadata registry", CumulativeCount::new),
        SEARCH_RESTFUL_COUNT_MD("search_restful_count", "data_catalog", "Number of search requests via REST API", CumulativeCount::new),
        SEARCH_GRAPHQL_COUNT_MD("search_graphql_count", "data_catalog", "Number of search requests via GraphQL API", CumulativeCount::new),
        CATALOG_EVENT_PROCESSING_LAG_MD("catalog-event-processing-lag", "data_catalog", "The lag in seconds in catalog event processing", Value::new),
        ATLAS_FIND_BY_TYPE_AND_UNIQUE_PROPERTY_NAME_LATENCY_AVG_MD("atlas-find-by-type-and-unique-property-name", "atlas-find-by-type-and-unique-property-name-latency-avg", "data_catalog", "Atlas findByTypeAndUniquePropertyName average latency in ms", Avg::new),
        ATLAS_FIND_BY_TYPE_AND_UNIQUE_PROPERTY_NAME_LATENCY_P99_MD("atlas-find-by-type-and-unique-property-name", "atlas-find-by-type-and-unique-property-name-latency-99", "data_catalog", "Atlas findByTypeAndUniquePropertyName 99th percentile latency in ms", null, 99.0),
        ATLAS_FIND_BY_SUPER_TYPE_AND_UNIQUE_PROPERTY_NAME_LATENCY_AVG_MD("atlas-find-by-super-type-and-unique-property-name", "atlas-find-by-super-type-and-unique-property-name-latency-avg", "data_catalog", "Atlas findBySuperTypeAndUniquePropertyName average latency in ms", Avg::new),
        ATLAS_FIND_BY_SUPER_TYPE_AND_UNIQUE_PROPERTY_NAME_LATENCY_P99_MD("atlas-find-by-super-type-and-unique-property-name", "atlas-find-by-super-type-and-unique-property-name-latency-99", "data_catalog", "Atlas findBySuperTypeAndUniquePropertyName 99th percentile latency in ms", null, 99.0),
        ATLAS_FIND_BY_TYPE_AND_PROPERTY_NAME_LATENCY_AVG_MD("atlas-find-by-type-and-property-name", "atlas-find-by-type-and-property-name-latency-avg", "data_catalog", "Atlas findByTypeAndPropertyName average latency in ms", Avg::new),
        ATLAS_FIND_BY_TYPE_AND_PROPERTY_NAME_LATENCY_P99_MD("atlas-find-by-type-and-property-name", "atlas-find-by-type-and-property-name-latency-99", "data_catalog", "Atlas findByTypeAndPropertyName 99th percentile latency in ms", null, 99.0),
        ATLAS_FIND_BY_SUPER_TYPE_AND_PROPERTY_NAME_LATENCY_AVG_MD("atlas-find-by-super-type-and-property-name", "atlas-find-by-super-type-and-property-name-latency-avg", "data_catalog", "Atlas findBySuperTypeAndPropertyName average latency in ms", Avg::new),
        ATLAS_FIND_BY_SUPER_TYPE_AND_PROPERTY_NAME_LATENCY_P99_MD("atlas-find-by-super-type-and-property-name", "atlas-find-by-super-type-and-property-name-latency-99", "data_catalog", "Atlas findBySuperTypeAndPropertyName 99th percentile latency in ms", null, 99.0),
        ATLAS_FIND_BY_UNIQUE_ATTRIBUTES_LATENCY_AVG_MD("atlas-find-by-unique-attributes", "atlas-find-by-unique-attributes-latency-avg", "data_catalog", "Atlas findByUniqueAttributes average latency in ms", Avg::new),
        ATLAS_FIND_BY_UNIQUE_ATTRIBUTES_LATENCY_P99_MD("atlas-find-by-unique-attributes", "atlas-find-by-unique-attributes-latency-99", "data_catalog", "Atlas findByUniqueAttributes 99th percentile latency in ms", null, 99.0),
        ATLAS_GET_VERTEX_FROM_INDEX_QUERY_LATENCY_AVG_MD("atlas-get-vertex-from-index-query", "atlas-get-vertex-from-index-query-latency-avg", "data_catalog", "Atlas getVertexFromIndexQuery average latency in ms", Avg::new),
        ATLAS_GET_VERTEX_FROM_INDEX_QUERY_LATENCY_P99_MD("atlas-get-vertex-from-index-query", "atlas-get-vertex-from-index-query-latency-99", "data_catalog", "Atlas getVertexFromIndexQuery 99th percentile latency in ms", null, 99.0),
        ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES_LATENCY_AVG_MD("atlas-get-guid-by-unique-attributes", "atlas-get-guid-by-unique-attributes-latency-avg", "data_catalog", "Atlas getGuidByUniqueAttributes average latency in ms", Avg::new),
        ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES_LATENCY_P99_MD("atlas-get-guid-by-unique-attributes", "atlas-get-guid-by-unique-attributes-latency-99", "data_catalog", "Atlas getGuidByUniqueAttributes 99th percentile latency in ms", null, 99.0),
        ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES_AND_STATUS_LATENCY_AVG_MD("atlas-get-guid-by-unique-attributes-and-status", "atlas-get-guid-by-unique-attributes-and-status-latency-avg", "data_catalog", "Atlas getGuidByUniqueAttributesAndStatus average latency in ms", Avg::new),
        ATLAS_GET_GUID_BY_UNIQUE_ATTRIBUTES_AND_STATUS_LATENCY_P99_MD("atlas-get-guid-by-unique-attributes-and-status", "atlas-get-guid-by-unique-attributes-and-status-latency-99", "data_catalog", "Atlas getGuidByUniqueAttributesAndStatus 99th percentile latency in ms", null, 99.0),
        ATLAS_GET_BY_UNIQUE_ATTRIBUTES_LATENCY_AVG_MD("atlas-get-by-unique-attributes", "atlas-get-by-unique-attributes-latency-avg", "data_catalog", "Atlas getByUniqueAttributes average latency in ms", Avg::new),
        ATLAS_GET_BY_UNIQUE_ATTRIBUTES_LATENCY_P99_MD("atlas-get-by-unique-attributes", "atlas-get-by-unique-attributes-latency-99", "data_catalog", "Atlas getByUniqueAttributes 99th percentile latency in ms", null, 99.0),
        INGESTION_EVENTS_PIPELINE_TIME_LATENCY_AVG_MD("ingestion-events-pipeline-time", "ingestion-events-pipeline-time-latency-avg", "data_catalog", "Catalog ingestion events pipeline average latency in seconds", Avg::new),
        INGESTION_EVENTS_PIPELINE_TIME_LATENCY_P99_MD("ingestion-events-pipeline-time", "ingestion-events-pipeline-time-latency-99", "data_catalog", "Catalog ingestion events pipeline percentile latency in seconds", null, 99.0),
        INGESTION_TOPIC_CREATION_COUNT_MD("ingestion-topic-creation", "ingestion-topic-creation-delta", "data_catalog", "Windowed sum of topic creation during ingestion transformation", WindowedSum::new),
        INGESTION_TOPIC_CREATION_TOTAL_MD("ingestion-topic-creation", "ingestion-topic-creation-total", "data_catalog", "Number of topic creation during ingestion transformation", CumulativeSum::new),
        INGESTION_TOPIC_CREATION_ERROR_COUNT_MD("ingestion-topic-creation-error", "ingestion-topic-creation-error-delta", "data_catalog", "Windowed sum of topic creation error during ingestion transformation", WindowedSum::new),
        INGESTION_TOPIC_CREATION_ERROR_TOTAL_MD("ingestion-topic-creation-error", "ingestion-topic-creation-error-total", "data_catalog", "Number of topic creation error during ingestion transformation", CumulativeSum::new),
        INGESTION_TOPIC_DELETION_COUNT_MD("ingestion-topic-deletion", "ingestion-topic-deletion-delta", "data_catalog", "Windowed sum of topic deletion during ingestion transformation", WindowedSum::new),
        INGESTION_TOPIC_DELETION_TOTAL_MD("ingestion-topic-deletion", "ingestion-topic-deletion-total", "data_catalog", "Number of topic deletion during ingestion transformation", CumulativeSum::new),
        INGESTION_TOPIC_DELETION_ERROR_COUNT_MD("ingestion-topic-deletion-error", "ingestion-topic-deletion-error-delta", "data_catalog", "Windowed sum of topic deletion error during ingestion transformation", WindowedSum::new),
        INGESTION_TOPIC_DELETION_ERROR_TOTAL_MD("ingestion-topic-deletion-error", "ingestion-topic-deletion-error-total", "data_catalog", "Number of topic deletion error during ingestion transformation", CumulativeSum::new),
        INGESTION_CONNECTOR_CREATION_COUNT_MD("ingestion-connector-creation", "ingestion-connector-creation-delta", "data_catalog", "Windowed sum of connector creation during ingestion transformation", WindowedSum::new),
        INGESTION_CONNECTOR_CREATION_TOTAL_MD("ingestion-connector-creation", "ingestion-connector-creation-total", "data_catalog", "Number of connector creation during ingestion transformation", CumulativeSum::new),
        INGESTION_CONNECTOR_CREATION_ERROR_COUNT_MD("ingestion-connector-creation-error", "ingestion-connector-creation-error-delta", "data_catalog", "Windowed sum of connector creation error during ingestion transformation", WindowedSum::new),
        INGESTION_CONNECTOR_CREATION_ERROR_TOTAL_MD("ingestion-connector-creation-error", "ingestion-connector-creation-error-total", "data_catalog", "Number of connector creation error during ingestion transformation", CumulativeSum::new),
        INGESTION_CONNECTOR_DELETION_COUNT_MD("ingestion-connector-deletion", "ingestion-connector-deletion-delta", "data_catalog", "Windowed sum of connector deletion during ingestion transformation", WindowedSum::new),
        INGESTION_CONNECTOR_DELETION_TOTAL_MD("ingestion-connector-deletion", "ingestion-connector-deletion-total", "data_catalog", "Number of connector deletion during ingestion transformation", CumulativeSum::new),
        INGESTION_CONNECTOR_DELETION_ERROR_COUNT_MD("ingestion-connector-deletion-error", "ingestion-connector-deletion-error-delta", "data_catalog", "Windowed sum of connector deletion error during ingestion transformation", WindowedSum::new),
        INGESTION_CONNECTOR_DELETION_ERROR_TOTAL_MD("ingestion-connector-deletion-error", "ingestion-connector-deletion-error-total", "data_catalog", "Number of connector deletion error during ingestion transformation", CumulativeSum::new),
        INGESTION_PIPELINE_CREATION_COUNT_MD("ingestion-pipeline-creation", "ingestion-pipeline-creation-delta", "data_catalog", "Windowed sum of pipeline creation during ingestion transformation", WindowedSum::new),
        INGESTION_PIPELINE_CREATION_TOTAL_MD("ingestion-pipeline-creation", "ingestion-pipeline-creation-total", "data_catalog", "Number of pipeline creation during ingestion transformation", CumulativeSum::new),
        INGESTION_PIPELINE_CREATION_ERROR_COUNT_MD("ingestion-pipeline-creation-error", "ingestion-pipeline-creation-error-delta", "data_catalog", "Windowed sum of pipeline creation error during ingestion transformation", WindowedSum::new),
        INGESTION_PIPELINE_CREATION_ERROR_TOTAL_MD("ingestion-pipeline-creation-error", "ingestion-pipeline-creation-error-total", "data_catalog", "Number of pipeline creation error during ingestion transformation", CumulativeSum::new),
        INGESTION_PIPELINE_DELETION_COUNT_MD("ingestion-pipeline-deletion", "ingestion-pipeline-deletion-delta", "data_catalog", "Windowed sum of pipeline deletion during ingestion transformation", WindowedSum::new),
        INGESTION_PIPELINE_DELETION_TOTAL_MD("ingestion-pipeline-deletion", "ingestion-pipeline-deletion-total", "data_catalog", "Number of pipeline deletion during ingestion transformation", CumulativeSum::new),
        INGESTION_PIPELINE_DELETION_ERROR_COUNT_MD("ingestion-pipeline-deletion-error", "ingestion-pipeline-deletion-error-delta", "data_catalog", "Windowed sum of pipeline deletion error during ingestion transformation", WindowedSum::new),
        INGESTION_PIPELINE_DELETION_ERROR_TOTAL_MD("ingestion-pipeline-deletion-error", "ingestion-pipeline-deletion-error-total", "data_catalog", "Number of pipeline deletion error during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_CREATION_COUNT_MD("ingestion-cluster-creation", "ingestion-cluster-creation-delta", "data_catalog", "Windowed sum of cluster creation during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_CREATION_TOTAL_MD("ingestion-cluster-creation", "ingestion-cluster-creation-total", "data_catalog", "Number of cluster creation during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_CREATION_ERROR_COUNT_MD("ingestion-cluster-creation-error", "ingestion-cluster-creation-error-delta", "data_catalog", "Windowed sum of cluster creation error during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_CREATION_ERROR_TOTAL_MD("ingestion-cluster-creation-error", "ingestion-cluster-creation-error-total", "data_catalog", "Number of cluster creation error during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_DELETION_COUNT_MD("ingestion-cluster-deletion", "ingestion-cluster-deletion-delta", "data_catalog", "Windowed sum of cluster deletion during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_DELETION_TOTAL_MD("ingestion-cluster-deletion", "ingestion-cluster-deletion-total", "data_catalog", "Number of cluster deletion during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_DELETION_ERROR_COUNT_MD("ingestion-cluster-deletion-error", "ingestion-cluster-deletion-error-delta", "data_catalog", "Windowed sum of cluster deletion error during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_DELETION_ERROR_TOTAL_MD("ingestion-cluster-deletion-error", "ingestion-cluster-deletion-error-total", "data_catalog", "Number of cluster deletion error during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_LINK_CREATION_COUNT_MD("ingestion-cluster-link-creation", "ingestion-cluster-link-creation-delta", "data_catalog", "Windowed sum of cluster link creation during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_LINK_CREATION_TOTAL_MD("ingestion-cluster-link-creation", "ingestion-cluster-link-creation-total", "data_catalog", "Number of cluster link creation during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_LINK_CREATION_ERROR_COUNT_MD("ingestion-cluster-link-creation-error", "ingestion-cluster-link-creation-error-delta", "data_catalog", "Windowed sum of cluster link creation error during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_LINK_CREATION_ERROR_TOTAL_MD("ingestion-cluster-link-creation-error", "ingestion-cluster-link-creation-error-total", "data_catalog", "Number of cluster link creation error during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_LINK_DELETION_COUNT_MD("ingestion-cluster-link-deletion", "ingestion-cluster-link-deletion-delta", "data_catalog", "Windowed sum of cluster link deletion during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_LINK_DELETION_TOTAL_MD("ingestion-cluster-link-deletion", "ingestion-cluster-link-deletion-total", "data_catalog", "Number of cluster link deletion during ingestion transformation", CumulativeSum::new),
        INGESTION_CLUSTER_LINK_DELETION_ERROR_COUNT_MD("ingestion-cluster-link-deletion-error", "ingestion-cluster-link-deletion-error-delta", "data_catalog", "Windowed sum of cluster link deletion error during ingestion transformation", WindowedSum::new),
        INGESTION_CLUSTER_LINK_DELETION_ERROR_TOTAL_MD("ingestion-cluster-link-deletion-error", "ingestion-cluster-link-deletion-error-total", "data_catalog", "Number of cluster link deletion error during ingestion transformation", CumulativeSum::new),
        INGESTION_ENVIRONMENT_CREATION_COUNT_MD("ingestion-environment-creation", "ingestion-environment-creation-delta", "data_catalog", "Windowed sum of environment creation during ingestion transformation", WindowedSum::new),
        INGESTION_ENVIRONMENT_CREATION_TOTAL_MD("ingestion-environment-creation", "ingestion-environment-creation-total", "data_catalog", "Number of environment creation during ingestion transformation", CumulativeSum::new),
        INGESTION_ENVIRONMENT_CREATION_ERROR_COUNT_MD("ingestion-environment-creation-error", "ingestion-environment-creation-error-delta", "data_catalog", "Windowed sum of environment creation error during ingestion transformation", WindowedSum::new),
        INGESTION_ENVIRONMENT_CREATION_ERROR_TOTAL_MD("ingestion-environment-creation-error", "ingestion-environment-creation-error-total", "data_catalog", "Number of environment creation error during ingestion transformation", CumulativeSum::new),
        INGESTION_ENVIRONMENT_DELETION_COUNT_MD("ingestion-environment-deletion", "ingestion-environment-deletion-delta", "data_catalog", "Windowed sum of environment deletion during ingestion transformation", WindowedSum::new),
        INGESTION_ENVIRONMENT_DELETION_TOTAL_MD("ingestion-environment-deletion", "ingestion-environment-deletion-total", "data_catalog", "Number of environment deletion during ingestion transformation", CumulativeSum::new),
        INGESTION_ENVIRONMENT_DELETION_ERROR_COUNT_MD("ingestion-environment-deletion-error", "ingestion-environment-deletion-error-delta", "data_catalog", "Windowed sum of environment deletion error during ingestion transformation", WindowedSum::new),
        INGESTION_ENVIRONMENT_DELETION_ERROR_TOTAL_MD("ingestion-environment-deletion-error", "ingestion-environment-deletion-error-total", "data_catalog", "Number of environment deletion error during ingestion transformation", CumulativeSum::new),
        RECONCILIATION_CLUSTER_COUNT_MD("reconciliation-cluster", "reconciliation-cluster-delta", "data_catalog", "Windowed sum of cluster reconciliation", WindowedSum::new),
        RECONCILIATION_CLUSTER_TOTAL_MD("reconciliation-cluster", "reconciliation-cluster-total", "data_catalog", "Number of cluster reconciliation", CumulativeSum::new),
        RECONCILIATION_CLUSTER_ERROR_COUNT_MD("reconciliation-cluster-error", "reconciliation-cluster-error-delta", "data_catalog", "Windowed sum of cluster reconciliation error", WindowedSum::new),
        RECONCILIATION_CLUSTER_ERROR_TOTAL_MD("reconciliation-cluster-error", "reconciliation-cluster-error-total", "data_catalog", "Number of cluster reconciliation error", CumulativeSum::new),
        RECONCILIATION_TOPIC_COUNT_MD("reconciliation-topic", "reconciliation-topic-delta", "data_catalog", "Windowed sum of topic reconciliation", WindowedSum::new),
        RECONCILIATION_TOPIC_TOTAL_MD("reconciliation-topic", "reconciliation-topic-total", "data_catalog", "Number of topic reconciliation", CumulativeSum::new),
        RECONCILIATION_TOPIC_ERROR_COUNT_MD("reconciliation-topic-error", "reconciliation-topic-error-delta", "data_catalog", "Windowed sum of topic reconciliation error", WindowedSum::new),
        RECONCILIATION_TOPIC_ERROR_TOTAL_MD("reconciliation-topic-error", "reconciliation-topic-error-total", "data_catalog", "Number of topic reconciliation error", CumulativeSum::new),
        RECONCILIATION_CLUSTER_TIME_LATENCY_AVG_MD("reconciliation-cluster-time", "reconciliation-cluster-time-latency-avg", "data_catalog", "Cluster reconciliation average latency in ms", Avg::new),
        RECONCILIATION_CLUSTER_TIME_LATENCY_P99_MD("reconciliation-cluster-time", "reconciliation-cluster-time-latency-99", "data_catalog", "Cluster reconciliation 99th percentile latency in ms", null, 99.0),
        RECONCILIATION_TOPIC_TIME_LATENCY_AVG_MD("reconciliation-topic-time", "reconciliation-topic-time-latency-avg", "data_catalog", "Topic reconciliation average latency in ms", Avg::new),
        RECONCILIATION_TOPIC_TIME_LATENCY_P99_MD("reconciliation-topic-time", "reconciliation-topic-time-latency-99", "data_catalog", "Topic reconciliation 99th percentile latency in ms", null, 99.0),
        JANUSGRAPH_NPE_ERROR_COUNT_MD("janusgraph-npe-error", "janusgraph-npe-error-delta", "data_catalog", "Windowed sum of Janus Graph NPE errors", WindowedSum::new),
        JANUSGRAPH_NPE_ERROR_TOTAL_MD("janusgraph-npe-error", "janusgraph-npe-error-total", "data_catalog", "Number of Janus Graph NPE errors", CumulativeSum::new);

        public final String sensorPrefix;
        public final String metricName;
        public final String group;
        public final String description;
        public final Supplier<MeasurableStat> statSupplier;
        public final double percentile;
        private static final ListMultimap<String, MetricDescriptor> lookup;

        private MetricDescriptor(String metricName, String group, String description, Supplier<MeasurableStat> statSupplier) {
            this.sensorPrefix = metricName;
            this.metricName = metricName;
            this.group = group;
            this.description = description;
            this.statSupplier = statSupplier;
            this.percentile = 0.0;
        }

        private MetricDescriptor(String sensorPrefix, String metricName, String group, String description, Supplier<MeasurableStat> statSupplier) {
            this(sensorPrefix, metricName, group, description, statSupplier, 0.0);
        }

        private MetricDescriptor(String sensorPrefix, String metricName, String group, String description, Supplier<MeasurableStat> statSupplier, double percentile) {
            this.sensorPrefix = sensorPrefix;
            this.metricName = metricName;
            this.group = group;
            this.description = description;
            this.statSupplier = statSupplier;
            this.percentile = percentile;
        }

        public static List<MetricDescriptor> get(String name) {
            return lookup.get((Object)name.toLowerCase(Locale.ROOT));
        }

        static {
            lookup = ArrayListMultimap.create();
            for (MetricDescriptor md : EnumSet.allOf(MetricDescriptor.class)) {
                lookup.put((Object)md.sensorPrefix, (Object)md);
            }
        }
    }

    private class MetricSensor {
        private final AtomicLong count = new AtomicLong(0L);
        private final Sensor sensor;

        public MetricSensor(String tenant, MetricDescriptor md, String tagKey, String tagValue) {
            this(tenant, md.sensorPrefix, Collections.singletonList(md), tagKey, tagValue);
        }

        public MetricSensor(String tenant, String sensorPrefix, List<MetricDescriptor> mds, String tagKey, String tagValue) {
            String sensorName = sensorPrefix;
            if (tenant != null) {
                sensorName = sensorName + "." + tenant;
            }
            if (tagKey != null) {
                sensorName = sensorName + "." + tagKey + "." + tagValue;
            }
            this.sensor = MetricsManager.this.metrics.sensor(sensorName);
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            if (tenant != null) {
                tags.put(MetricsManager.TENANT_TAG, tenant);
            }
            if (tagKey != null) {
                tags.put(tagKey, tagValue);
            }
            for (MetricDescriptor md : mds) {
                MetricName metricName = new MetricName(md.metricName, md.group, md.description, tags);
                if (md.percentile > 0.0) {
                    Percentiles percs = new Percentiles(800, 0.0, PERCENTILE_MAX_LATENCY_IN_MS, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(metricName, md.percentile)});
                    this.sensor.add((CompoundStat)percs);
                    continue;
                }
                this.sensor.add(metricName, md.statSupplier.get());
            }
        }

        public long get() {
            return this.count.get();
        }

        public void add(long delta) {
            this.sensor.record((double)this.count.addAndGet(delta));
        }

        public void set(long number) {
            this.count.set(number);
            this.sensor.record((double)number);
        }

        public void record(double value) {
            this.sensor.record(value);
        }

        public void reset() {
            this.count.set(0L);
            this.sensor.record(0.0);
        }
    }

    private class TenantMetrics {
        private final String tenant;
        private final Map<String, MetricSensor> sensors = new ConcurrentHashMap<String, MetricSensor>();

        public TenantMetrics(String tenant) {
            this.tenant = tenant;
        }

        private MetricSensor getSensor(MetricDescriptor md, String tagKey, String tagValue) {
            String sensorName = tagKey == null ? md.sensorPrefix + "." + this.tenant : md.sensorPrefix + "." + this.tenant + "." + tagKey + "." + tagValue;
            return this.sensors.computeIfAbsent(sensorName, k -> new MetricSensor(this.tenant, md, tagKey, tagValue));
        }
    }

    private class GlobalMetrics {
        private final Map<String, MetricSensor> sensors = new ConcurrentHashMap<String, MetricSensor>();

        private GlobalMetrics() {
        }

        private MetricSensor getSensor(String sensorPrefix) {
            return this.sensors.computeIfAbsent(sensorPrefix, k -> new MetricSensor(null, sensorPrefix, MetricDescriptor.get(sensorPrefix), null, null));
        }

        public void record(String sensorPrefix, double value) {
            this.getSensor(sensorPrefix).record(value);
        }
    }

    private class AtlasMetricsUpdateTask
    implements StripedRunnable {
        private final String tenant;

        public AtlasMetricsUpdateTask(String tenant) {
            this.tenant = tenant;
        }

        @Override
        public Object getStripe() {
            return this.tenant;
        }

        @Override
        public void run() {
            this.doUpdate(this.tenant);
        }

        private void doUpdate(String tenant) {
            TenantMetrics tenantMetrics = MetricsManager.this.getOrCreateTenantMetrics(tenant);
            AtlasMetrics metrics = MetricsManager.this.metricsService.getMetrics(tenant);
            tenantMetrics.getSensor(MetricDescriptor.NUM_ENTITIES_MD, null, null).set(metrics.getNumericMetric("general", "entityCount").longValue());
            tenantMetrics.getSensor(MetricDescriptor.NUM_TAG_DEFS_MD, null, null).set(metrics.getNumericMetric("general", "tagCount").longValue());
            tenantMetrics.getSensor(MetricDescriptor.NUM_BM_DEFS_MD, null, null).set(metrics.getNumericMetric("general", "businessMetadataCount").longValue());
            Map counts = (Map)metrics.getMetric(MetricsManager.ENTITY_TAG, "entityActive");
            for (Map.Entry entry : counts.entrySet()) {
                tenantMetrics.getSensor(MetricDescriptor.NUM_ACTIVE_ENTITIES_PER_TYPE_MD, MetricsManager.ENTITY_TAG, (String)entry.getKey()).set((Long)entry.getValue());
            }
            counts = (Map)metrics.getMetric(MetricsManager.ENTITY_TAG, "entityDeleted");
            for (Map.Entry entry : counts.entrySet()) {
                tenantMetrics.getSensor(MetricDescriptor.NUM_DELETED_ENTITIES_PER_TYPE_MD, MetricsManager.ENTITY_TAG, (String)entry.getKey()).set((Long)entry.getValue());
            }
            counts = (Map)metrics.getMetric(MetricsManager.TAG_TAG, "tagCountPerType");
            for (Map.Entry entry : counts.entrySet()) {
                tenantMetrics.getSensor(MetricDescriptor.NUM_TAGS_PER_TYPE_MD, MetricsManager.ENTITY_TAG, (String)entry.getKey()).set((Long)entry.getValue());
            }
            counts = (Map)metrics.getMetric(MetricsManager.TAG_TAG, "tagEntities");
            for (Map.Entry entry : counts.entrySet()) {
                tenantMetrics.getSensor(MetricDescriptor.NUM_ENTITIES_PER_TAG_MD, MetricsManager.TAG_TAG, (String)entry.getKey()).set((Long)entry.getValue());
            }
            counts = (Map)metrics.getMetric("businessMetadata", "businessMetadataCountPerType");
            for (Map.Entry entry : counts.entrySet()) {
                tenantMetrics.getSensor(MetricDescriptor.NUM_BM_PER_TYPE_MD, MetricsManager.ENTITY_TAG, (String)entry.getKey()).set((Long)entry.getValue());
            }
            counts = (Map)metrics.getMetric("businessMetadata", "businessMetadataEntities");
            for (Map.Entry entry : counts.entrySet()) {
                tenantMetrics.getSensor(MetricDescriptor.NUM_ENTITIES_PER_BM_MD, MetricsManager.BM_TAG, (String)entry.getKey()).set((Long)entry.getValue());
            }
            counts = (Map)metrics.getMetric("businessMetadata", "businessMetadataAttrs");
            for (Map.Entry entry : counts.entrySet()) {
                tenantMetrics.getSensor(MetricDescriptor.NUM_ATTRS_PER_BM_MD, MetricsManager.BM_TAG, (String)entry.getKey()).set((Long)entry.getValue());
            }
        }
    }
}

