/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.model;

import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;

public class ModelConstants {
    public static final Date UNIX_ZERO_EPOCH = new Date(0L);
    public static final String ATTR_CREATE_TIME = "createTime";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NAME_LOWER = "nameLower";
    public static final String ATTR_OWNER = "owner";
    public static final String ATTR_OWNER_EMAIL = "ownerEmail";
    public static final String ATTR_QUALIFIED_NAME = "qualifiedName";
    public static final String ATTR_TENANT = "tenant";
    public static final String ATTR_UPDATE_TIME = "updateTime";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_METHOD = "method";
    public static final String ATTR_EMBEDDED_TAGS = "embeddedTags";
    public static final String ATTR_DEPRECATED_TIME = "deprecatedTime";
    public static final String ATTR_CONTEXT = "context";
    public static final String ATTR_CLUSTER_ID = "clusterId";
    public static final String ENTITY_CN_CONNECTOR = EntityTypes.CN_CONNECTOR.getName();
    public static final String ENTITY_CF_ENVIRONMENT = EntityTypes.CF_ENVIRONMENT.getName();
    public static final String ENTITY_KSQL_LOGICAL_CLUSTER = EntityTypes.KSQL_LOGICAL_CLUSTER.getName();
    public static final String ENTITY_KSQL_STREAM = EntityTypes.KSQL_STREAM.getName();
    public static final String ENTITY_KSQL_TABLE = EntityTypes.KSQL_TABLE.getName();
    public static final String ENTITY_KSQL_QUERY = EntityTypes.KSQL_QUERY.getName();
    public static final String RELN_KSQL_LOGICAL_CLUSTER = "ksql_logical_cluster";
    public static final String ENTITY_PL_PIPELINE = EntityTypes.PL_PIPELINE.getName();
    public static final String ATTR_TOPIC_COUNT = "topicCount";
    public static final String ATTR_CONNECTOR_COUNT = "connectorCount";
    public static final String ATTR_STREAM_COUNT = "streamCount";
    public static final String ATTR_TABLE_COUNT = "tableCount";
    public static final String ATTR_QUERY_COUNT = "queryCount";
    public static final String RELN_KAFKA_LOGICAL_CLUSTER = "kafka_logical_cluster";
    public static final String RELN_INPUT_TOPICS = "input_topics";
    public static final String RELN_OUTPUT_TOPICS = "output_topics";
    public static final String RELN_ACTIVATED_TOPICS = "activated_topics";
    public static final String RELN_ACTIVATED_CONNECTORS = "activated_connectors";
    public static final String RELN_ACTIVATED_STREAMS = "activated_streams";
    public static final String RELN_ACTIVATED_TABLES = "activated_tables";
    public static final String ATTR_CREATED_BY = "createdBy";
    public static final String ATTR_UPDATED_BY = "updatedBy";
    public static final String ATTR_ACTIVATE_TIME = "activateTime";
    public static final String ATTR_ACTIVATED_BY = "activatedBy";
    public static final String ENTITY_KAFKA_LOGICAL_CLUSTER = EntityTypes.KAFKA_LOGICAL_CLUSTER.getName();
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_SKU = "sku";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_PROVIDER = "provider";
    public static final String ATTR_REGION = "region";
    public static final String ATTR_AVAILABILITY = "availability";
    public static final String ATTR_CKU = "cku";
    public static final String ATTR_NETWORK = "network";
    public static final String ATTR_DEACTIVATE_TIME = "deactivateTime";
    public static final String ENTITY_KAFKA_TOPIC = EntityTypes.KAFKA_TOPIC.getName();
    public static final String RELN_LOGICAL_CLUSTER = "logical_cluster";
    public static final String RELN_TOPICS = "topics";
    public static final String RELN_CLUSTER_LINK = "cluster_link";
    public static final String ATTR_RETENTION_MS = "retentionMs";
    public static final String ATTR_RETENTION_BYTES = "retentionBytes";
    public static final String ATTR_REPLICATION_FACTOR = "replicationFactor";
    public static final String ATTR_PARTITIONS_COUNT = "partitionsCount";
    public static final String ATTR_CLEANUP_POLICY = "cleanupPolicy";
    public static final String ATTR_KEY_SCHEMA_VALIDATION = "keySchemaValidation";
    public static final String ATTR_VALUE_SCHEMA_VALIDATION = "valueSchemaValidation";
    public static final String ATTR_IS_INTERNAL = "isInternal";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_TASKS_MAX = "tasksMax";
    public static final String ATTR_KAFKA_AUTH_MODE = "kafkaAuthMode";
    public static final String ATTR_KAFKA_SERVICE_ACCOUNT_ID = "kafkaServiceAccountId";
    public static final String ATTR_KAFKA_API_KEY = "kafkaApiKey";
    public static final String ATTR_DLQ_TOPIC = "dlqTopic";
    public static final String ATTR_INPUT_FORMAT = "inputFormat";
    public static final String ATTR_OUTPUT_FORMAT = "outputFormat";
    public static final String ATTR_SOURCE_SCHEMA = "sourceSchema";
    public static final String ATTR_SOURCE_ENDPOINT = "sourceEndpoint";
    public static final String ATTR_MIRROR_TOPIC_STATE = "mirrorTopicState";
    public static final String ATTR_MIRROR_TOPIC_UPDATE_TIME = "mirrorTopicUpdateTime";
    public static final String ATTR_EXTERNAL_SOURCE_TOPIC_NAME = "externalSourceTopicName";
    public static final String ATTR_EXTERNAL_SOURCE_TOPIC_ID = "externalSourceTopicId";
    public static final String ATTR_COMPRESSION_TYPE = "compressionType";
    public static final String ATTR_FILE_DELETE_DELAY_MS = "fileDeleteDelayMs";
    public static final String ATTR_FLUSH_MESSAGES = "flushMessages";
    public static final String ATTR_FLUSH_MS = "flushMs";
    public static final String ATTR_FOLLOWER_REPLICATION_THROTTLED_REPLICAS = "followerReplicationThrottledReplicas";
    public static final String ATTR_LEADER_REPLICATION_THROTTLED_REPLICAS = "leaderReplicationThrottledReplicas";
    public static final String ATTR_INDEX_INTERVAL_BYTES = "indexIntervalBytes";
    public static final String ATTR_MAX_COMPACTION_LAG_MS = "maxCompactionLagMs";
    public static final String ATTR_MAX_MESSAGE_BYTES = "maxMessageBytes";
    public static final String ATTR_MESSAGE_DOWNCONVERSION_ENABLE = "messageDownconversionEnable";
    public static final String ATTR_MESSAGE_FORMAT_VERSION = "messageFormatVersion";
    public static final String ATTR_MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS = "messageTimestampDifferenceMaxMs";
    public static final String ATTR_MESSAGE_TIMESTAMP_TYPE = "messageTimestampType";
    public static final String ATTR_MIN_CLEANABLE_DIRTY_RATIO = "minCleanableDirtyRatio";
    public static final String ATTR_MIN_COMPACTION_LAG_MS = "minCompactionLagMs";
    public static final String ATTR_MIN_INSYNC_REPLICAS = "minInsyncReplicas";
    public static final String ATTR_PREALLOCATE = "preallocate";
    public static final String ATTR_SEGMENT_BYTES = "segmentBytes";
    public static final String ATTR_SEGMENT_INDEX_BYTES = "segmentIndexBytes";
    public static final String ATTR_SEGMENT_JITTER_MS = "segmentJitterMs";
    public static final String ATTR_SEGMENT_MS = "segmentMs";
    public static final String ATTR_UNCLEAN_LEADER_ELECTION_ENABLE = "uncleanLeaderElectionEnable";
    public static final String ATTR_DELETE_RETENTION_MS = "deleteRetentionMs";
    public static final String RELN_SOURCE_TOPIC = "source_topic";
    public static final String ENTITY_KAFKA_CLUSTER_LINK = EntityTypes.KAFKA_CLUSTER_LINK.getName();
    public static final String ATTR_LINK_MODE = "linkMode";
    public static final String ATTR_CONNECTION_MODE = "connectionMode";
    public static final String ATTR_EXTERNAL_SOURCE_CLUSTER = "externalSourceCluster";
    public static final String RELN_SOURCE_CLUSTER = "source_cluster";
    public static final String RELN_DESTINATION_CLUSTER = "destination_cluster";
    public static final String ATTR_STREAM_SHARE_TOPIC_DISPLAY_NAME = "__ss_topicDisplayName";
    public static final String ATTR_STREAM_SHARE_ORG_DESCRIPTION = "__ss_orgDescription";
    public static final String ATTR_STREAM_SHARE_ORG_EMAIL = "__ss_orgEmail";
    public static final String ATTR_STREAM_SHARE_ORG_LOGO = "__ss_orgLogo";
    public static final String PREFIX_CF = "cf_";
    public static final String PREFIX_CONNECT = "cn_";
    public static final String PREFIX_KAFKA = "kafka_";
    public static final String PREFIX_KSQL = "ksql_";
    public static final String PREFIX_PIPELINE = "pl_";
    public static final String PREFIX_SR = "sr_";
    public static final String PREFIX_INTERNAL = "__";
    public static final String CLUSTER_PREFIX_CONNECT = "lcc-";
    public static final String CLUSTER_PREFIX_KAFKA = "lkc-";
    public static final String CLUSTER_PREFIX_KSQL = "lksqlc-";
    public static final String CLUSTER_PREFIX_SR = "lsrc-";
    public static final Set<String> ALL_PREFIXES = ImmutableSet.of((Object)"cf_", (Object)"cn_", (Object)"kafka_", (Object)"ksql_", (Object)"pl_", (Object)"sr_", (Object[])new String[0]);

    public static boolean hasValidPrefix(String name) {
        int index = name.indexOf("_");
        if (index <= 0) {
            return false;
        }
        String prefix = name.substring(0, index + 1);
        return ALL_PREFIXES.contains(prefix);
    }

    public static enum EntityTypes {
        CN_CONNECTOR,
        CF_ENVIRONMENT,
        KAFKA_CLUSTER_LINK,
        KAFKA_LOGICAL_CLUSTER,
        KAFKA_TOPIC,
        KSQL_LOGICAL_CLUSTER,
        KSQL_STREAM,
        KSQL_TABLE,
        KSQL_QUERY,
        PL_PIPELINE;

        private static final EnumHashBiMap<EntityTypes, String> lookup;
        private final String symbol = this.name().toLowerCase();

        public String getName() {
            return this.symbol;
        }

        public static EntityTypes get(String symbol) {
            return (EntityTypes)((Object)lookup.inverse().get((Object)symbol));
        }

        public String toString() {
            return this.getName();
        }

        static {
            lookup = EnumHashBiMap.create(EntityTypes.class);
            for (EntityTypes type : EntityTypes.values()) {
                lookup.put((Enum)type, (Object)type.getName());
            }
        }
    }
}

