/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.catalog.util.QualifiedNameGenerator;
import java.util.Objects;
import org.apache.atlas.model.instance.AtlasStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BusinessMetadata
extends AtlasStruct {
    private static final Logger LOG = LoggerFactory.getLogger(BusinessMetadata.class);
    private String entityType;
    private String entityName;

    public BusinessMetadata() {
        super(null, null);
    }

    public BusinessMetadata(AtlasStruct other, String entityType, String entityName) {
        super(other);
        this.entityType = entityType;
        this.entityName = entityName;
    }

    public BusinessMetadata(BusinessMetadata other) {
        super((AtlasStruct)other);
        this.entityType = other.entityType;
        this.entityName = other.entityName;
    }

    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @JsonProperty(value="entityName")
    public String getEntityName() {
        return this.entityName;
    }

    @JsonProperty(value="entityName")
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void ensureTenantPrefix(String tenant) {
        this.setTypeName(QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, this.getTypeName()));
        this.setEntityName(QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, this.getEntityType(), this.getEntityName()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BusinessMetadata businessMetadata = (BusinessMetadata)((Object)o);
        return this.entityType.equals(businessMetadata.entityType) && this.entityName.equals(businessMetadata.entityName);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entityType, this.entityName);
    }
}

