/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.catalog.model.instance.SchemaTags;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="The schemas metadata (tags, metadata and ruleset) to update for a subject")
public class SchemaMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaMetadata.class);
    private String subject;
    private Integer version;
    private Integer id;
    private List<SchemaTags> tagsToAdd;
    private List<SchemaTags> tagsToRemove;
    private Metadata metadata;
    private RuleSet ruleSet;

    public SchemaMetadata() {
    }

    @JsonCreator
    public SchemaMetadata(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") int version, @JsonProperty(value="id") int id, @JsonProperty(value="tagsToAdd") List<SchemaTags> tagsToAdd, @JsonProperty(value="tagsToRemove") List<SchemaTags> tagsToRemove, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="ruleSet") RuleSet ruleSet) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.tagsToAdd = tagsToAdd == null ? Collections.emptyList() : Collections.unmodifiableList(tagsToAdd);
        this.tagsToRemove = tagsToRemove == null ? Collections.emptyList() : Collections.unmodifiableList(tagsToRemove);
        this.metadata = metadata;
        this.ruleSet = ruleSet;
    }

    public static SchemaMetadata fromJson(String json) throws IOException {
        return (SchemaMetadata)JacksonMapper.INSTANCE.readValue(json, SchemaMetadata.class);
    }

    @Schema(description="The qualified subject name")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Schema(description="The new version")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Schema(description="The schema id where the schema metadata will be added to")
    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="tagsToAdd")
    public List<SchemaTags> getTagsToAdd() {
        return this.tagsToAdd;
    }

    @JsonProperty(value="tagsToAdd")
    public void setTagsToAdd(List<SchemaTags> tagsToAdd) {
        this.tagsToAdd = tagsToAdd;
    }

    @JsonProperty(value="tagsToRemove")
    public List<SchemaTags> getTagsToRemove() {
        return this.tagsToRemove;
    }

    @JsonProperty(value="tagsToRemove")
    public void setTagsToRemove(List<SchemaTags> tagsToRemove) {
        this.tagsToRemove = tagsToRemove;
    }

    @Schema(description="User-defined metadata")
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Schema(description="Schema rule set")
    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaMetadata schemaMetadata = (SchemaMetadata)o;
        return Objects.equals(this.subject, schemaMetadata.subject) && Integer.compare(this.version, schemaMetadata.version) == 0 && Integer.compare(this.id, schemaMetadata.id) == 0 && Objects.equals(this.tagsToAdd, schemaMetadata.tagsToAdd) && Objects.equals(this.tagsToRemove, schemaMetadata.tagsToRemove) && Objects.equals(this.metadata, schemaMetadata.metadata) && Objects.equals(this.ruleSet, schemaMetadata.ruleSet);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.version, this.id, this.tagsToAdd, this.tagsToRemove, this.metadata, this.ruleSet);
    }
}

