/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.confluent.catalog.util.QualifiedNameGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TagDef
extends AtlasClassificationDef {
    private static final Logger LOG = LoggerFactory.getLogger(TagDef.class);
    public static final TagColor DEFAULT_TAG_COLOR = TagColor.DEFAULT_COLOR;
    public static final String COLOR_ATTRIBUTE = "__color";
    private TagColor color = null;

    public TagDef() {
        this(null, null, null, null, null, null);
    }

    public TagDef(String name) {
        this(name, null, null, null, null, null);
    }

    public TagDef(String name, String description) {
        this(name, description, null, null, null, null);
    }

    public TagDef(String name, String description, String typeVersion) {
        this(name, description, typeVersion, null, null, null);
    }

    public TagDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        this(name, description, typeVersion, attributeDefs, null, null);
    }

    public TagDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes) {
        this(name, description, typeVersion, attributeDefs, superTypes, null);
    }

    public TagDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes, Map<String, String> options) {
        this(name, description, typeVersion, attributeDefs, superTypes, null, options);
    }

    public TagDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes, Set<String> entityTypes, Map<String, String> options) {
        super(name, description, typeVersion, attributeDefs, superTypes, entityTypes, options);
    }

    public TagDef(AtlasClassificationDef other) {
        super(other);
        this.setEntityTypes(other.getEntityTypes());
    }

    public void ensureTenantPrefix(String tenant) {
        this.setName(QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, this.getName()));
    }

    public TagColor getColor() {
        TagColor newColor;
        if (this.color != null) {
            return this.color;
        }
        try {
            AtlasStructDef.AtlasAttributeDef attributeDef = this.getAttribute(COLOR_ATTRIBUTE);
            newColor = TagColor.valueOf(attributeDef.getDefaultValue());
        }
        catch (Exception e) {
            newColor = DEFAULT_TAG_COLOR;
        }
        this.color = newColor;
        return this.color;
    }

    public void setColor(TagColor inputColor) {
        this.color = inputColor;
        AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef(COLOR_ATTRIBUTE, "string");
        attributeDef.setIsOptional(true);
        attributeDef.setDefaultValue(inputColor.name());
        this.addAttribute(attributeDef);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && ((Object)((Object)this)).getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            TagDef that = (TagDef)((Object)o);
            return Objects.equals((Object)this.color, (Object)that.getColor());
        }
        return false;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("TagDef{");
        super.toString(sb);
        sb.append(", color=");
        sb.append((Object)this.color);
        sb.append('}');
        return sb;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.color});
    }

    public static enum TagColor {
        DEFAULT_COLOR,
        PURPLE_LIGHT,
        PURPLE_DARK,
        BLUE_LIGHT,
        BLUE_DARK,
        GREEN_LIGHT,
        GREEN_DARK,
        YELLOW_LIGHT,
        YELLOW_DARK,
        ORANGE_LIGHT,
        ORANGE_DARK,
        RED_LIGHT,
        RED_DARK,
        MAGENTA_LIGHT,
        MAGENTA_DARK,
        NEUTRAL_LIGHT,
        NEUTRAL_DARK;

    }
}

