/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.notification;

import io.confluent.catalog.notification.CatalogEntityHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.EntityChangeListenerV2;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasRelationshipHeader;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractEntityNotificationListener
implements EntityChangeListenerV2 {
    private final AtlasTypeRegistry typeRegistry;

    public AbstractEntityNotificationListener(AtlasTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void onEntitiesAdded(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.ENTITY_CREATE);
    }

    public void onEntitiesUpdated(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.ENTITY_UPDATE);
    }

    public void onEntitiesDeleted(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.ENTITY_DELETE);
    }

    public void onEntitiesPurged(List<AtlasEntity> entities) throws AtlasBaseException {
    }

    public void onClassificationsAdded(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_ADD);
    }

    public void onClassificationsAdded(List<AtlasEntity> entities, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_ADD);
    }

    public void onClassificationsUpdated(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        Map addedPropagations = RequestContext.get().getAddedPropagations();
        Map removedPropagations = RequestContext.get().getRemovedPropagations();
        if (addedPropagations.containsKey(entity.getGuid())) {
            this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_ADD);
        } else if (!removedPropagations.containsKey(entity.getGuid())) {
            this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_UPDATE);
        }
    }

    public void onClassificationsDeleted(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(Collections.singletonList(entity), EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_DELETE);
    }

    public void onClassificationsDeleted(List<AtlasEntity> entities, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.notifyEntityEvents(entities, EntityNotification.EntityNotificationV2.OperationType.CLASSIFICATION_DELETE);
    }

    public void onTermAdded(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) {
    }

    public void onTermDeleted(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) {
    }

    public void onLabelsDeleted(AtlasEntity entity, Set<String> labels) throws AtlasBaseException {
    }

    public void onLabelsAdded(AtlasEntity entity, Set<String> labels) throws AtlasBaseException {
    }

    protected abstract void notifyEntityEvents(List<AtlasEntity> var1, EntityNotification.EntityNotificationV2.OperationType var2) throws AtlasBaseException;

    protected abstract void notifyRelationshipEvents(List<AtlasRelationship> var1, EntityNotification.EntityNotificationV2.OperationType var2) throws AtlasBaseException;

    protected AtlasEntityHeader toNotificationHeader(AtlasEntity entity) throws AtlasBaseException {
        AtlasEntityType entityType;
        Object displayText;
        CatalogEntityHeader ret = new CatalogEntityHeader(entity.getTypeName(), entity.getGuid(), new HashMap<String, Object>());
        ret.setGuid(entity.getGuid());
        ret.setStatus(entity.getStatus());
        ret.setIsIncomplete(entity.getIsIncomplete());
        Object name = entity.getAttribute("name");
        this.setAttribute(ret, "name", name);
        this.setAttribute(ret, "description", entity.getAttribute("description"));
        this.setAttribute(ret, "owner", entity.getAttribute("owner"));
        this.setAttribute(ret, "createTime", entity.getAttribute("createTime"));
        Object object = displayText = name != null ? name : entity.getAttribute("qualifiedName");
        if (displayText != null) {
            ret.setDisplayText(displayText.toString());
        }
        if ((entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName())) != null) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                Object attrValue;
                if (!attribute.getAttributeDef().getIsUnique() && !attribute.getAttributeDef().getIncludeInNotification() || (attrValue = entity.getAttribute(attribute.getName())) == null) continue;
                ret.setAttribute(attribute.getName(), attrValue);
            }
            if (MapUtils.isNotEmpty((Map)entity.getRelationshipAttributes())) {
                entity.getRelationshipAttributes().entrySet().forEach(kv -> ret.setRelationship((String)kv.getKey(), kv.getValue()));
            }
            if (CollectionUtils.isNotEmpty((Collection)entity.getClassifications())) {
                ArrayList<AtlasClassification> classifications = new ArrayList<AtlasClassification>(entity.getClassifications().size());
                ArrayList<String> classificationNames = new ArrayList<String>(entity.getClassifications().size());
                for (AtlasClassification classification : this.getAllClassifications(entity.getClassifications())) {
                    classifications.add(classification);
                    classificationNames.add(classification.getTypeName());
                }
                ret.setClassifications(classifications);
                ret.setClassificationNames(classificationNames);
            }
        }
        return ret;
    }

    protected AtlasRelationshipHeader toNotificationHeader(AtlasRelationship relationship) {
        return new AtlasRelationshipHeader(relationship);
    }

    private void setAttribute(AtlasEntityHeader entity, String attrName, Object attrValue) {
        if (attrValue != null) {
            entity.setAttribute(attrName, attrValue);
        }
    }

    private List<AtlasClassification> getAllClassifications(List<AtlasClassification> classifications) {
        ArrayList<AtlasClassification> ret = new ArrayList<AtlasClassification>();
        if (CollectionUtils.isNotEmpty(classifications)) {
            for (AtlasClassification classification : classifications) {
                AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification.getTypeName());
                Set superTypeNames = classificationType != null ? classificationType.getAllSuperTypes() : null;
                ret.add(classification);
                if (!CollectionUtils.isNotEmpty((Collection)superTypeNames)) continue;
                for (String superTypeName : superTypeNames) {
                    AtlasClassificationType superType;
                    AtlasClassification superTypeClassification = new AtlasClassification(superTypeName);
                    superTypeClassification.setEntityGuid(classification.getEntityGuid());
                    superTypeClassification.setPropagate(classification.isPropagate());
                    if (MapUtils.isNotEmpty((Map)classification.getAttributes()) && (superType = this.typeRegistry.getClassificationTypeByName(superTypeName)) != null && MapUtils.isNotEmpty((Map)superType.getAllAttributes())) {
                        HashMap superTypeClassificationAttributes = new HashMap();
                        for (Map.Entry attrEntry : classification.getAttributes().entrySet()) {
                            String attrName = (String)attrEntry.getKey();
                            if (!superType.getAllAttributes().containsKey(attrName)) continue;
                            superTypeClassificationAttributes.put(attrName, attrEntry.getValue());
                        }
                        superTypeClassification.setAttributes(superTypeClassificationAttributes);
                    }
                    ret.add(superTypeClassification);
                }
            }
        }
        return ret;
    }

    public void onRelationshipsAdded(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        this.notifyRelationshipEvents(relationships, EntityNotification.EntityNotificationV2.OperationType.RELATIONSHIP_CREATE);
    }

    public void onRelationshipsUpdated(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        this.notifyRelationshipEvents(relationships, EntityNotification.EntityNotificationV2.OperationType.RELATIONSHIP_UPDATE);
    }

    public void onRelationshipsDeleted(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        this.notifyRelationshipEvents(relationships, EntityNotification.EntityNotificationV2.OperationType.RELATIONSHIP_DELETE);
    }

    public void onRelationshipsPurged(List<AtlasRelationship> relationships) throws AtlasBaseException {
    }

    public void onBusinessAttributesUpdated(AtlasEntity entity, Map<String, Map<String, Object>> updatedBusinessAttributes) throws AtlasBaseException {
    }
}

