/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.notification;

import com.google.inject.Injector;
import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.notification.EntityNotificationListenerV2;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.atlas.exception.AtlasBaseException;

public class SnapshotManager {
    private final ExecutorService executorService;
    private final Map<String, Future<?>> activeRequests = new ConcurrentHashMap();
    EntityNotificationListenerV2 entityNotificationListenerV2;

    public SnapshotManager() {
        int numThreads = 5;
        this.executorService = Executors.newFixedThreadPool(numThreads);
    }

    public void submitSnapshotRequest(String name, String tenantName, SchemaAtlasHook hook) throws RuntimeException {
        Injector injector = hook.getInjector();
        this.entityNotificationListenerV2 = (EntityNotificationListenerV2)injector.getInstance(EntityNotificationListenerV2.class);
        if (!this.isSnapshotRequestActive(name)) {
            Future<?> future = this.executorService.submit(() -> {
                try {
                    this.entityNotificationListenerV2.republishEntity(tenantName);
                }
                catch (AtlasBaseException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.activeRequests.remove(name);
                }
            });
            this.activeRequests.put(name, future);
        }
    }

    public void cancelSnapshotRequest(String name) {
        Future<?> future = this.activeRequests.get(name);
        if (future != null) {
            future.cancel(true);
            this.activeRequests.remove(name);
        }
    }

    public boolean isSnapshotRequestActive(String name) {
        return this.activeRequests.containsKey(name);
    }
}

