/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.client.rest.CatalogRestService;
import io.confluent.catalog.hook.AtlasGraphUtils;
import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.hook.SchemaAtlasTypes;
import io.confluent.catalog.metrics.MetricsManager;
import io.confluent.catalog.model.ModelConstants;
import io.confluent.catalog.model.instance.BusinessMetadata;
import io.confluent.catalog.model.instance.SchemaMetadata;
import io.confluent.catalog.model.instance.Tag;
import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.catalog.notification.SnapshotManager;
import io.confluent.catalog.storage.BusinessMetadataDefValue;
import io.confluent.catalog.storage.BusinessMetadataValue;
import io.confluent.catalog.storage.EntitySearchService;
import io.confluent.catalog.storage.EntitySnapshot;
import io.confluent.catalog.storage.EntitySnapshotValue;
import io.confluent.catalog.storage.EntityValue;
import io.confluent.catalog.storage.MetadataRegistryKey;
import io.confluent.catalog.storage.MetadataRegistryKind;
import io.confluent.catalog.storage.MetadataRegistryOp;
import io.confluent.catalog.storage.MetadataRegistryUpdateHandler;
import io.confluent.catalog.storage.MetadataRegistryValue;
import io.confluent.catalog.storage.PersistentCaffeineCache;
import io.confluent.catalog.storage.TagDefValue;
import io.confluent.catalog.storage.TagValue;
import io.confluent.catalog.storage.serialization.MetadataRegistryKeySerde;
import io.confluent.catalog.storage.serialization.MetadataRegistryValueSerde;
import io.confluent.catalog.util.AtomicTimestampGenerator;
import io.confluent.catalog.util.JavaClock;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.web.errors.ExceptionMapperUtil;
import io.confluent.catalog.web.rest.entities.BusinessMetadataDefResponse;
import io.confluent.catalog.web.rest.entities.BusinessMetadataResponse;
import io.confluent.catalog.web.rest.entities.SchemaTagsResponse;
import io.confluent.catalog.web.rest.entities.TagDefResponse;
import io.confluent.catalog.web.rest.entities.TagResponse;
import io.confluent.catalog.web.rest.exceptions.RestInvalidTagException;
import io.confluent.catalog.web.rest.exceptions.RestInvalidTagOperationException;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.client.LocalSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.rest.client.RetryExecutor;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidSchemaException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.RestNotFoundException;
import io.kcache.Cache;
import io.kcache.CacheUpdateHandler;
import io.kcache.KafkaCache;
import io.kcache.KafkaCacheConfig;
import io.kcache.KeyValue;
import io.kcache.caffeine.CaffeineCache;
import io.kcache.exceptions.CacheInitializationException;
import io.kcache.exceptions.EntryTooLargeException;
import io.kcache.utils.Caches;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.ws.rs.core.UriBuilder;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.common.serialization.Serde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Singleton
@Service
public class MetadataRegistry
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MetadataRegistry.class);
    public static final String X_FORWARD_HEADER = "X-Forward";
    private static final String VERSION_PREFIX = "1.";
    private static final String DEFAULT_VERSION = "1.0";
    private static final String CONFLUENT_VERSION = "confluent:version";
    private static final int CACHE_SIZE = 10000;
    private static final Duration CACHE_EXPIRE_AFTER_WRITE = Duration.ofHours(1L);
    private static final AtlasBaseException UNKNOWN_ERROR = new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, new String[]{""});
    private static final TypeReference<EntityMutationResponse> ENTITY_MUTATION_RESPONSE_TYPE = new TypeReference<EntityMutationResponse>(){};
    private static final TypeReference<List<TagResponse>> LIST_TAGS_TYPE = new TypeReference<List<TagResponse>>(){};
    private static final TypeReference<List<TagDefResponse>> LIST_TAG_DEFS_TYPE = new TypeReference<List<TagDefResponse>>(){};
    private static final TypeReference<List<BusinessMetadataResponse>> LIST_BM_TYPE = new TypeReference<List<BusinessMetadataResponse>>(){};
    private static final TypeReference<List<BusinessMetadataDefResponse>> LIST_BM_DEFS_TYPE = new TypeReference<List<BusinessMetadataDefResponse>>(){};
    private static final TypeReference<List<SchemaTagsResponse>> LIST_SCHEMA_TAGS_TYPE = new TypeReference<List<SchemaTagsResponse>>(){};
    private static final TypeReference<String> STRING_TYPE = new TypeReference<String>(){};
    private static final TypeReference<Void> VOID_TYPE = new TypeReference<Void>(){};
    private static final String searchTypesForTags = String.join((CharSequence)",", SchemaAtlasTypes.SR_RECORD.getName(), SchemaAtlasTypes.SR_FIELD.getName());
    private final KafkaSchemaRegistry schemaRegistry;
    private final LocalSchemaRegistryClient schemaRegistryClient;
    private final RetryExecutor retryExecutor;
    private final AtlasGraph graph;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasEntityStore entityStore;
    private final AtlasTypeDefStore typeDefStore;
    private final AtlasGraphUtils atlasGraphUtils;
    private final EntitySearchService searchService;
    private final MetricsManager metricsManager;
    private final SnapshotManager snapshotManager;
    private final Map<String, AtlasEntity.AtlasEntityWithExtInfo> pendingCache;
    private final Cache<MetadataRegistryKey, MetadataRegistryValue<?>> localCache;
    final Cache<MetadataRegistryKey, MetadataRegistryValue<?>> kafkaCache;
    private final Cache<Long, ObjectWithException> errorCache;
    private final Map<String, Lock> tenantToLock = new ConcurrentHashMap<String, Lock>();
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final AtomicTimestampGenerator tsGenerator = new AtomicTimestampGenerator(new JavaClock());
    private final Boolean updateTagDefDefaultColor;
    private final String tagColorToUpdate;

    @Inject
    public MetadataRegistry(SchemaRegistry schemaRegistry, AtlasGraph graph, AtlasTypeRegistry typeRegistry, AtlasEntityStore entityStore, AtlasTypeDefStore typeDefStore, AtlasGraphUtils atlasGraphUtils, EntitySearchService searchService, MetricsManager metricsManager, SnapshotManager snapshotManager) {
        try {
            this.schemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
            List<SchemaProvider> providers = Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider());
            this.schemaRegistryClient = new LocalSchemaRegistryClient(this.schemaRegistry, providers);
            this.graph = graph;
            this.typeRegistry = typeRegistry;
            this.entityStore = entityStore;
            this.typeDefStore = typeDefStore;
            this.atlasGraphUtils = atlasGraphUtils;
            this.searchService = searchService;
            this.metricsManager = metricsManager;
            this.snapshotManager = snapshotManager;
            this.pendingCache = new ConcurrentHashMap<String, AtlasEntity.AtlasEntityWithExtInfo>();
            this.localCache = new PersistentCaffeineCache(10000, CACHE_EXPIRE_AFTER_WRITE, null);
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
            this.updateTagDefDefaultColor = dataCatalogConfig.getBoolean("catalog.tagdef.update.to.default.color");
            this.tagColorToUpdate = dataCatalogConfig.getString("catalog.tagdef.update.color");
            this.retryExecutor = new RetryExecutor(dataCatalogConfig.catalogMaxRetries(), dataCatalogConfig.catalogRetriesWaitMs());
            this.kafkaCache = this.createCache(dataCatalogConfig);
            this.errorCache = new CaffeineCache(Integer.valueOf(10000), CACHE_EXPIRE_AFTER_WRITE, null);
        }
        catch (RestConfigException e) {
            throw new CacheInitializationException("Could not initialize MetadataRegistry", (Throwable)e);
        }
    }

    public KafkaSchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    protected Cache<MetadataRegistryKey, MetadataRegistryValue<?>> createCache(DataCatalogConfig dataCatalogConfig) throws CacheInitializationException {
        Properties props = this.getKafkaCacheProperties(dataCatalogConfig);
        KafkaCacheConfig config = new KafkaCacheConfig((Map)props);
        Cache kafkaCache = Caches.concurrentCache((Cache)new KafkaCache(config, (Serde)new MetadataRegistryKeySerde(), (Serde)new MetadataRegistryValueSerde(), this.createHandler(), this.localCache));
        this.getSchemaRegistry().addLeaderChangeListener(isLeader -> {
            if (isLeader.booleanValue()) {
                kafkaCache.reset();
                kafkaCache.sync();
            }
        });
        return kafkaCache;
    }

    private Properties getKafkaCacheProperties(DataCatalogConfig dataCatalogConfig) throws CacheInitializationException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.schemaRegistry.config().originalProperties());
        Set<String> keys = props.stringPropertyNames();
        for (String key : keys) {
            String newKey;
            if (!key.startsWith("kafkastore.") || keys.contains(newKey = key.replace("kafkastore", "kafkacache"))) continue;
            props.put(newKey, props.get(key));
        }
        if (props.containsKey("catalog.topic")) {
            props.put("kafkacache.topic", props.get("catalog.topic"));
        }
        props.put("kafkacache.init.timeout.ms", (Object)Integer.MAX_VALUE);
        props.put("kafkacache.timeout.ms", (Object)Integer.MAX_VALUE);
        props.put("kafkacache.poll.timeout.ms", (Object)dataCatalogConfig.getCatalogIngestorBatchTimeoutMs());
        return props;
    }

    protected CacheUpdateHandler<MetadataRegistryKey, MetadataRegistryValue<?>> createHandler() {
        return new MetadataRegistryUpdateHandler(this, this.graph, this.typeRegistry, this.entityStore, this.typeDefStore, this.searchService, this.metricsManager, this.tsGenerator);
    }

    public SchemaRegistryConfig config() {
        return this.schemaRegistry.config();
    }

    public Map<String, Object> properties() {
        return this.schemaRegistry.properties();
    }

    public void init() {
        if (!this.initialized.get()) {
            this.kafkaCache.init();
            boolean isInitialized = this.initialized.compareAndSet(false, true);
            if (!isInitialized) {
                throw new IllegalStateException("Metadata registry was already initialized");
            }
            this.initLatch.countDown();
        }
    }

    public void waitForInit() throws InterruptedException {
        this.initLatch.await();
    }

    public boolean initialized() {
        return this.initialized.get();
    }

    public Map<String, AtlasEntity.AtlasEntityWithExtInfo> pendingCache() {
        return this.pendingCache;
    }

    public Cache<MetadataRegistryKey, MetadataRegistryValue<?>> localCache() {
        return this.localCache;
    }

    public boolean isLeader() {
        return this.schemaRegistry.isLeader();
    }

    private boolean isLeader(Map<String, String> headerProperties) {
        String forwardHeader = headerProperties.get(X_FORWARD_HEADER);
        return this.isLeader() && (forwardHeader == null || Boolean.parseBoolean(forwardHeader));
    }

    protected Lock lockFor(String tenant) {
        return this.tenantToLock.computeIfAbsent(tenant, k -> new ReentrantLock());
    }

    private void lock(String tenant, Map<String, String> headerProperties) {
        String forwardHeader = headerProperties.get(X_FORWARD_HEADER);
        if (forwardHeader == null || Boolean.parseBoolean(forwardHeader)) {
            this.lockFor(tenant).lock();
        }
    }

    private void unlock(String tenant) {
        if (((ReentrantLock)this.lockFor(tenant)).isHeldByCurrentThread()) {
            this.lockFor(tenant).unlock();
        }
    }

    public List<TagResponse> createTagsOrForward(String tenant, List<Tag> tags, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<TagResponse> list = this.createTags(tenant, tags);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<TagResponse> list = this.forwardCreateTagsRequestToLeader(tags, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private List<TagResponse> forwardCreateTagsRequestToLeader(List<Tag> tags, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/tags");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding create tags request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "POST", MetadataRegistry.toJson(tags), headerProperties, LIST_TAGS_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create tags request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<TagResponse> createTags(String tenant, List<Tag> tags) {
        this.kafkaCache.sync();
        ArrayList<TagResponse> ret = new ArrayList<TagResponse>();
        for (Tag tag : tags) {
            block8: {
                Tag oldTag = null;
                try {
                    oldTag = this.getTag(tenant, tag.getEntityType(), tag.getEntityName(), tag.getTypeName());
                }
                catch (AtlasBaseException atlasBaseException) {
                    // empty catch block
                }
                if (oldTag != null && oldTag.getEntityStatus() == AtlasEntity.Status.ACTIVE) {
                    AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_ALREADY_ASSOCIATED, new String[]{tag.getEntityName(), tag.getTypeName()});
                    ret.add(new TagResponse(tag, ExceptionMapperUtil.toErrorMessage(e)));
                    continue;
                }
                try {
                    if (!this.allowTagOperation(tag)) {
                        ret.add(new TagResponse(tag, RestInvalidTagOperationException.toErrorMessage(tag.getTypeName())));
                    }
                    break block8;
                }
                catch (AtlasBaseException e) {
                    ret.add(new TagResponse(tag, ExceptionMapperUtil.toErrorMessage(e)));
                }
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.TAG, tag.getTypeName(), null, null, tag.getEntityType(), tag.getEntityName());
            long now = this.tsGenerator.next();
            TagValue value = new TagValue(null, tag, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new TagResponse((Tag)((Object)((TagValue)newValue).getNewValue())));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new TagResponse(tag, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    public List<BusinessMetadataResponse> createBusinessMetadataOrForward(String tenant, List<BusinessMetadata> bms, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<BusinessMetadataResponse> list = this.createBusinessMetadata(tenant, bms);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<BusinessMetadataResponse> list = this.forwardCreateBusinessMetadataRequestToLeader(bms, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private List<BusinessMetadataResponse> forwardCreateBusinessMetadataRequestToLeader(List<BusinessMetadata> bms, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/businessmetadata");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding create bm request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "POST", MetadataRegistry.toJson(bms), headerProperties, LIST_BM_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create bm request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<BusinessMetadataResponse> createBusinessMetadata(String tenant, List<BusinessMetadata> bms) {
        this.kafkaCache.sync();
        ArrayList<BusinessMetadataResponse> ret = new ArrayList<BusinessMetadataResponse>();
        for (BusinessMetadata bm : bms) {
            BusinessMetadata oldBM = null;
            try {
                oldBM = this.getBusinessMetadata(tenant, bm.getEntityType(), bm.getEntityName(), bm.getTypeName());
            }
            catch (AtlasBaseException atlasBaseException) {
                // empty catch block
            }
            if (oldBM != null) {
                AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.BUSINESS_METADATA_ATTRIBUTE_ALREADY_EXISTS, new String[]{bm.getEntityName(), bm.getTypeName()});
                ret.add(new BusinessMetadataResponse(bm, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.BUSINESS_METADATA, bm.getTypeName(), null, null, bm.getEntityType(), bm.getEntityName());
            long now = this.tsGenerator.next();
            BusinessMetadataValue value = new BusinessMetadataValue(null, bm, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new BusinessMetadataResponse((BusinessMetadata)((Object)((BusinessMetadataValue)newValue).getNewValue())));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new BusinessMetadataResponse(bm, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    public Tag getTag(String tenant, String entityType, String entityName, String tagName) throws AtlasBaseException {
        String guid = this.getGuid(tenant, entityType, entityName);
        AtlasClassification classification = this.entityStore.getClassification(guid, tagName);
        classification.setEntityGuid(null);
        return new Tag(classification, entityType, entityName);
    }

    public BusinessMetadata getBusinessMetadata(String tenant, String entityType, String entityName, String bmName) throws AtlasBaseException {
        String guid = this.getGuid(tenant, entityType, entityName);
        AtlasEntity entity = this.entityStore.getById(guid).getEntity();
        if (entity.getBusinessAttributes() == null || entity.getBusinessAttributes().get(bmName) == null) {
            return null;
        }
        AtlasStruct struct = new AtlasStruct(bmName, (Map)entity.getBusinessAttributes().get(bmName));
        return new BusinessMetadata(struct, entityType, entityName);
    }

    public List<TagResponse> updateTagsOrForward(String tenant, List<Tag> tags, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<TagResponse> list = this.updateTags(tenant, tags);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<TagResponse> list = this.forwardUpdateTagsRequestToLeader(tags, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private List<TagResponse> forwardUpdateTagsRequestToLeader(List<Tag> tags, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/tags");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding update tags request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "PUT", MetadataRegistry.toJson(tags), headerProperties, LIST_TAGS_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update tags request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<TagResponse> updateTags(String tenant, List<Tag> tags) {
        this.kafkaCache.sync();
        ArrayList<TagResponse> ret = new ArrayList<TagResponse>();
        for (Tag tag : tags) {
            Tag oldTag;
            block8: {
                oldTag = null;
                try {
                    oldTag = this.getTag(tenant, tag.getEntityType(), tag.getEntityName(), tag.getTypeName());
                }
                catch (AtlasBaseException e) {
                    ret.add(new TagResponse(tag, ExceptionMapperUtil.toErrorMessage(e)));
                    continue;
                }
                if (oldTag.getEntityStatus() != AtlasEntity.Status.ACTIVE) {
                    e = new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_ASSOCIATED_WITH_ENTITY, new String[]{tag.getTypeName()});
                    ret.add(new TagResponse(tag, ExceptionMapperUtil.toErrorMessage(e)));
                    continue;
                }
                try {
                    if (!this.allowTagOperation(tag)) {
                        ret.add(new TagResponse(tag, RestInvalidTagOperationException.toErrorMessage(tag.getTypeName())));
                    }
                    break block8;
                }
                catch (AtlasBaseException e) {
                    ret.add(new TagResponse(tag, ExceptionMapperUtil.toErrorMessage(e)));
                }
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.TAG, tag.getTypeName(), null, null, tag.getEntityType(), tag.getEntityName());
            long now = this.tsGenerator.next();
            TagValue value = new TagValue(oldTag, tag, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new TagResponse((Tag)((Object)((TagValue)newValue).getNewValue())));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new TagResponse(tag, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    public List<BusinessMetadataResponse> updateBusinessMetadataOrForward(String tenant, List<BusinessMetadata> bms, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<BusinessMetadataResponse> list = this.updateBusinessMetadata(tenant, bms);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<BusinessMetadataResponse> list = this.forwardUpdateBusinessMetadataRequestToLeader(bms, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private List<BusinessMetadataResponse> forwardUpdateBusinessMetadataRequestToLeader(List<BusinessMetadata> bms, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/businessmetadata");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding update bms request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "PUT", MetadataRegistry.toJson(bms), headerProperties, LIST_BM_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update bms request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<BusinessMetadataResponse> updateBusinessMetadata(String tenant, List<BusinessMetadata> bms) {
        this.kafkaCache.sync();
        ArrayList<BusinessMetadataResponse> ret = new ArrayList<BusinessMetadataResponse>();
        for (BusinessMetadata bm : bms) {
            BusinessMetadata oldBM = null;
            try {
                oldBM = this.getBusinessMetadata(tenant, bm.getEntityType(), bm.getEntityName(), bm.getTypeName());
            }
            catch (AtlasBaseException e) {
                ret.add(new BusinessMetadataResponse(bm, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            if (oldBM == null) {
                e = new AtlasBaseException(AtlasErrorCode.BUSINESS_METADATA_ATTRIBUTE_DOES_NOT_EXIST, new String[]{bm.getTypeName()});
                ret.add(new BusinessMetadataResponse(bm, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.BUSINESS_METADATA, bm.getTypeName(), null, null, bm.getEntityType(), bm.getEntityName());
            long now = this.tsGenerator.next();
            BusinessMetadataValue value = new BusinessMetadataValue(oldBM, bm, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new BusinessMetadataResponse((BusinessMetadata)((Object)((BusinessMetadataValue)newValue).getNewValue())));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new BusinessMetadataResponse(bm, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTagOrForward(String tenant, String entityType, String entityName, String tagName, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        block5: {
            this.lock(tenant, headerProperties);
            try {
                if (this.isLeader(headerProperties)) {
                    this.deleteTag(tenant, entityType, entityName, tagName);
                    break block5;
                }
                if (this.schemaRegistry.leaderIdentity() != null) {
                    this.forwardDeleteTagRequestToLeader(entityType, entityName, tagName, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Request failed since leader is unknown");
            }
            finally {
                this.unlock(tenant);
            }
        }
    }

    private void forwardDeleteTagRequestToLeader(String entityType, String entityName, String tagName, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}/tags/{tagName}");
        String path = builder.build(new Object[]{entityType, entityName, tagName}).toString();
        log.debug(String.format("Forwarding delete tag request to %s", baseUrl));
        try {
            leaderRestService.httpRequest(path, "DELETE", null, headerProperties, VOID_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the delete tag request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void deleteTag(String tenant, String entityType, String entityName, String tagName) throws AtlasBaseException {
        Tag oldTag;
        this.kafkaCache.sync();
        try {
            oldTag = this.getTag(tenant, entityType, entityName, tagName);
        }
        catch (AtlasBaseException e) {
            if (MetadataRegistry.isJanusGraphNullPointerException(e)) {
                log.error("JanusGraph NullPointerException in MetadataRegistry.deleteTag(tenant={}, entityType={}, entityName={}, tagName={})", new Object[]{tenant, entityType, entityName, tagName});
                this.metricsManager.recordJanusGraphNullPointerExceptionError(1);
            }
            throw e;
        }
        if (oldTag == null || oldTag.getEntityStatus() != AtlasEntity.Status.ACTIVE) {
            throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{tagName});
        }
        if (!this.allowTagOperation(oldTag)) {
            throw new RestInvalidTagOperationException(oldTag.getTypeName());
        }
        MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.DELETE, MetadataRegistryKind.TAG, tagName, null, null, entityType, entityName);
        long now = this.tsGenerator.next();
        TagValue value = new TagValue(oldTag, null, false, false, now);
        this.kafkaCache.put((Object)key, (Object)value);
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            throw e;
        }
        this.kafkaCache.put((Object)key, null);
        key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.TAG, tagName, null, null, entityType, entityName);
        this.kafkaCache.put((Object)key, null);
        key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.TAG, tagName, null, null, entityType, entityName);
        this.kafkaCache.put((Object)key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBusinessMetadataOrForward(String tenant, String entityType, String entityName, String bmName, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        block5: {
            this.lock(tenant, headerProperties);
            try {
                if (this.isLeader(headerProperties)) {
                    this.deleteBusinessMetadata(tenant, entityType, entityName, bmName);
                    break block5;
                }
                if (this.schemaRegistry.leaderIdentity() != null) {
                    this.forwardDeleteBusinessMetadataRequestToLeader(entityType, entityName, bmName, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Request failed since leader is unknown");
            }
            finally {
                this.unlock(tenant);
            }
        }
    }

    private void forwardDeleteBusinessMetadataRequestToLeader(String entityType, String entityName, String bmName, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}/businessmetadata/{bmName}");
        String path = builder.build(new Object[]{entityType, entityName, bmName}).toString();
        log.debug(String.format("Forwarding delete bm request to %s", baseUrl));
        try {
            leaderRestService.httpRequest(path, "DELETE", null, headerProperties, VOID_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the delete bm request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void deleteBusinessMetadata(String tenant, String entityType, String entityName, String bmName) throws AtlasBaseException {
        BusinessMetadata oldBM;
        this.kafkaCache.sync();
        try {
            oldBM = this.getBusinessMetadata(tenant, entityType, entityName, bmName);
        }
        catch (AtlasBaseException e) {
            if (MetadataRegistry.isJanusGraphNullPointerException(e)) {
                log.error("JanusGraph NullPointerException in MetadataRegistry.deleteBusinessMetadata(tenant={}, entityType={}, entityName={}, bmName={})", new Object[]{tenant, entityType, entityName, bmName});
                this.metricsManager.recordJanusGraphNullPointerExceptionError(1);
            }
            throw e;
        }
        MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.DELETE, MetadataRegistryKind.BUSINESS_METADATA, bmName, null, null, entityType, entityName);
        long now = this.tsGenerator.next();
        BusinessMetadataValue value = new BusinessMetadataValue(oldBM, null, false, false, now);
        this.kafkaCache.put((Object)key, (Object)value);
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            throw e;
        }
        this.kafkaCache.put((Object)key, null);
        key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.BUSINESS_METADATA, bmName, null, null, entityType, entityName);
        this.kafkaCache.put((Object)key, null);
        key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.BUSINESS_METADATA, bmName, null, null, entityType, entityName);
        this.kafkaCache.put((Object)key, null);
    }

    public List<TagDefResponse> createTagDefsOrForward(String tenant, List<TagDef> tagDefs, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<TagDefResponse> list = this.createTagDefs(tenant, tagDefs);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<TagDefResponse> list = this.forwardCreateTagDefsRequestToLeader(tagDefs, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private List<TagDefResponse> forwardCreateTagDefsRequestToLeader(List<TagDef> tagDefs, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding create tagdefs request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "POST", MetadataRegistry.toJson(tagDefs), headerProperties, LIST_TAG_DEFS_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create tagdefs request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<TagDefResponse> createTagDefs(String tenant, List<TagDef> tagDefs) throws SchemaRegistryException {
        this.kafkaCache.sync();
        ArrayList<TagDefResponse> ret = new ArrayList<TagDefResponse>();
        for (TagDef tagDef : tagDefs) {
            if (tagDef.getName() == null || !AtlasTypeUtil.isValidTypeName((String)tagDef.getName())) {
                AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID_FORMAT, new String[]{tagDef.getName(), tagDef.getCategory().name()});
                ret.add(new TagDefResponse(tagDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            TagDef oldTagDef = null;
            try {
                oldTagDef = this.getTagDef(tenant, tagDef.getName());
            }
            catch (AtlasBaseException atlasBaseException) {
                // empty catch block
            }
            if (oldTagDef != null) {
                AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{tagDef.getName()});
                ret.add(new TagDefResponse(tagDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.TAG_DEF, tagDef.getName(), DEFAULT_VERSION, null, null, null);
            long now = this.tsGenerator.next();
            TagDefValue value = new TagDefValue(null, tagDef, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new TagDefResponse((TagDef)((Object)((TagDefValue)newValue).getNewValue())));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new TagDefResponse(tagDef, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    public List<BusinessMetadataDefResponse> createBusinessMetadataDefsOrForward(String tenant, List<AtlasBusinessMetadataDef> bmDefs, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<BusinessMetadataDefResponse> list = this.createBusinessMetadataDefs(tenant, bmDefs);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<BusinessMetadataDefResponse> list = this.forwardCreateBusinessMetadataDefsRequestToLeader(bmDefs, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private List<BusinessMetadataDefResponse> forwardCreateBusinessMetadataDefsRequestToLeader(List<AtlasBusinessMetadataDef> bmDefs, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding create bmdefs request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "POST", MetadataRegistry.toJson(bmDefs), headerProperties, LIST_BM_DEFS_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create bmdefs request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<BusinessMetadataDefResponse> createBusinessMetadataDefs(String tenant, List<AtlasBusinessMetadataDef> bmDefs) throws SchemaRegistryException {
        this.kafkaCache.sync();
        ArrayList<BusinessMetadataDefResponse> ret = new ArrayList<BusinessMetadataDefResponse>();
        for (AtlasBusinessMetadataDef bmDef : bmDefs) {
            if (bmDef.getName() == null || !AtlasTypeUtil.isValidTypeName((String)bmDef.getName())) {
                AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID_FORMAT, new String[]{bmDef.getName(), bmDef.getCategory().name()});
                ret.add(new BusinessMetadataDefResponse(bmDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            AtlasBusinessMetadataDef oldBusinessMetadataDef = null;
            try {
                oldBusinessMetadataDef = this.getBusinessMetadataDef(tenant, bmDef.getName());
            }
            catch (AtlasBaseException atlasBaseException) {
                // empty catch block
            }
            if (oldBusinessMetadataDef != null) {
                AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{bmDef.getName()});
                ret.add(new BusinessMetadataDefResponse(bmDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.BUSINESS_METADATA_DEF, bmDef.getName(), DEFAULT_VERSION, null, null, null);
            long now = this.tsGenerator.next();
            BusinessMetadataDefValue value = new BusinessMetadataDefValue(null, bmDef, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new BusinessMetadataDefResponse((AtlasBusinessMetadataDef)((BusinessMetadataDefValue)newValue).getNewValue()));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new BusinessMetadataDefResponse(bmDef, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    public TagDef getTagDef(String tenant, String tagName) throws AtlasBaseException {
        String qualifiedTagName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, tagName);
        AtlasClassificationDef classificationDef = this.typeDefStore.getClassificationDefByName(qualifiedTagName);
        classificationDef.setGuid(null);
        return new TagDef(classificationDef);
    }

    public List<TagDefResponse> updateTagDefsOrForward(String tenant, List<TagDef> tagDefs, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<TagDefResponse> list = this.updateTagDefs(tenant, tagDefs);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<TagDefResponse> list = this.forwardUpdateTagDefsRequestToLeader(tagDefs, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    public AtlasBusinessMetadataDef getBusinessMetadataDef(String tenant, String bmName) throws AtlasBaseException {
        String qualifiedBMName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, bmName);
        AtlasBusinessMetadataDef businessMetadataDef = this.typeDefStore.getBusinessMetadataDefByName(qualifiedBMName);
        businessMetadataDef.setGuid(null);
        return businessMetadataDef;
    }

    private List<TagDefResponse> forwardUpdateTagDefsRequestToLeader(List<TagDef> tagDefs, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding update tagdefs request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "PUT", MetadataRegistry.toJson(tagDefs), headerProperties, LIST_TAG_DEFS_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update tagdefs request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<TagDefResponse> updateTagDefs(String tenant, List<TagDef> tagDefs) {
        this.kafkaCache.sync();
        ArrayList<TagDefResponse> ret = new ArrayList<TagDefResponse>();
        for (TagDef tagDef : tagDefs) {
            if (tagDef.getName() == null || !AtlasTypeUtil.isValidTypeName((String)tagDef.getName())) {
                AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID_FORMAT, new String[]{tagDef.getName(), tagDef.getCategory().name()});
                ret.add(new TagDefResponse(tagDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            TagDef oldTagDef = null;
            try {
                oldTagDef = this.getTagDef(tenant, tagDef.getName());
            }
            catch (AtlasBaseException e) {
                ret.add(new TagDefResponse(tagDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.TAG_DEF, tagDef.getName(), MetadataRegistry.incrementVersion(oldTagDef.getTypeVersion()), null, null, null);
            long now = this.tsGenerator.next();
            TagDefValue value = new TagDefValue(oldTagDef, tagDef, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new TagDefResponse((TagDef)((Object)((TagDefValue)newValue).getNewValue())));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new TagDefResponse(tagDef, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    public List<BusinessMetadataDefResponse> updateBusinessMetadataDefsOrForward(String tenant, List<AtlasBusinessMetadataDef> bmDefs, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<BusinessMetadataDefResponse> list = this.updateBusinessMetadataDefs(tenant, bmDefs);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<BusinessMetadataDefResponse> list = this.forwardUpdateBusinessMetadataDefsRequestToLeader(bmDefs, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private List<BusinessMetadataDefResponse> forwardUpdateBusinessMetadataDefsRequestToLeader(List<AtlasBusinessMetadataDef> bmDefs, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding update businessmetadatadefs request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "PUT", MetadataRegistry.toJson(bmDefs), headerProperties, LIST_BM_DEFS_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update bmdefs request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<BusinessMetadataDefResponse> updateBusinessMetadataDefs(String tenant, List<AtlasBusinessMetadataDef> bmDefs) {
        this.kafkaCache.sync();
        ArrayList<BusinessMetadataDefResponse> ret = new ArrayList<BusinessMetadataDefResponse>();
        for (AtlasBusinessMetadataDef bmDef : bmDefs) {
            if (bmDef.getName() == null || !AtlasTypeUtil.isValidTypeName((String)bmDef.getName())) {
                AtlasBaseException e = new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID_FORMAT, new String[]{bmDef.getName(), bmDef.getCategory().name()});
                ret.add(new BusinessMetadataDefResponse(bmDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            AtlasBusinessMetadataDef oldBMDef = null;
            try {
                oldBMDef = this.getBusinessMetadataDef(tenant, bmDef.getName());
            }
            catch (AtlasBaseException e) {
                ret.add(new BusinessMetadataDefResponse(bmDef, ExceptionMapperUtil.toErrorMessage(e)));
                continue;
            }
            MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.BUSINESS_METADATA_DEF, bmDef.getName(), MetadataRegistry.incrementVersion(oldBMDef.getTypeVersion()), null, null, null);
            long now = this.tsGenerator.next();
            BusinessMetadataDefValue value = new BusinessMetadataDefValue(oldBMDef, bmDef, false, false, now);
            this.kafkaCache.put((Object)key, (Object)value);
            MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
            if (newValue != null && newValue.getTimestamp() == now) {
                ret.add(new BusinessMetadataDefResponse((AtlasBusinessMetadataDef)((BusinessMetadataDefValue)newValue).getNewValue()));
                continue;
            }
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            ret.add(new BusinessMetadataDefResponse(bmDef, ExceptionMapperUtil.toErrorMessage(e)));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTagDefOrForward(String tenant, String tagName, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        block5: {
            this.lock(tenant, headerProperties);
            try {
                if (this.isLeader(headerProperties)) {
                    this.deleteTagDef(tenant, tagName);
                    break block5;
                }
                if (this.schemaRegistry.leaderIdentity() != null) {
                    this.forwardDeleteTagDefRequestToLeader(tagName, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Request failed since leader is unknown");
            }
            finally {
                this.unlock(tenant);
            }
        }
    }

    private void forwardDeleteTagDefRequestToLeader(String tagName, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs/{tagName}");
        String path = builder.build(new Object[]{tagName}).toString();
        log.debug(String.format("Forwarding delete tagdef request to %s", baseUrl));
        try {
            leaderRestService.httpRequest(path, "DELETE", null, headerProperties, VOID_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the delete tagdef request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void deleteTagDef(String tenant, String tagName) throws AtlasBaseException {
        this.kafkaCache.sync();
        TagDef oldTagDef = null;
        try {
            oldTagDef = this.getTagDef(tenant, tagName);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        if (oldTagDef == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{tagName});
        }
        MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.DELETE, MetadataRegistryKind.TAG_DEF, tagName, null, null, null, null);
        long now = this.tsGenerator.next();
        TagDefValue value = new TagDefValue(oldTagDef, null, false, false, now);
        this.kafkaCache.put((Object)key, (Object)value);
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            throw o != null ? o.getException() : UNKNOWN_ERROR;
        }
        this.kafkaCache.put((Object)key, null);
        String oldVersion = oldTagDef.getTypeVersion();
        while (oldVersion != null && !oldVersion.equals(DEFAULT_VERSION)) {
            key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.TAG_DEF, tagName, oldVersion, null, null, null);
            this.kafkaCache.put((Object)key, null);
            oldVersion = MetadataRegistry.decrementVersion(oldVersion);
        }
        key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.TAG_DEF, tagName, DEFAULT_VERSION, null, null, null);
        this.kafkaCache.put((Object)key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBusinessMetadataDefOrForward(String tenant, String bmName, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        block5: {
            this.lock(tenant, headerProperties);
            try {
                if (this.isLeader(headerProperties)) {
                    this.deleteBusinessMetadataDef(tenant, bmName);
                    break block5;
                }
                if (this.schemaRegistry.leaderIdentity() != null) {
                    this.forwardDeleteBusinessMetadataDefRequestToLeader(bmName, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Request failed since leader is unknown");
            }
            finally {
                this.unlock(tenant);
            }
        }
    }

    private void forwardDeleteBusinessMetadataDefRequestToLeader(String bmName, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs/{bmName}");
        String path = builder.build(new Object[]{bmName}).toString();
        log.debug(String.format("Forwarding delete bmdef request to %s", baseUrl));
        try {
            leaderRestService.httpRequest(path, "DELETE", null, headerProperties, VOID_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the delete bmdef request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void deleteBusinessMetadataDef(String tenant, String bmName) throws AtlasBaseException {
        this.kafkaCache.sync();
        AtlasBusinessMetadataDef oldBMDef = null;
        try {
            oldBMDef = this.getBusinessMetadataDef(tenant, bmName);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        if (oldBMDef == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{bmName});
        }
        MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.DELETE, MetadataRegistryKind.BUSINESS_METADATA_DEF, bmName, null, null, null, null);
        long now = this.tsGenerator.next();
        BusinessMetadataDefValue value = new BusinessMetadataDefValue(oldBMDef, null, false, false, now);
        this.kafkaCache.put((Object)key, (Object)value);
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            throw o != null ? o.getException() : UNKNOWN_ERROR;
        }
        this.kafkaCache.put((Object)key, null);
        String oldVersion = oldBMDef.getTypeVersion();
        while (oldVersion != null && !oldVersion.equals(DEFAULT_VERSION)) {
            key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.BUSINESS_METADATA_DEF, bmName, oldVersion, null, null, null);
            this.kafkaCache.put((Object)key, null);
            oldVersion = MetadataRegistry.decrementVersion(oldVersion);
        }
        key = new MetadataRegistryKey(tenant, MetadataRegistryOp.CREATE, MetadataRegistryKind.BUSINESS_METADATA_DEF, bmName, DEFAULT_VERSION, null, null, null);
        this.kafkaCache.put((Object)key, null);
    }

    public EntityMutationResponse createOrUpdateEntityOrForward(String tenant, AtlasEntity.AtlasEntityWithExtInfo entity, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                EntityMutationResponse entityMutationResponse = this.createOrUpdateEntityWithResponse(tenant, entity);
                return entityMutationResponse;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                EntityMutationResponse entityMutationResponse = this.forwardCreateOrUpdateEntityRequestToLeader(entity, headerProperties);
                return entityMutationResponse;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private EntityMutationResponse forwardCreateOrUpdateEntityRequestToLeader(AtlasEntity.AtlasEntityWithExtInfo entity, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding create/update entity request to %s", baseUrl));
        try {
            return (EntityMutationResponse)leaderRestService.httpRequest(path, "POST", MetadataRegistry.toJson(entity), headerProperties, ENTITY_MUTATION_RESPONSE_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create/update entity request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private EntityMutationResponse createOrUpdateEntityWithResponse(String tenant, AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasBaseException {
        KeyValue<MetadataRegistryKey, MetadataRegistryValue<AtlasEntity.AtlasEntityWithExtInfo>> keyValue = this.createOrUpdateEntity(tenant, entity);
        String typeName = entity.getEntity().getTypeName();
        String qualifiedName = (String)entity.getEntity().getAttribute("qualifiedName");
        AtlasEntity.AtlasEntityWithExtInfo oldEntity = (AtlasEntity.AtlasEntityWithExtInfo)((MetadataRegistryValue)keyValue.value).getOldValue();
        EntityMutations.EntityOperation entityOp = oldEntity != null ? EntityMutations.EntityOperation.UPDATE : EntityMutations.EntityOperation.CREATE;
        AtlasEntity.AtlasEntityWithExtInfo newEntity = this.getEntity(tenant, typeName, qualifiedName, false, false);
        return new EntityMutationResponse(Collections.singletonMap(entityOp, Collections.singletonList(new AtlasEntityHeader(newEntity.getEntity()))));
    }

    public KeyValue<MetadataRegistryKey, MetadataRegistryValue<AtlasEntity.AtlasEntityWithExtInfo>> createOrUpdateEntity(String tenant, AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasBaseException {
        this.kafkaCache.sync();
        KeyValue<MetadataRegistryKey, MetadataRegistryValue<AtlasEntity.AtlasEntityWithExtInfo>> keyValue = this.toKeyValue(tenant, entity, null, false);
        MetadataRegistryKey key = (MetadataRegistryKey)keyValue.key;
        MetadataRegistryValue value = (MetadataRegistryValue)keyValue.value;
        long now = value.getTimestamp();
        this.kafkaCache.put((Object)key, (Object)value);
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            throw e;
        }
        return keyValue;
    }

    public void createOrUpdateEntities(String tenant, List<AtlasEntity.AtlasEntityWithExtInfo> entities, BiPredicate<AtlasEntity.AtlasEntityWithExtInfo, AtlasEntity.AtlasEntityWithExtInfo> doUpdate) throws AtlasBaseException {
        this.kafkaCache.sync();
        Map keyValues = entities.stream().map(entity -> this.toKeyValue(tenant, (AtlasEntity.AtlasEntityWithExtInfo)entity, doUpdate, true)).filter(kv -> kv.key != null).collect(Collectors.toMap(kv -> (MetadataRegistryKey)kv.key, kv -> (MetadataRegistryValue)kv.value, (existing, replacement) -> replacement, LinkedHashMap::new));
        if (keyValues.size() == 1) {
            Map.Entry entry = keyValues.entrySet().iterator().next();
            this.kafkaCache.put(entry.getKey(), entry.getValue());
        } else {
            this.kafkaCache.putAll(keyValues);
        }
    }

    public List<SchemaTagsResponse> updateSchemaMetadataOrForward(String tenant, List<SchemaMetadata> schemaMetadataList, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                List<SchemaTagsResponse> list = this.updateSchemaMetadata(tenant, schemaMetadataList);
                return list;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                List<SchemaTagsResponse> list = this.forwardUpdateSchemaTagsRequestToLeader(schemaMetadataList, headerProperties);
                return list;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    public List<SchemaTagsResponse> updateSchemaMetadata(String tenant, List<SchemaMetadata> schemaMetadataList) {
        this.kafkaCache.sync();
        ArrayList<SchemaTagsResponse> responses = new ArrayList<SchemaTagsResponse>(schemaMetadataList.size());
        AtlasEntityType schemaEntityType = this.typeRegistry.getEntityTypeByName(SchemaAtlasTypes.SR_SCHEMA.getName());
        for (SchemaMetadata schemaMetadata : schemaMetadataList) {
            String subject = schemaMetadata.getSubject();
            int version = schemaMetadata.getVersion() != null ? schemaMetadata.getVersion() : 0;
            ErrorMessage errorMessage = null;
            Integer newId = null;
            try {
                ArrayList<io.confluent.catalog.model.instance.SchemaTags> allTags = new ArrayList<io.confluent.catalog.model.instance.SchemaTags>(schemaMetadata.getTagsToAdd());
                for (io.confluent.catalog.model.instance.SchemaTags schemaTag : allTags) {
                    Set<String> missingTags = this.checkTags(tenant, new HashSet<String>(schemaTag.getTags()));
                    if (missingTags.isEmpty()) continue;
                    throw new RestInvalidTagException(missingTags);
                }
                ParsedSchema parsedSchema = this.schemaRegistryClient.getSchemaBySubjectAndId(subject, schemaMetadata.getId().intValue());
                String qualifiedSchemaName = QualifiedNameGenerator.getQualifiedName(tenant, QualifiedSubject.contextFor((String)tenant, (String)subject), schemaMetadata.getId());
                Map<String, Object> attributes = Collections.singletonMap("qualifiedName", qualifiedSchemaName);
                AtlasEntity.AtlasEntityWithExtInfo atlasEntityWithExtInfo = this.getByUniqueAttributes(schemaEntityType, attributes, false, false);
                Object hasEmbeddedTags = atlasEntityWithExtInfo.getEntity().getAttribute("embeddedTags");
                if (hasEmbeddedTags == null || ((List)hasEmbeddedTags).isEmpty()) {
                    List<io.confluent.catalog.model.instance.SchemaTags> oldCatalogTags = this.getOldCatalogTags(tenant, qualifiedSchemaName);
                    allTags.addAll(oldCatalogTags);
                }
                Metadata newVersion = new Metadata(Collections.emptyMap(), Collections.singletonMap(CONFLUENT_VERSION, String.valueOf(version)), Collections.emptySet());
                Metadata mergedMetadata = schemaMetadata.getMetadata() == null ? Metadata.mergeMetadata((Metadata)parsedSchema.metadata(), (Metadata)newVersion) : Metadata.mergeMetadata((Metadata)schemaMetadata.getMetadata(), (Metadata)newVersion);
                ParsedSchema newSchema = parsedSchema.copy(this.schemaTagsListToMap(allTags), this.schemaTagsListToMap(schemaMetadata.getTagsToRemove())).copy(mergedMetadata, schemaMetadata.getRuleSet()).copy(Integer.valueOf(version));
                newId = (Integer)this.retryExecutor.retry(() -> this.schemaRegistryClient.register(subject, newSchema, version, -1));
            }
            catch (IllegalArgumentException e) {
                errorMessage = new ErrorMessage(404, e.getMessage());
            }
            catch (RestInvalidTagException e) {
                errorMessage = new ErrorMessage(e.getErrorCode(), e.getMessage());
            }
            catch (RestInvalidSchemaException e) {
                errorMessage = new ErrorMessage(e.getErrorCode(), "Cannot create schema tags on non-latest subject version.");
            }
            catch (RestNotFoundException e) {
                errorMessage = new ErrorMessage(e.getErrorCode(), e.getMessage());
            }
            catch (RestClientException e) {
                errorMessage = new ErrorMessage(e.getErrorCode(), e.getMessage());
            }
            catch (AtlasBaseException e) {
                errorMessage = ExceptionMapperUtil.toErrorMessage(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            responses.add(new SchemaTagsResponse(subject, newId, errorMessage));
        }
        return responses;
    }

    @Deprecated
    public List<io.confluent.catalog.model.instance.SchemaTags> getOldCatalogTags(String tenant, String qualifiedName) throws AtlasBaseException {
        ArrayList<io.confluent.catalog.model.instance.SchemaTags> allOldTags = new ArrayList<io.confluent.catalog.model.instance.SchemaTags>();
        List<AtlasEntityHeader> searchResult = this.searchService.searchEntityByQualifiedNamePrefix(searchTypesForTags, qualifiedName, Collections.singleton("qualifiedName"));
        if (searchResult != null && !searchResult.isEmpty()) {
            for (AtlasEntityHeader entityHeader : searchResult) {
                List tagNames = entityHeader.getClassificationNames();
                if (tagNames == null || tagNames.isEmpty()) continue;
                String qualifiedPath = (String)entityHeader.getAttribute("qualifiedName");
                int index = qualifiedPath.lastIndexOf(QualifiedNameGenerator.NAME_DELIMITER);
                String path = qualifiedPath.substring(index + 1);
                io.confluent.catalog.model.instance.SchemaTags schemaTags = new io.confluent.catalog.model.instance.SchemaTags(new SchemaEntity(path, SchemaEntity.EntityType.get((String)entityHeader.getTypeName())), tagNames.stream().map(tag -> QualifiedNameGenerator.stripTypeTenantPrefix(tenant, tag)).collect(Collectors.toList()));
                allOldTags.add(schemaTags);
            }
        }
        return allOldTags;
    }

    public List<SchemaTags> getCatalogTags(String tenant, String qualifiedName) throws AtlasBaseException {
        ArrayList<SchemaTags> allOldTags = new ArrayList<SchemaTags>();
        List<AtlasEntityHeader> searchResult = this.searchService.searchEntityByQualifiedNamePrefix(searchTypesForTags, qualifiedName, Collections.singleton("qualifiedName"));
        if (searchResult != null && !searchResult.isEmpty()) {
            for (AtlasEntityHeader entityHeader : searchResult) {
                List tagNames = entityHeader.getClassificationNames();
                if (tagNames == null || tagNames.isEmpty()) continue;
                String qualifiedPath = (String)entityHeader.getAttribute("qualifiedName");
                int index = qualifiedPath.lastIndexOf(QualifiedNameGenerator.NAME_DELIMITER);
                String path = qualifiedPath.substring(index + 1);
                SchemaTags schemaTags = new SchemaTags(new SchemaEntity(path, SchemaEntity.EntityType.get((String)entityHeader.getTypeName())), tagNames.stream().map(tag -> QualifiedNameGenerator.stripTypeTenantPrefix(tenant, tag)).collect(Collectors.toList()));
                allOldTags.add(schemaTags);
            }
        }
        return allOldTags;
    }

    private boolean allowTagOperation(Tag tag) throws AtlasBaseException {
        SchemaAtlasTypes entityType = SchemaAtlasTypes.get(tag.getEntityType());
        if (entityType == SchemaAtlasTypes.SR_FIELD || entityType == SchemaAtlasTypes.SR_RECORD) {
            String[] parts = QualifiedNameGenerator.parseQualifiedName(tag.getEntityName());
            parts = Arrays.copyOfRange(parts, 0, parts.length - 1);
            String qualifiedPrefix = QualifiedNameGenerator.getQualifiedName(parts);
            List<AtlasEntityHeader> searchResult = this.searchService.searchEntityByQualifiedNamePrefix(SchemaAtlasTypes.SR_SCHEMA.getName(), qualifiedPrefix, Collections.singleton("embeddedTags"));
            if (searchResult != null && !searchResult.isEmpty()) {
                List embeddedTags = (List)searchResult.get(0).getAttribute("embeddedTags");
                return embeddedTags == null || embeddedTags.isEmpty();
            }
        }
        return true;
    }

    public void reconcileEntities(String typeName, String tenant, String group, Set<String> entities) throws AtlasBaseException {
        this.kafkaCache.sync();
        MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.RECONCILE, MetadataRegistryKind.ENTITY_SNAPSHOT, typeName, null, group, null, null);
        long now = this.tsGenerator.next();
        EntitySnapshotValue value = new EntitySnapshotValue(new EntitySnapshot(entities), now);
        try {
            this.kafkaCache.put((Object)key, (Object)value);
        }
        catch (EntryTooLargeException e) {
            log.error(String.format("Reconcile Error, The size %s (before serialization) of set allEntitiesInSnapshot is too large, metadata type %s, tenant %s, group %s.", entities.size(), typeName, tenant, group), (Throwable)e);
            return;
        }
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            throw o != null ? o.getException() : UNKNOWN_ERROR;
        }
    }

    public Set<String> checkTags(String tenant, Set<String> tags) {
        if (tags.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> missingTags = new HashSet<String>();
        for (String tag : tags) {
            String qualifiedTag = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, tag);
            TagDef tagDef = null;
            try {
                tagDef = this.getTagDef(tenant, qualifiedTag);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tagDef != null) continue;
            missingTags.add(tag);
        }
        return missingTags;
    }

    public List<SchemaTagsResponse> forwardUpdateSchemaTagsRequestToLeader(List<SchemaMetadata> schemaMetadataList, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/schematags");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding update schema tags request to %s", baseUrl));
        try {
            return (List)leaderRestService.httpRequest(path, "POST", MetadataRegistry.toJson(schemaMetadataList), headerProperties, LIST_SCHEMA_TAGS_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update schema tags request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private Map<SchemaEntity, Set<String>> schemaTagsListToMap(List<io.confluent.catalog.model.instance.SchemaTags> schemaTags) {
        return schemaTags.stream().collect(Collectors.toMap(io.confluent.catalog.model.instance.SchemaTags::getSchemaEntity, entry -> new HashSet<String>(entry.getTags()), (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
    }

    private KeyValue<MetadataRegistryKey, MetadataRegistryValue<AtlasEntity.AtlasEntityWithExtInfo>> toKeyValue(String tenant, AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, BiPredicate<AtlasEntity.AtlasEntityWithExtInfo, AtlasEntity.AtlasEntityWithExtInfo> doUpdate, boolean isBatch) {
        MetadataRegistryOp op;
        AtlasEntity entity = entityWithExtInfo.getEntity();
        String typeName = entity.getTypeName();
        String qualifiedName = (String)entity.getAttribute("qualifiedName");
        AtlasEntity.AtlasEntityWithExtInfo oldEntityWithExtInfo = null;
        try {
            oldEntityWithExtInfo = this.getOldEntity(tenant, typeName, qualifiedName, false, false);
            this.replaceGuidsWithUniqAttrs(oldEntityWithExtInfo);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        if (oldEntityWithExtInfo != null) {
            op = MetadataRegistryOp.UPDATE;
            AtlasEntity oldEntity = oldEntityWithExtInfo.getEntity();
            if (entity.getAttribute("createTime") == null || entity.getAttribute("createTime").equals(ModelConstants.UNIX_ZERO_EPOCH)) {
                entity.setAttribute("createTime", oldEntity.getAttribute("createTime"));
            }
            if (entity.getAttribute("updateTime") == null || entity.getAttribute("updateTime").equals(ModelConstants.UNIX_ZERO_EPOCH)) {
                if (oldEntity.getAttribute("updateTime") != null && !oldEntity.getAttribute("updateTime").equals(ModelConstants.UNIX_ZERO_EPOCH)) {
                    entity.setAttribute("updateTime", oldEntity.getAttribute("updateTime"));
                } else if (oldEntity.getAttribute("createTime") != null && !oldEntity.getAttribute("createTime").equals(ModelConstants.UNIX_ZERO_EPOCH)) {
                    entity.setAttribute("updateTime", oldEntity.getAttribute("createTime"));
                } else {
                    entity.setAttribute("updateTime", entity.getAttribute("createTime"));
                }
            }
        } else {
            op = MetadataRegistryOp.CREATE;
            if (entity.getAttribute("createTime") == null) {
                entity.setAttribute("createTime", (Object)ModelConstants.UNIX_ZERO_EPOCH);
            }
            if (entity.getAttribute("updateTime") == null || entity.getAttribute("updateTime").equals(ModelConstants.UNIX_ZERO_EPOCH)) {
                entity.setAttribute("updateTime", entity.getAttribute("createTime"));
            }
        }
        this.replaceGuidsWithUniqAttrs(entityWithExtInfo);
        MetadataRegistryKey key = null;
        if (doUpdate == null || doUpdate.test(oldEntityWithExtInfo, entityWithExtInfo)) {
            key = new MetadataRegistryKey(tenant, op, MetadataRegistryKind.ENTITY, typeName, null, qualifiedName, null, null);
        }
        long now = this.tsGenerator.next();
        EntityValue value = new EntityValue(oldEntityWithExtInfo, entityWithExtInfo, true, isBatch, now);
        return new KeyValue((Object)key, (Object)value);
    }

    private void replaceGuidsWithUniqAttrs(AtlasEntity.AtlasEntityWithExtInfo entity) {
        if (entity == null || entity.getEntity() == null) {
            return;
        }
        Map relationshipAttrs = entity.getEntity().getRelationshipAttributes();
        if (relationshipAttrs != null) {
            relationshipAttrs.entrySet().removeIf(e -> this.isContainer(entity, (String)e.getKey()));
            relationshipAttrs.replaceAll((k, v) -> this.replaceGuidsWithUniqAttrsInRel(entity, v));
        }
        entity.setReferredEntities(null);
        entity.getEntity().setGuid(null);
    }

    private Object replaceGuidsWithUniqAttrsInRel(AtlasEntity.AtlasEntityWithExtInfo entity, Object attrValue) {
        if (attrValue instanceof AtlasRelatedObjectId || attrValue instanceof Map) {
            return this.toRelatedObjectIdWithUniqAttr(entity, attrValue);
        }
        if (attrValue instanceof Collection) {
            Collection objIds = (Collection)attrValue;
            return objIds.stream().map(objId -> this.toRelatedObjectIdWithUniqAttr(entity, objId)).collect(Collectors.toList());
        }
        return attrValue;
    }

    private boolean isContainer(AtlasEntity.AtlasEntityWithExtInfo entity, String attrName) {
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getEntity().getTypeName());
        if (entityType == null) {
            return false;
        }
        AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attrName);
        if (attribute == null) {
            return false;
        }
        String relationshipName = attribute.getRelationshipName();
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipName);
        if (relationshipType == null) {
            return false;
        }
        AtlasRelationshipDef relationshipDef = relationshipType.getRelationshipDef();
        AtlasRelationshipEndDef thisRel = attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT ? relationshipDef.getEndDef1() : relationshipDef.getEndDef2();
        return thisRel.getIsContainer();
    }

    public EntityMutationResponse partiallyUpdateEntityOrForward(String tenant, AtlasEntity.AtlasEntityWithExtInfo entity, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                EntityMutationResponse entityMutationResponse = this.partiallyUpdateEntity(tenant, entity);
                return entityMutationResponse;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                EntityMutationResponse entityMutationResponse = this.forwardPartiallyUpdateEntityRequestToLeader(entity, headerProperties);
                return entityMutationResponse;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private EntityMutationResponse forwardPartiallyUpdateEntityRequestToLeader(AtlasEntity.AtlasEntityWithExtInfo entity, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding create/update entity request to %s", baseUrl));
        try {
            return (EntityMutationResponse)leaderRestService.httpRequest(path, "PUT", MetadataRegistry.toJson(entity), headerProperties, ENTITY_MUTATION_RESPONSE_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create/update entity request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    public void republishOrForward(String name, String tenant, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        DataCatalogConfig dataCatalogConfig;
        SchemaRegistryConfig schemaRegistryConfig = this.schemaRegistry.config();
        String host = schemaRegistryConfig.getString("host.name");
        try {
            dataCatalogConfig = new DataCatalogConfig(schemaRegistryConfig.originalProperties());
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate dataCatalogConfig", e);
        }
        boolean isEnabled = host != null && StringUtils.isNotEmpty((String)dataCatalogConfig.getCatalogNotificationsDesignatedHostPrefix()) && host.startsWith(dataCatalogConfig.getCatalogNotificationsDesignatedHostPrefix());
        SchemaAtlasHook hook = (SchemaAtlasHook)this.schemaRegistry.properties().get("hook");
        if (isEnabled) {
            this.snapshotManager.submitSnapshotRequest(name, tenant, hook);
        } else {
            this.forwardRepublishRequestToLeader(tenant, headerProperties);
        }
    }

    private void forwardRepublishRequestToLeader(String tenant, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        DataCatalogConfig dataCatalogConfig;
        SchemaRegistryConfig schemaRegistryConfig = this.schemaRegistry.config();
        try {
            dataCatalogConfig = new DataCatalogConfig(schemaRegistryConfig.originalProperties());
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate dataCatalogConfig", e);
        }
        String hostName = schemaRegistryConfig.getString("host.name");
        String designatedHost = dataCatalogConfig.getCatalogNotificationsDesignatedHostPrefix();
        String designatedHostName = "https://" + designatedHost + hostName.substring(hostName.indexOf(46));
        CatalogRestService catalogRestService = new CatalogRestService(designatedHostName);
        catalogRestService.postEntitySnapshot(tenant, headerProperties);
    }

    public EntityMutationResponse partiallyUpdateEntity(String tenant, AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasBaseException {
        if (entity.getEntity().getAttribute("description") != null || entity.getEntity().getAttribute("owner") != null || entity.getEntity().getAttribute("ownerEmail") != null) {
            this.metricsManager.recordEntityPartialUpdate(tenant, 1);
        }
        this.kafkaCache.sync();
        String typeName = entity.getEntity().getTypeName();
        String qualifiedName = (String)entity.getEntity().getAttribute("qualifiedName");
        AtlasEntity.AtlasEntityWithExtInfo oldEntity = null;
        try {
            oldEntity = this.getOldEntity(tenant, typeName, qualifiedName, false, false);
            this.replaceGuidsWithUniqAttrs(oldEntity);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        if (oldEntity == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, qualifiedName});
        }
        this.replaceGuidsWithUniqAttrs(entity);
        MetadataRegistryKey key = new MetadataRegistryKey(tenant, MetadataRegistryOp.UPDATE, MetadataRegistryKind.ENTITY, typeName, null, qualifiedName, null, null);
        long now = this.tsGenerator.next();
        EntityValue value = new EntityValue(oldEntity, entity, true, false, now);
        this.kafkaCache.put((Object)key, (Object)value);
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            throw e;
        }
        AtlasEntity.AtlasEntityWithExtInfo newEntity = this.getEntity(tenant, typeName, qualifiedName, false, false);
        return new EntityMutationResponse(Collections.singletonMap(EntityMutations.EntityOperation.UPDATE, Collections.singletonList(new AtlasEntityHeader(newEntity.getEntity()))));
    }

    private AtlasEntity.AtlasEntityWithExtInfo getOldEntity(String tenant, String typeName, String qualifiedName, boolean minExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo oldEntity;
        try {
            oldEntity = this.getEntity(tenant, typeName, qualifiedName, minExtInfo, ignoreRelationships);
            if (oldEntity != null) {
                return oldEntity;
            }
        }
        catch (AtlasBaseException e) {
            String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
            AtlasEntity.AtlasEntityWithExtInfo oldEntity2 = this.pendingCache().get(entityQualifiedName);
            if (oldEntity2 != null) {
                return new AtlasEntity.AtlasEntityWithExtInfo(new AtlasEntity(oldEntity2.getEntity()));
            }
            throw e;
        }
        return oldEntity;
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntity(String tenant, String typeName, String qualifiedName, boolean minExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        AtlasEntityType entityType = this.ensureEntityType(typeName);
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        Map<String, Object> attributes = Collections.singletonMap("qualifiedName", entityQualifiedName);
        AtlasEntity.AtlasEntityWithExtInfo entity = this.getByUniqueAttributes(entityType, attributes, minExtInfo, ignoreRelationships);
        this.validateEntity(tenant, entity, AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, typeName, qualifiedName);
        return entity;
    }

    private void validateEntity(String tenant, AtlasEntity.AtlasEntityWithExtInfo entity, AtlasErrorCode errorCode, String ... errorParams) throws AtlasBaseException {
        String tenantValue = (String)entity.getEntity().getAttribute("tenant");
        if (!tenant.equals(tenantValue)) {
            throw new AtlasBaseException(errorCode, errorParams);
        }
    }

    public String getGuid(String tenant, String typeName, String qualifiedName) throws AtlasBaseException {
        try {
            AtlasEntityType entityType = this.ensureEntityType(typeName);
            String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
            Map<String, Object> attributes = Collections.singletonMap("qualifiedName", entityQualifiedName);
            return this.getGuidByUniqueAttributes(entityType, attributes);
        }
        catch (AtlasBaseException e) {
            if (MetadataRegistry.isJanusGraphNullPointerException(e)) {
                log.error("JanusGraph NullPointerException in MetadataRegistry.getGuid(tenant={}, typeName={}, qualifiedName={})", new Object[]{tenant, typeName, qualifiedName});
                this.metricsManager.recordJanusGraphNullPointerExceptionError(1);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrPurgeEntityOrForward(String tenant, String typeName, String qualifiedName, boolean purge, Map<String, String> headerProperties) throws SchemaRegistryException, AtlasBaseException {
        block5: {
            this.lock(tenant, headerProperties);
            try {
                if (this.isLeader(headerProperties)) {
                    this.deleteOrPurgeEntity(tenant, typeName, qualifiedName, purge);
                    break block5;
                }
                if (this.schemaRegistry.leaderIdentity() != null) {
                    this.forwardDeleteEntityRequestToLeader(typeName, qualifiedName, purge, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Request failed since leader is unknown");
            }
            finally {
                this.unlock(tenant);
            }
        }
    }

    private void forwardDeleteEntityRequestToLeader(String typeName, String qualifiedName, boolean purge, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}").queryParam("purge", new Object[]{purge});
        String path = builder.build(new Object[]{typeName, qualifiedName}).toString();
        log.debug(String.format("Forwarding delete entity request to %s", baseUrl));
        try {
            leaderRestService.httpRequest(path, "DELETE", null, headerProperties, VOID_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the delete entity request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    public void deleteEntity(String tenant, String typeName, String qualifiedName) throws AtlasBaseException {
        this.deleteOrPurgeEntity(tenant, typeName, qualifiedName, false);
    }

    public void purgeEntity(String tenant, String typeName, String qualifiedName) throws AtlasBaseException {
        this.deleteOrPurgeEntity(tenant, typeName, qualifiedName, true);
    }

    private void deleteOrPurgeEntity(String tenant, String typeName, String qualifiedName, boolean isPurge) throws AtlasBaseException {
        this.kafkaCache.sync();
        AtlasEntity.AtlasEntityWithExtInfo oldEntity = null;
        if (!isPurge) {
            try {
                oldEntity = this.getOldEntity(tenant, typeName, qualifiedName, false, false);
                this.replaceGuidsWithUniqAttrs(oldEntity);
            }
            catch (AtlasBaseException atlasBaseException) {
                // empty catch block
            }
            if (oldEntity == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, qualifiedName});
            }
        }
        MetadataRegistryKey key = new MetadataRegistryKey(tenant, isPurge ? MetadataRegistryOp.PURGE : MetadataRegistryOp.DELETE, MetadataRegistryKind.ENTITY, typeName, null, qualifiedName, null, null);
        long now = this.tsGenerator.next();
        EntityValue value = new EntityValue(oldEntity, null, false, false, now);
        this.kafkaCache.put((Object)key, (Object)value);
        MetadataRegistryValue newValue = (MetadataRegistryValue)this.kafkaCache.get((Object)key);
        if (newValue == null || newValue.getTimestamp() != now) {
            ObjectWithException o = (ObjectWithException)this.errorCache.get((Object)now);
            AtlasBaseException e = o != null ? o.getException() : UNKNOWN_ERROR;
            throw e;
        }
    }

    public static String incrementVersion(String oldVersion) {
        if (!oldVersion.startsWith(VERSION_PREFIX)) {
            throw new IllegalStateException("Unknown version");
        }
        int version = Integer.parseInt(oldVersion.substring(2));
        return VERSION_PREFIX + (version + 1);
    }

    public static String decrementVersion(String oldVersion) {
        if (!oldVersion.startsWith(VERSION_PREFIX)) {
            throw new IllegalStateException("Unknown version");
        }
        int version = Integer.parseInt(oldVersion.substring(2));
        return version > 0 ? VERSION_PREFIX + (version - 1) : null;
    }

    public boolean isEntityDeprecated(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        Date deprecatedTime = MetadataRegistry.getDateAttribute(entityWithExtInfo.getEntity().getAttribute("deprecatedTime"));
        return deprecatedTime != null && !deprecatedTime.equals(ModelConstants.UNIX_ZERO_EPOCH);
    }

    public static Date getDateAttribute(Object obj) {
        if (obj == null) {
            return null;
        }
        Date time = null;
        if (obj instanceof Integer) {
            time = new Date(((Integer)obj).longValue());
        } else if (obj instanceof Long) {
            time = new Date((Long)obj);
        } else if (obj instanceof Date) {
            time = (Date)obj;
        } else {
            log.error(String.format("unknown time format from atlas %s, %s", obj, obj.getClass()));
        }
        return time;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        log.info("Shutting down metadata registry");
        if (this.kafkaCache != null) {
            this.kafkaCache.close();
        }
    }

    public ObjectWithException getObjectWithException(long ts) {
        return (ObjectWithException)this.errorCache.get((Object)ts);
    }

    public void putObjectWithException(long ts, Object value, AtlasBaseException ex) {
        this.errorCache.put((Object)ts, (Object)new ObjectWithException(value, ex));
    }

    private Object toRelatedObjectIdWithUniqAttr(AtlasEntity.AtlasEntityWithExtInfo entity, Object attrValue) {
        AtlasRelatedObjectId relatedObjId;
        if (attrValue instanceof Map) {
            Map attrMap = (Map)attrValue;
            attrValue = new AtlasRelatedObjectId(attrMap);
        }
        if (attrValue instanceof AtlasRelatedObjectId && (relatedObjId = (AtlasRelatedObjectId)attrValue).getGuid() != null) {
            String guid = relatedObjId.getGuid();
            AtlasEntity relatedEntity = entity.getEntity(guid);
            if (relatedEntity != null) {
                return MetadataRegistry.toRelatedObjectIdWithUniqAttr(relatedObjId, relatedEntity);
            }
            try {
                AtlasEntityHeader relatedEntityHeader = this.getHeaderById(guid);
                if (relatedEntityHeader != null) {
                    return MetadataRegistry.toRelatedObjectIdWithUniqAttr(relatedObjId, relatedEntityHeader);
                }
            }
            catch (AtlasBaseException atlasBaseException) {
                // empty catch block
            }
        }
        return attrValue;
    }

    public static AtlasRelatedObjectId toRelatedObjectIdWithUniqAttr(AtlasEntity entity) {
        return MetadataRegistry.toRelatedObjectIdWithUniqAttr((AtlasRelatedObjectId)null, entity);
    }

    public static AtlasRelatedObjectId toRelatedObjectIdWithUniqAttr(AtlasRelatedObjectId relatedObjectId, AtlasEntity entity) {
        return MetadataRegistry.toRelatedObjectIdWithUniqAttr(relatedObjectId, entity.getTypeName(), entity.getAttribute("qualifiedName"));
    }

    public static AtlasRelatedObjectId toRelatedObjectIdWithUniqAttr(AtlasRelatedObjectId relatedObjectId, AtlasEntityHeader entity) {
        return MetadataRegistry.toRelatedObjectIdWithUniqAttr(relatedObjectId, entity.getTypeName(), entity.getAttribute("qualifiedName"));
    }

    private static AtlasRelatedObjectId toRelatedObjectIdWithUniqAttr(AtlasRelatedObjectId relatedObjectId, String typeName, Object qualifiedName) {
        AtlasRelatedObjectId result = new AtlasRelatedObjectId(new AtlasObjectId(typeName, "qualifiedName", qualifiedName));
        if (relatedObjectId != null) {
            result.setRelationshipAttributes(relatedObjectId.getRelationshipAttributes());
            result.setRelationshipType(relatedObjectId.getRelationshipType());
            result.setRelationshipStatus(relatedObjectId.getRelationshipStatus());
        }
        return result;
    }

    private AtlasEntityType ensureEntityType(String typeName) throws AtlasBaseException {
        AtlasEntityType ret = this.typeRegistry.getEntityTypeByName(typeName);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), typeName});
        }
        return ret;
    }

    private static byte[] toJson(Object o) throws JsonProcessingException {
        return JacksonMapper.INSTANCE.writeValueAsBytes(o);
    }

    @GraphTransaction(logRollback=false)
    public String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attributes) throws AtlasBaseException {
        long startTimeMs = System.currentTimeMillis();
        String guid = this.entityStore.getGuidByUniqueAttributes(entityType, attributes);
        this.metricsManager.recordGetGuidByUniqueAttributes(System.currentTimeMillis() - startTimeMs);
        return guid;
    }

    @GraphTransaction(logRollback=false)
    public String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues, AtlasEntity.Status status) throws AtlasBaseException {
        long startTimeMs = System.currentTimeMillis();
        String guid = this.atlasGraphUtils.getGuidByUniqueAttributes(entityType, attrValues, status);
        this.metricsManager.recordGetGuidByUniqueAttributesAndStatus(System.currentTimeMillis() - startTimeMs);
        return guid;
    }

    @GraphTransaction(logRollback=false)
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attributes, boolean minExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        try {
            long startTimeMs = System.currentTimeMillis();
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getByUniqueAttributes(entityType, attributes, minExtInfo, ignoreRelationships);
            this.metricsManager.recordGetByUniqueAttributes(System.currentTimeMillis() - startTimeMs);
            return entityWithExtInfo;
        }
        catch (AtlasBaseException e) {
            if (MetadataRegistry.isJanusGraphNullPointerException(e)) {
                log.error("JanusGraph NullPointerException in MetadataRegistry.getByUniqueAttributes(entityType={}, attributes={}, minExtInfo={}, ignoreRelationships={})", new Object[]{entityType.getTypeName(), attributes.toString(), minExtInfo, ignoreRelationships});
                this.metricsManager.recordJanusGraphNullPointerExceptionError(1);
            }
            throw e;
        }
    }

    @GraphTransaction(logRollback=false)
    public AtlasEntityHeader getHeaderById(String guid) throws AtlasBaseException {
        return this.entityStore.getHeaderById(guid);
    }

    private static boolean isJanusGraphNullPointerException(AtlasBaseException e) {
        int i = ExceptionUtils.indexOfThrowable((Throwable)e, NullPointerException.class);
        if (i == -1) {
            return false;
        }
        Throwable npe = (Throwable)ExceptionUtils.getThrowableList((Throwable)e).get(i);
        String msg = npe.getMessage();
        return msg != null && msg.contains("Could not find type for id");
    }

    static class ObjectWithException {
        private final Object obj;
        private final AtlasBaseException ex;

        public ObjectWithException(Object obj, AtlasBaseException ex) {
            this.obj = obj;
            this.ex = ex;
        }

        public Object getObject() {
            return this.obj;
        }

        public AtlasBaseException getException() {
            return this.ex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectWithException that = (ObjectWithException)o;
            return Objects.equals(this.obj, that.obj) && Objects.equals((Object)this.ex, (Object)that.ex);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.obj, this.ex});
        }
    }
}

