/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.catalog.storage.BusinessMetadataDefValue;
import io.confluent.catalog.storage.BusinessMetadataValue;
import io.confluent.catalog.storage.EntitySnapshotValue;
import io.confluent.catalog.storage.EntityValue;
import io.confluent.catalog.storage.MetadataRegistryKind;
import io.confluent.catalog.storage.TagDefValue;
import io.confluent.catalog.storage.TagValue;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="kind")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EntityValue.class, name="ENTITY"), @JsonSubTypes.Type(value=TagValue.class, name="TAG"), @JsonSubTypes.Type(value=TagDefValue.class, name="TAG_DEF"), @JsonSubTypes.Type(value=BusinessMetadataValue.class, name="BUSINESS_METADATA"), @JsonSubTypes.Type(value=BusinessMetadataDefValue.class, name="BUSINESS_METADATA_DEF"), @JsonSubTypes.Type(value=EntitySnapshotValue.class, name="ENTITY_SNAPSHOT")})
public abstract class MetadataRegistryValue<T> {
    private MetadataRegistryKind kind;
    private T oldValue;
    private T newValue;
    private boolean isDelta;
    private boolean isBatch;
    private long timestamp;

    public MetadataRegistryValue(@JsonProperty(value="kind") MetadataRegistryKind kind, @JsonProperty(value="old") T oldValue, @JsonProperty(value="new") T newValue, @JsonProperty(value="isDelta") boolean isDelta, @JsonProperty(value="isBatch") boolean isBatch, @JsonProperty(value="ts") long timestamp) {
        this.kind = kind;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.isDelta = isDelta;
        this.isBatch = isBatch;
        this.timestamp = timestamp;
    }

    public MetadataRegistryValue(@JsonProperty(value="kind") MetadataRegistryKind kind, @JsonProperty(value="new") T newValue, @JsonProperty(value="ts") long timestamp) {
        this.kind = kind;
        this.newValue = newValue;
        this.timestamp = timestamp;
    }

    @JsonProperty(value="kind")
    public MetadataRegistryKind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(MetadataRegistryKind kind) {
        this.kind = kind;
    }

    @JsonProperty(value="old")
    public T getOldValue() {
        return this.oldValue;
    }

    @JsonProperty(value="old")
    public void setOldValue(T oldValue) {
        this.oldValue = oldValue;
    }

    @JsonProperty(value="new")
    public T getNewValue() {
        return this.newValue;
    }

    @JsonProperty(value="new")
    public void setNewValue(T newValue) {
        this.newValue = newValue;
    }

    @JsonProperty(value="isDelta")
    public boolean isDelta() {
        return this.isDelta;
    }

    @JsonProperty(value="isDelta")
    public void setDelta(boolean isDelta) {
        this.isDelta = isDelta;
    }

    @JsonProperty(value="isBatch")
    public boolean isBatch() {
        return this.isBatch;
    }

    @JsonProperty(value="isBatch")
    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    @JsonProperty(value="ts")
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="ts")
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataRegistryValue that = (MetadataRegistryValue)o;
        return this.kind == that.kind && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue) && this.isDelta == that.isDelta && this.isBatch == that.isBatch && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.oldValue, this.newValue, this.isDelta, this.isBatch, this.timestamp});
    }

    public String toString() {
        return "MetadataRegistryValue{kind=" + (Object)((Object)this.kind) + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", isDelta=" + this.isDelta + ", isBatch=" + this.isBatch + ", timestamp=" + this.timestamp + '}';
    }
}

