/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.util;

import io.confluent.catalog.client.autthorizer.CatalogAuthorizerClient;
import io.confluent.catalog.util.RbacConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class RbacUtils {
    public static String getEntityName(String type, String context, String name) {
        if (context != null) {
            return type + ":" + context + ":" + name;
        }
        return type + ":" + name;
    }

    public static RbacConstants.RbacResourceTypes toRbacResourceType(String type) {
        if (type == null) {
            return null;
        }
        if (type.startsWith("sr_")) {
            return RbacConstants.RbacResourceTypes.CatalogSubject;
        }
        if (type.equals("kafka_topic")) {
            return RbacConstants.RbacResourceTypes.CatalogTopic;
        }
        if (type.equals("kafka_logical_cluster")) {
            return RbacConstants.RbacResourceTypes.CatalogKafkaCluster;
        }
        if (type.equals("kafka_cluster_link")) {
            return RbacConstants.RbacResourceTypes.CatalogKafkaClusterLink;
        }
        if (type.equals("cf_environment")) {
            return RbacConstants.RbacResourceTypes.CatalogEnvironment;
        }
        if (type.startsWith("cn_")) {
            return RbacConstants.RbacResourceTypes.CatalogConnector;
        }
        if (type.startsWith("pl_")) {
            return RbacConstants.RbacResourceTypes.CatalogPipeline;
        }
        return null;
    }

    public static CatalogAuthorizerClient.CatalogAuthorizerAction getUrlEncodedAuthorizerAction(String resourceType, String resourceName, String operation) throws UnsupportedEncodingException {
        return new CatalogAuthorizerClient.CatalogAuthorizerAction(URLEncoder.encode(resourceName, StandardCharsets.UTF_8.toString()), operation, resourceType);
    }
}

