/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.errors;

import io.confluent.catalog.web.errors.ExceptionMapperUtil;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.springframework.stereotype.Component;

@Provider
@Component
public class AtlasBaseExceptionMapper
implements ExceptionMapper<AtlasBaseException> {
    public Response toResponse(AtlasBaseException exception) {
        long id = ThreadLocalRandom.current().nextLong();
        if (exception.getAtlasErrorCode().getHttpCode() == Response.Status.INTERNAL_SERVER_ERROR) {
            ExceptionMapperUtil.logException(id, (Exception)((Object)exception));
        }
        return this.buildAtlasBaseExceptionResponse(exception);
    }

    protected Response buildAtlasBaseExceptionResponse(AtlasBaseException baseException) {
        AtlasErrorCode errorCode = baseException.getAtlasErrorCode();
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)errorCode.getHttpCode());
        if (Response.Status.NO_CONTENT != errorCode.getHttpCode()) {
            responseBuilder.entity((Object)ExceptionMapperUtil.toErrorMessage(baseException));
        }
        return responseBuilder.build();
    }
}

