/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.errors;

import io.confluent.rest.entities.ErrorMessage;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMapperUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(ExceptionMapperUtil.class);

    public static ErrorMessage toErrorMessage(AtlasBaseException baseException) {
        AtlasErrorCode errorCode = baseException.getAtlasErrorCode();
        return new ErrorMessage(ExceptionMapperUtil.errorCodeToInt(errorCode.getErrorCode()), baseException.getMessage());
    }

    private static int errorCodeToInt(String errorCode) {
        try {
            String[] parts = errorCode.split("-");
            return Integer.parseInt(parts[1]) * 10000 + Integer.parseInt(parts[3], 16);
        }
        catch (NumberFormatException e) {
            return 5000000;
        }
    }

    protected static void logException(long id, Exception exception) {
        LOG.error(ExceptionMapperUtil.formatLogMessage(id, exception), (Throwable)exception);
    }

    protected static String formatLogMessage(long id, Throwable exception) {
        return String.format("Error handling a request: %016x", id);
    }
}

