/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.filters;

import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectVersionsResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectsResource;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.entities.ErrorMessage;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMaxQueueSizeFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMaxQueueSizeFilter.class);
    private final SchemaRegistry schemaRegistry;
    private final DataCatalogConfig dataCatalogConfig;
    @Context
    private ResourceInfo resourceInfo;

    public AtlasMaxQueueSizeFilter(SchemaRegistry schemaRegistry) {
        try {
            this.schemaRegistry = schemaRegistry;
            this.dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate AtlasMaxQueueSizeFilter", e);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String method;
        String tenant = (String)requestContext.getProperty("tenant-name");
        if (tenant == null) {
            tenant = this.schemaRegistry.tenant();
        }
        if (tenant == null) {
            return;
        }
        Class resourceClass = this.resourceInfo.getResourceClass();
        switch (method = requestContext.getMethod()) {
            case "POST": {
                if (!SubjectVersionsResource.class.equals((Object)resourceClass)) break;
                this.checkMaxQueueSize(tenant, requestContext);
                break;
            }
            case "DELETE": {
                if (!SubjectVersionsResource.class.equals((Object)resourceClass) && !SubjectsResource.class.equals((Object)resourceClass)) break;
                this.checkMaxQueueSize(tenant, requestContext);
                break;
            }
        }
    }

    private void checkMaxQueueSize(String tenant, ContainerRequestContext requestContext) {
        int maxQueueSize = this.dataCatalogConfig.catalogMaxQueueSize();
        SchemaAtlasHook hook = (SchemaAtlasHook)this.schemaRegistry.properties().get("hook");
        if (hook.getThreadQueueSize(tenant) >= maxQueueSize) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.TOO_MANY_REQUESTS).entity((Object)new ErrorMessage(4290000, "Too many requests. Please try again later.")).build());
        }
    }
}

