/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.netflix.governator.LifecycleInjector;
import io.confluent.catalog.client.autthorizer.CatalogAuthorizerClient;
import io.confluent.catalog.metrics.MetricsManager;
import io.confluent.catalog.web.filters.CatalogRequestContextHolder;
import io.confluent.catalog.web.graphql.resources.GraphQLResource;
import io.confluent.catalog.web.rest.resources.CatalogResource;
import io.confluent.catalog.web.rest.resources.EntityResource;
import io.confluent.catalog.web.rest.resources.SchemaRegistryResource;
import io.confluent.catalog.web.rest.resources.SearchResource;
import io.confluent.catalog.web.rest.resources.TypesResource;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.entities.ErrorMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class CatalogRequestFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogRequestFilter.class);
    private final CatalogAuthorizerClient authorizerRestClient;
    private final MetricsManager metricsManager;
    private final SchemaRegistry schemaRegistry;
    private final LifecycleInjector injector;
    private static final int OPERATION_FORBIDDEN_ERROR_CODE = 40301;
    private final Set<Class<? extends SchemaRegistryResource>> requestRbacEnabledResourceSet = new HashSet<Class<? extends SchemaRegistryResource>>();
    private final Set<Class<? extends SchemaRegistryResource>> responseRbacEnabledResourceSet = new HashSet<Class<? extends SchemaRegistryResource>>();
    @Context
    protected ResourceInfo resourceInfo;
    @Context
    protected HttpServletRequest httpServletRequest;

    public CatalogRequestFilter(SchemaRegistry schemaRegistry, LifecycleInjector injector, CatalogAuthorizerClient authorizerRestClient) {
        this.schemaRegistry = schemaRegistry;
        this.injector = injector;
        this.authorizerRestClient = authorizerRestClient;
        this.metricsManager = (MetricsManager)injector.getInstance(MetricsManager.class);
        if (this.metricsManager == null) {
            LOG.warn("MetricsManager is null");
        }
        this.requestRbacEnabledResourceSet.add(TypesResource.class);
        this.requestRbacEnabledResourceSet.add(EntityResource.class);
        this.requestRbacEnabledResourceSet.add(CatalogResource.class);
        this.responseRbacEnabledResourceSet.add(TypesResource.class);
        this.responseRbacEnabledResourceSet.add(EntityResource.class);
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        String authHeader = containerRequestContext.getHeaderString("Authorization");
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)authHeader, null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        containerRequestContext.setProperty("CATALOG_API_METHOD_NAME_HEADER", (Object)this.getDocumentName());
        containerRequestContext.setProperty("CATALOG_CLIENT_IP", (Object)this.httpServletRequest.getRemoteAddr());
        containerRequestContext.setProperty("CATALOG_PORT_NUMBER", (Object)this.httpServletRequest.getRemoteHost());
        CatalogRequestContextHolder.setRequestContext(containerRequestContext);
        Class resourceClass = this.resourceInfo.getResourceClass();
        String tenant = this.schemaRegistry.tenant();
        if (tenant != null && !tenant.isEmpty() && this.metricsManager != null) {
            try {
                if (SearchResource.class == resourceClass) {
                    this.metricsManager.recordRestfulSearch(tenant);
                } else if (GraphQLResource.class == resourceClass) {
                    this.metricsManager.recordGraphQLSearch(tenant);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to record search request", (Throwable)e);
            }
        }
        if (this.requestRbacEnabledResourceSet.contains(resourceClass)) {
            this.checkRequestRbacPermissions(resourceClass, containerRequestContext, authHeader);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        Class resourceClass = this.resourceInfo.getResourceClass();
        if (this.requestRbacEnabledResourceSet.contains(resourceClass)) {
            String authHeader = containerRequestContext.getHeaderString("Authorization");
            this.checkResponseRbacPermissions(resourceClass, containerRequestContext, containerResponseContext, authHeader);
        }
    }

    private String getDocumentName() {
        String documentedName;
        if (this.resourceInfo.getResourceMethod().getAnnotation(DocumentedName.class) == null) {
            LOG.warn("Documented Name Annotation does not exist for from class " + this.resourceInfo.getResourceMethod().getClass() + " and Method Name " + this.resourceInfo.getResourceMethod().getName());
            documentedName = this.resourceInfo.getResourceMethod().getName();
        } else {
            documentedName = this.resourceInfo.getResourceMethod().getAnnotation(DocumentedName.class).value();
        }
        return documentedName;
    }

    private void checkRequestRbacPermissions(Class resourceClass, ContainerRequestContext containerRequestContext, String authHeader) {
        SchemaRegistryResource schemaRegistryResource = (SchemaRegistryResource)this.injector.getInstance(resourceClass);
        try {
            SchemaRegistryResource.RbacPermissionEntity entity = schemaRegistryResource.getRequestRbacPermissionEntity(containerRequestContext);
            if (entity == null) {
                return;
            }
            if (!this.authorize(containerRequestContext, entity, authHeader)) {
                LOG.info("Operation denied on resource {} for HTTP Method {}", (Object)containerRequestContext.getUriInfo().getPath(), (Object)containerRequestContext.getMethod());
                containerRequestContext.abortWith(this.accessDenied(String.format("User is denied operation %s on resource %s", containerRequestContext.getMethod(), containerRequestContext.getUriInfo().getPath())));
            }
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception during RBAC check", (Throwable)e);
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), String.format("Request failed with exception : %s", e.getMessage()))).build());
        }
        catch (CatalogAuthorizerClient.CatalogAuthorizerRestClientException e) {
            LOG.error("Exception during authorization {}", (Object)e.getMessage());
            containerRequestContext.abortWith(this.getServiceUnavailableErrorResponse(String.format("Failed to check authorization for operation %s on resource %s", containerRequestContext.getMethod(), containerRequestContext.getUriInfo().getPath())));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Exception during request authorization with resource encoding {}", (Object)e.getMessage());
            containerRequestContext.abortWith(this.getServiceUnavailableErrorResponse(String.format("Failed to encode resource %s for operation %s", containerRequestContext.getUriInfo().getPath(), containerRequestContext.getMethod())));
        }
        catch (Exception e) {
            LOG.error("Exception during request authorization with resource encoding {}", (Object)e.getMessage());
            containerRequestContext.abortWith(this.accessDenied(String.format("User is denied operation %s on resource %s", containerRequestContext.getMethod(), containerRequestContext.getUriInfo().getPath())));
        }
    }

    private void checkResponseRbacPermissions(Class resourceClass, ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext, String authHeader) throws IOException {
        Method method = this.resourceInfo.getResourceMethod();
        String resourceMethod = method != null ? method.getName() : null;
        SchemaRegistryResource schemaRegistryResource = (SchemaRegistryResource)this.injector.getInstance(resourceClass);
        try {
            SchemaRegistryResource.RbacPermissionEntity entity = schemaRegistryResource.getResponseRbacPermissionEntity(containerRequestContext, containerResponseContext, resourceMethod);
            if (entity == null) {
                return;
            }
            if (!this.authorize(containerRequestContext, entity, authHeader)) {
                LOG.info("Operation denied on resource {} for HTTP Method {}", (Object)containerRequestContext.getUriInfo().getPath(), (Object)containerRequestContext.getMethod());
                containerResponseContext.setStatus(Response.Status.FORBIDDEN.getStatusCode());
                containerResponseContext.setEntity(this.getDeniedErrorMessage(String.format("User is denied operation %s on resource %s", containerRequestContext.getMethod(), containerRequestContext.getUriInfo().getPath())));
            }
        }
        catch (CatalogAuthorizerClient.CatalogAuthorizerRestClientException e) {
            LOG.error("Exception during authorization {}", (Object)e.getMessage());
            containerResponseContext.setStatus(Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
            containerResponseContext.setEntity(this.getServiceUnavailableErrorMessage(String.format("Failed to check authorization for operation %s on resource %s", containerRequestContext.getMethod(), containerRequestContext.getUriInfo().getPath())));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Exception during response authorization with resource encoding {}", (Object)e.getMessage());
            containerResponseContext.setStatus(Response.Status.NOT_ACCEPTABLE.getStatusCode());
            containerResponseContext.setEntity(this.getServiceUnavailableErrorMessage(String.format("Failed to encode resource %s for operation %s", containerRequestContext.getUriInfo().getPath(), containerRequestContext.getMethod())));
        }
        catch (Exception e) {
            LOG.error("Exception during response authorization with resource encoding {}", (Object)e.getMessage());
            containerResponseContext.setStatus(Response.Status.FORBIDDEN.getStatusCode());
            containerResponseContext.setEntity(this.getDeniedErrorMessage(String.format("User is denied operation %s on resource %s", containerRequestContext.getMethod(), containerRequestContext.getUriInfo().getPath())));
        }
    }

    private Response accessDenied(String msg) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity(this.getDeniedErrorMessage(msg)).build();
    }

    private Object getDeniedErrorMessage(String msg) {
        return new ErrorMessage(Response.Status.FORBIDDEN.getStatusCode(), msg);
    }

    private Response getServiceUnavailableErrorResponse(String msg) {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity(this.getServiceUnavailableErrorMessage(msg)).build();
    }

    private Object getServiceUnavailableErrorMessage(String msg) {
        return new ErrorMessage(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), msg);
    }

    private boolean authorize(ContainerRequestContext context, SchemaRegistryResource.RbacPermissionEntity entity, String authHeader) throws CatalogAuthorizerClient.CatalogAuthorizerRestClientException, UnsupportedEncodingException {
        if (entity.resourceList == null) {
            return false;
        }
        CatalogAuthorizerClient.CatalogAuthorizerRequest request = CatalogRequestFilter.getAuthorizeRequests(entity);
        if (request.getActions().size() == 0) {
            return true;
        }
        List<CatalogAuthorizerClient.CatalogAuthorizerResponse> responses = this.authorizerRestClient.authorize(context, authHeader, request);
        for (CatalogAuthorizerClient.CatalogAuthorizerResponse response : responses) {
            if (response.getResult() == CatalogAuthorizerClient.CatalogAuthorizeResult.ALLOWED) continue;
            LOG.info("Authorization not allowed for resource: {} operation: {}", (Object)response.getResourceName(), (Object)response.getOperation());
            return false;
        }
        return true;
    }

    public static CatalogAuthorizerClient.CatalogAuthorizerRequest getAuthorizeRequests(SchemaRegistryResource.RbacPermissionEntity entity) throws UnsupportedEncodingException {
        LinkedList<CatalogAuthorizerClient.CatalogAuthorizerAction> authorizerActions = new LinkedList<CatalogAuthorizerClient.CatalogAuthorizerAction>();
        for (SchemaRegistryResource.RbacPermissionAction resource : entity.resourceList) {
            if (resource.resourceName == null || resource.resourceName.isEmpty()) {
                LOG.info("Empty resource Name in cluster=" + entity.cluster + " for resourceType=" + (Object)((Object)resource.resourceType));
                continue;
            }
            String encodedResource = URLEncoder.encode(resource.resourceName, StandardCharsets.UTF_8.toString());
            authorizerActions.add(new CatalogAuthorizerClient.CatalogAuthorizerAction(encodedResource, resource.operation.name(), resource.resourceType.getLabel()));
        }
        return new CatalogAuthorizerClient.CatalogAuthorizerRequest("", authorizerActions);
    }
}

