/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.filters;

import io.confluent.catalog.model.instance.BusinessMetadata;
import io.confluent.catalog.model.instance.Tag;
import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.catalog.util.CatalogTenantUtils;
import io.confluent.catalog.web.filters.MultiTenantAuthChecker;
import io.confluent.catalog.web.rest.entities.BusinessMetadataDefResponse;
import io.confluent.catalog.web.rest.entities.BusinessMetadataResponse;
import io.confluent.catalog.web.rest.entities.SchemaTagsResponse;
import io.confluent.catalog.web.rest.entities.SearchResult;
import io.confluent.catalog.web.rest.entities.TagDefResponse;
import io.confluent.catalog.web.rest.entities.TagResponse;
import io.confluent.catalog.web.rest.resources.EntityResource;
import io.confluent.catalog.web.rest.resources.SearchResource;
import io.confluent.catalog.web.rest.resources.TypesResource;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.entities.ErrorMessage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;

public class CatalogResponseWriter
implements WriterInterceptor {
    @Context
    ResourceInfo resourceInfo;
    @Context
    UriInfo uriInfo;
    private final SchemaRegistry schemaRegistry;
    private final MultiTenantAuthChecker multiTenantAuthChecker;

    public CatalogResponseWriter(SchemaRegistry schemaRegistry, MultiTenantAuthChecker multiTenantAuthChecker) {
        this.schemaRegistry = schemaRegistry;
        this.multiTenantAuthChecker = multiTenantAuthChecker;
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        Object response;
        Object modifiedResponse = response = context.getEntity();
        if (this.shouldModifyResponse()) {
            String resourceMethod;
            String tenant = (String)context.getProperty("tenant-name");
            if (tenant == null) {
                tenant = this.schemaRegistry.tenant();
            }
            String tenantPrefix = tenant + "_";
            String typeTenantPrefix = CatalogTenantUtils.tenantToEscaped(tenant) + "__";
            Class resourceClass = this.resourceInfo.getResourceClass();
            Method method = this.resourceInfo.getResourceMethod();
            String string = resourceMethod = method != null ? method.getName() : null;
            if (response instanceof ErrorMessage) {
                modifiedResponse = this.handleErrorMessage(typeTenantPrefix, (ErrorMessage)response);
            } else if (resourceClass != null && response != null) {
                if (resourceClass.equals(EntityResource.class)) {
                    modifiedResponse = this.handleEntityResourceResponse(tenantPrefix, typeTenantPrefix, resourceMethod, response);
                } else if (resourceClass.equals(SearchResource.class)) {
                    modifiedResponse = this.handleSearchResourceResponse(tenant, tenantPrefix, typeTenantPrefix, resourceMethod, response);
                } else if (resourceClass.equals(TypesResource.class)) {
                    modifiedResponse = this.handleTypesResourceResponse(tenantPrefix, typeTenantPrefix, resourceMethod, response);
                }
            }
        }
        context.setEntity(modifiedResponse);
        context.proceed();
    }

    private boolean shouldModifyResponse() {
        return !this.multiTenantAuthChecker.isUnauthenticatedUri(this.uriInfo.getPath(), null);
    }

    private Object handleEntityResourceResponse(String tenantPrefix, String typeTenantPrefix, String resourceMethod, Object response) {
        List<Object> modifiedResponse = response;
        switch (resourceMethod) {
            case "getByUniqueAttributes": {
                modifiedResponse = this.handleEntityResponse(tenantPrefix, typeTenantPrefix, (AtlasEntity.AtlasEntityWithExtInfo)response);
                break;
            }
            case "createTags": 
            case "getTags": 
            case "updateTags": {
                modifiedResponse = this.handleTagsResponse(tenantPrefix, typeTenantPrefix, response);
                break;
            }
            case "createBusinessMetadata": 
            case "getBusinessMetadata": 
            case "updateBusinessMetadata": {
                modifiedResponse = this.handleBMsResponse(tenantPrefix, typeTenantPrefix, (List<BusinessMetadataResponse>)response);
                break;
            }
            case "updateSchemaTags": {
                modifiedResponse = this.handleSchemaTagsResponse(tenantPrefix, typeTenantPrefix, (List<SchemaTagsResponse>)response);
                break;
            }
        }
        return modifiedResponse;
    }

    private AtlasEntity.AtlasEntityWithExtInfo handleEntityResponse(String tenantPrefix, String typeTenantPrefix, AtlasEntity.AtlasEntityWithExtInfo response) {
        if (response.getEntity() != null && response.getEntity().getClassifications() != null) {
            for (AtlasClassification classification : response.getEntity().getClassifications()) {
                String typeName = classification.getTypeName();
                classification.setTypeName(typeName.replaceFirst(typeTenantPrefix, ""));
            }
        }
        if (response.getEntity() != null && response.getEntity().getBusinessAttributes() != null && !response.getEntity().getBusinessAttributes().isEmpty()) {
            response.getEntity().setBusinessAttributes(response.getEntity().getBusinessAttributes().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).replaceFirst(typeTenantPrefix, ""), Map.Entry::getValue)));
        }
        return response;
    }

    private List<TagResponse> handleTagsResponse(String tenantPrefix, String typeTenantPrefix, List<TagResponse> response) {
        return response.stream().map(tag -> {
            TagResponse ret = new TagResponse(this.handleTagResponse(tenantPrefix, typeTenantPrefix, (Tag)((Object)tag)));
            ret.setError(this.handleErrorMessage(typeTenantPrefix, tag.getError()));
            return ret;
        }).collect(Collectors.toList());
    }

    private Tag handleTagResponse(String tenantPrefix, String typeTenantPrefix, Tag response) {
        Tag newTag = new Tag(response);
        if (response.getTypeName() != null) {
            newTag.setTypeName(response.getTypeName().replaceFirst(typeTenantPrefix, ""));
        }
        newTag.setEntityGuid(null);
        return newTag;
    }

    private List<BusinessMetadataResponse> handleBMsResponse(String tenantPrefix, String typeTenantPrefix, List<BusinessMetadataResponse> response) {
        return response.stream().map(bm -> {
            BusinessMetadataResponse ret = new BusinessMetadataResponse(this.handleBMResponse(tenantPrefix, typeTenantPrefix, (BusinessMetadata)((Object)bm)));
            ret.setError(this.handleErrorMessage(typeTenantPrefix, bm.getError()));
            return ret;
        }).collect(Collectors.toList());
    }

    private BusinessMetadata handleBMResponse(String tenantPrefix, String typeTenantPrefix, BusinessMetadata response) {
        BusinessMetadata newBM = new BusinessMetadata(response);
        if (response.getTypeName() != null) {
            newBM.setTypeName(response.getTypeName().replaceFirst(typeTenantPrefix, ""));
        }
        newBM.removeAttribute("__bmName");
        return newBM;
    }

    private List<SchemaTagsResponse> handleSchemaTagsResponse(String tenantPrefix, String typeTenantPrefix, List<SchemaTagsResponse> response) {
        return response.stream().map(schemaTag -> {
            SchemaTagsResponse ret = new SchemaTagsResponse(schemaTag.getSubject(), schemaTag.getId());
            ret.setErrorMessage(this.handleErrorMessage(typeTenantPrefix, schemaTag.getErrorMessage()));
            return ret;
        }).collect(Collectors.toList());
    }

    private Object handleSearchResourceResponse(String tenant, String tenantPrefix, String typeTenantPrefix, String resourceMethod, Object response) {
        Object modifiedResponse = response;
        if (response instanceof SearchResult) {
            modifiedResponse = this.handleSearchResponse(tenant, tenantPrefix, typeTenantPrefix, (SearchResult)response);
        }
        return modifiedResponse;
    }

    private Object handleTypesResourceResponse(String tenantPrefix, String typeTenantPrefix, String resourceMethod, Object response) {
        AtlasBusinessMetadataDef modifiedResponse = response;
        switch (resourceMethod) {
            case "createTagDefs": 
            case "getAllTagDefs": 
            case "updateTagDefs": {
                modifiedResponse = this.handleTagDefsResponse(tenantPrefix, typeTenantPrefix, response);
                break;
            }
            case "getTagDefByName": {
                modifiedResponse = this.handleTagDefResponse(tenantPrefix, typeTenantPrefix, (TagDef)((Object)response));
                break;
            }
            case "createBusinessMetadataDefs": 
            case "getAllBusinessMetadataDefs": 
            case "updateBusinessMetadataDefs": {
                modifiedResponse = this.handleBMDefsResponse(tenantPrefix, typeTenantPrefix, (List<BusinessMetadataDefResponse>)response);
                break;
            }
            case "getBusinessMetadataDefByName": {
                modifiedResponse = this.handleBMDefResponse(tenantPrefix, typeTenantPrefix, (AtlasBusinessMetadataDef)response);
                break;
            }
        }
        return modifiedResponse;
    }

    private SearchResult handleSearchResponse(String tenant, String tenantPrefix, String typeTenantPrefix, SearchResult response) {
        for (AtlasEntityHeader entity : response.getEntities()) {
            String tenantValue = (String)entity.getAttribute("tenant");
            if (!tenantValue.equals(tenant)) {
                this.scrubEntityHeader(entity);
                continue;
            }
            List tagNames = entity.getClassificationNames().stream().map(s -> s.replaceFirst(typeTenantPrefix, "")).collect(Collectors.toList());
            entity.setClassificationNames(tagNames);
        }
        return response;
    }

    private List<TagDefResponse> handleTagDefsResponse(String tenantPrefix, String typeTenantPrefix, List<TagDefResponse> response) {
        return response.stream().map(tagDef -> {
            TagDefResponse ret = new TagDefResponse(this.handleTagDefResponse(tenantPrefix, typeTenantPrefix, (TagDef)((Object)tagDef)));
            ret.setError(this.handleErrorMessage(typeTenantPrefix, tagDef.getError()));
            ret.setColor(tagDef.getColor());
            ret.removeAttribute("__color");
            return ret;
        }).collect(Collectors.toList());
    }

    private TagDef handleTagDefResponse(String tenantPrefix, String typeTenantPrefix, TagDef response) {
        TagDef newTagDef = new TagDef(response);
        newTagDef.setColor(response.getColor());
        if (response.getName() != null) {
            newTagDef.setName(response.getName().replaceFirst(typeTenantPrefix, ""));
        }
        if (response.getDescription() != null) {
            newTagDef.setDescription(response.getDescription().replaceFirst(typeTenantPrefix, ""));
        }
        newTagDef.removeAttribute("__color");
        return newTagDef;
    }

    private List<BusinessMetadataDefResponse> handleBMDefsResponse(String tenantPrefix, String typeTenantPrefix, List<BusinessMetadataDefResponse> response) {
        return response.stream().map(bmDef -> {
            BusinessMetadataDefResponse ret = new BusinessMetadataDefResponse(this.handleBMDefResponse(tenantPrefix, typeTenantPrefix, (AtlasBusinessMetadataDef)bmDef));
            ret.setError(this.handleErrorMessage(typeTenantPrefix, bmDef.getError()));
            return ret;
        }).collect(Collectors.toList());
    }

    private AtlasBusinessMetadataDef handleBMDefResponse(String tenantPrefix, String typeTenantPrefix, AtlasBusinessMetadataDef response) {
        AtlasBusinessMetadataDef newBMDef = new AtlasBusinessMetadataDef(response);
        if (response.getName() != null) {
            newBMDef.setName(response.getName().replaceFirst(typeTenantPrefix, ""));
        }
        if (response.getDescription() != null) {
            newBMDef.setDescription(response.getDescription().replaceFirst(typeTenantPrefix, ""));
        }
        newBMDef.removeAttribute("__bmName");
        newBMDef.setGuid(null);
        return newBMDef;
    }

    private ErrorMessage handleErrorMessage(String typeTenantPrefix, ErrorMessage response) {
        if (response == null) {
            return null;
        }
        String message = response.getMessage().replace(typeTenantPrefix, "");
        return new ErrorMessage(response.getErrorCode(), message);
    }

    private void scrubEntityHeader(AtlasEntityHeader entity) {
        entity.setGuid("-1");
        if (entity.getAttributes() != null) {
            entity.getAttributes().clear();
        }
        if (entity.getClassifications() != null) {
            entity.getClassifications().clear();
        }
        if (entity.getClassificationNames() != null) {
            entity.getClassificationNames().clear();
        }
        if (entity.getMeanings() != null) {
            entity.getMeanings().clear();
        }
        if (entity.getMeaningNames() != null) {
            entity.getMeaningNames().clear();
        }
    }
}

