/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema;

import graphql.GraphQLContext;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.SelectedField;
import io.confluent.catalog.hook.SchemaAtlasTypes;
import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.web.graphql.schema.GraphQLQueryFactory;
import io.confluent.catalog.web.graphql.schema.GraphQLSchemaBuilder;
import io.confluent.catalog.web.graphql.schema.util.BidirectionalContext;
import io.confluent.catalog.web.graphql.schema.util.SearchPredicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeFetcher
implements DataFetcher {
    private static final Logger logger = LoggerFactory.getLogger(AttributeFetcher.class);
    protected final AtlasTypeRegistry typeRegistry;
    protected final AtlasGraph graph;
    protected final EntityGraphRetriever entityRetriever;
    protected final String entityTypeName;
    protected final AtlasEntityType schemaEntityType;
    protected final String attributeName;
    protected final AtlasEntityType relType;

    public AttributeFetcher(AtlasTypeRegistry typeRegistry, AtlasGraph graph, EntityGraphRetriever entityRetriever, String entityTypeName, String attributeName) {
        this(typeRegistry, graph, entityRetriever, entityTypeName, attributeName, null);
    }

    public AttributeFetcher(AtlasTypeRegistry typeRegistry, AtlasGraph graph, EntityGraphRetriever entityRetriever, String entityTypeName, String attributeName, AtlasEntityType relType) {
        this.typeRegistry = typeRegistry;
        this.graph = graph;
        this.entityRetriever = entityRetriever;
        this.entityTypeName = entityTypeName;
        this.schemaEntityType = typeRegistry.getEntityTypeByName(SchemaAtlasTypes.SR_SCHEMA.getName());
        this.attributeName = attributeName;
        this.relType = relType;
    }

    public Object get(DataFetchingEnvironment environment) throws AtlasBaseException {
        GraphQLEnumValueDefinition enumValue;
        GraphQLOutputType fieldType;
        GraphQLContext context = environment.getGraphQlContext();
        String tenant = (String)context.get((Object)"tenant");
        AtlasEntityHeader entity = (AtlasEntityHeader)environment.getSource();
        AtlasEntityType entityType = (AtlasEntityType)this.typeRegistry.getType(this.entityTypeName);
        String attrName = environment.getField().getName();
        if (attrName.equals("entity_status")) {
            return entity.getStatus().name().toLowerCase(Locale.ROOT);
        }
        if (attrName.equals("business_metadata")) {
            return entityType.getBusinessAttributes().entrySet().stream().flatMap(e -> ((Map)e.getValue()).keySet().stream().map(attr -> (String)e.getKey() + "." + attr)).flatMap(attr -> entity.getAttribute(attr) != null ? Stream.of(new BusinessAttribute(QualifiedNameGenerator.stripTypeTenantPrefix(tenant, attr), entity.getAttribute(attr))) : Stream.empty()).collect(Collectors.toList());
        }
        if (attrName.equals("tags")) {
            return entity.getClassificationNames().stream().map(s -> QualifiedNameGenerator.stripTypeTenantPrefix(tenant, s)).collect(Collectors.toList());
        }
        if (attrName.equals("tag_defs")) {
            ArrayList<TagDef> tagDefs = new ArrayList<TagDef>();
            List classificationNames = entity.getClassificationNames();
            for (String classification : classificationNames) {
                TagDef tagDef = new TagDef(this.typeRegistry.getClassificationDefByName(classification));
                if (tagDef.getName() != null) {
                    tagDef.setName(QualifiedNameGenerator.stripTypeTenantPrefix(tenant, tagDef.getName()));
                }
                if (tagDef.getDescription() != null) {
                    tagDef.setDescription(QualifiedNameGenerator.stripTypeTenantPrefix(tenant, tagDef.getDescription()));
                }
                tagDef.getColor();
                tagDefs.add(tagDef);
            }
            return tagDefs;
        }
        Set<String> attrs = environment.getSelectionSet() != null ? environment.getSelectionSet().getImmediateFields().stream().map(SelectedField::getName).filter(name -> !name.equals("__typename")).collect(Collectors.toSet()) : Collections.emptySet();
        Object attrValue = entity.getAttribute(attrName = GraphQLSchemaBuilder.unalias(attrName));
        if (attrValue == null && attrName.equals("schema")) {
            AtlasVertex entityVertex = null;
            String qualifiedName = null;
            String ctx = (String)entity.getAttribute("context");
            Number id = (Number)entity.getAttribute("id");
            try {
                if (ctx != null && id != null) {
                    qualifiedName = QualifiedNameGenerator.getQualifiedName(tenant, ctx, id.intValue());
                    Map<String, String> attributes = Collections.singletonMap("qualifiedName", qualifiedName);
                    entityVertex = AtlasGraphUtilsV2.getVertexByUniqueAttributes((AtlasGraph)this.graph, (AtlasEntityType)this.schemaEntityType, attributes);
                }
            }
            catch (Exception e2) {
                logger.error("Failed to fetch {} attribute by qualifiedName {}", new Object[]{"schema", qualifiedName, e2});
            }
            return this.filter(environment, tenant, entityVertex, attrs);
        }
        if (attrValue instanceof AtlasObjectId) {
            AtlasObjectId objId = (AtlasObjectId)attrValue;
            AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid((AtlasGraph)this.graph, (String)objId.getGuid());
            return this.filter(environment, tenant, entityVertex, attrs);
        }
        if (attrValue instanceof Collection) {
            Collection objIds = (Collection)attrValue;
            ArrayList<AtlasVertex> entityVertices = new ArrayList<AtlasVertex>();
            for (Object obj : objIds) {
                if (!(obj instanceof AtlasObjectId)) continue;
                AtlasObjectId objId = (AtlasObjectId)obj;
                entityVertices.add(AtlasGraphUtilsV2.findByGuid((AtlasGraph)this.graph, (String)objId.getGuid()));
            }
            return this.filter(environment, tenant, entityVertices, attrs);
        }
        AtlasType attrType = entityType.getAttribute(attrName).getAttributeType();
        if (attrType instanceof AtlasEnumType && attrValue instanceof String && (fieldType = environment.getFieldDefinition().getType()) instanceof GraphQLEnumType && (enumValue = ((GraphQLEnumType)fieldType).getValue((String)attrValue)) != null) {
            return enumValue.getValue();
        }
        return attrValue;
    }

    private AtlasEntityHeader filter(DataFetchingEnvironment env, String tenant, AtlasVertex entityVertex, Set<String> attrs) throws AtlasBaseException {
        List<String> tags;
        SearchParameters.FilterCriteria attrCriteria = GraphQLQueryFactory.getAttrCriteria(env, tenant);
        Predicate predicate = SearchPredicates.toInMemoryPredicate(this.typeRegistry, (AtlasStructType)this.relType, attrCriteria, tags = GraphQLQueryFactory.getTags(env, tenant));
        if (predicate != null && !predicate.evaluate((Object)entityVertex)) {
            BidirectionalContext localContext = (BidirectionalContext)env.getLocalContext();
            localContext.setSkip(true);
            return null;
        }
        return this.entityRetriever.toAtlasEntityHeader(entityVertex, attrs);
    }

    private List<AtlasEntityHeader> filter(DataFetchingEnvironment env, String tenant, List<AtlasVertex> entityVertices, Set<String> attrs) throws AtlasBaseException {
        List<String> tags;
        SearchParameters.FilterCriteria attrCriteria = GraphQLQueryFactory.getAttrCriteria(env, tenant);
        Predicate predicate = SearchPredicates.toInMemoryPredicate(this.typeRegistry, (AtlasStructType)this.relType, attrCriteria, tags = GraphQLQueryFactory.getTags(env, tenant));
        if (predicate != null && (entityVertices = entityVertices.stream().filter(v -> predicate.evaluate(v)).collect(Collectors.toList())).isEmpty()) {
            BidirectionalContext localContext = (BidirectionalContext)env.getLocalContext();
            localContext.setSkip(true);
            return null;
        }
        ArrayList<AtlasEntityHeader> entities = new ArrayList<AtlasEntityHeader>();
        for (AtlasVertex atlasVertex : entityVertices) {
            entities.add(this.entityRetriever.toAtlasEntityHeader(atlasVertex, attrs));
        }
        return entities;
    }

    public static class BusinessAttribute {
        private String name;
        private Object value;

        public BusinessAttribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BusinessAttribute that = (BusinessAttribute)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }
}

