/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.confluent.catalog.web.filters.CatalogRequestContextHolder;
import io.confluent.catalog.web.graphql.schema.GraphQLQueryFactory;
import io.confluent.catalog.web.graphql.schema.util.BidirectionalContext;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class EntityFetcher
implements DataFetcher {
    protected final KafkaSchemaRegistry schemaRegistry;
    protected final GraphQLQueryFactory queryFactory;

    public EntityFetcher(KafkaSchemaRegistry schemaRegistry, GraphQLQueryFactory queryFactory) {
        this.schemaRegistry = schemaRegistry;
        this.queryFactory = queryFactory;
    }

    public Object get(DataFetchingEnvironment environment) throws AtlasBaseException {
        ContainerRequestContext requestContext;
        String requestId = (String)environment.getGraphQlContext().get((Object)"request_id");
        if (requestId == null || requestId.isEmpty()) {
            MDC.remove((String)"requestId");
        } else {
            MDC.put((String)"requestId", (String)requestId);
        }
        String tenant = (String)environment.getGraphQlContext().get((Object)"tenant");
        if (tenant == null || tenant.isEmpty()) {
            this.schemaRegistry.setTenant(null);
            MDC.remove((String)"tenantName");
        } else {
            this.schemaRegistry.setTenant(tenant);
            MDC.put((String)"tenantName", (String)tenant);
        }
        Authentication auth = (Authentication)environment.getGraphQlContext().get((Object)"auth");
        if (auth != null) {
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
        if ((requestContext = (ContainerRequestContext)environment.getGraphQlContext().get((Object)"request_context")) != null) {
            CatalogRequestContextHolder.setRequestContext(requestContext);
        }
        List<AtlasEntityHeader> result = this.queryFactory.queryResult(environment);
        return new DataFetcherResult.Builder().data(result).localContext((Object)new BidirectionalContext()).build();
    }
}

