/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.analysis.MaxQueryDepthInstrumentation;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ResultPath;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.parser.InvalidSyntaxException;
import graphql.schema.GraphQLSchema;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.web.filters.CatalogRequestContextHolder;
import io.confluent.catalog.web.graphql.schema.GraphQLSchemaBuilder;
import io.confluent.catalog.web.graphql.schema.timeout.QueryTimeoutException;
import io.confluent.catalog.web.graphql.schema.util.AsyncBidirectionalContextExecutionStrategy;
import io.confluent.catalog.web.graphql.schema.util.DefaultDataFetcherExceptionHandler;
import io.confluent.catalog.web.graphql.schema.util.DefaultGraphQLError;
import io.confluent.catalog.web.graphql.schema.util.LimitOffset;
import io.confluent.catalog.web.graphql.schema.util.QueryParser;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class GraphQLExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLExecutor.class);
    private static final int MIN_LIMIT_PER_ITERATION = 100;
    private final int timeoutMs;
    private final int maxLimitPerIteration;
    private volatile GraphQL graphQL;
    private final KafkaSchemaRegistry schemaRegistry;
    private final GraphQLSchemaBuilder graphQLSchemaBuilder;
    private final int maxComplexity;
    private final int maxDepth;

    @Inject
    public GraphQLExecutor(SchemaRegistry schemaRegistry, GraphQLSchemaBuilder builder) {
        try {
            this.schemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
            this.graphQLSchemaBuilder = builder;
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(this.schemaRegistry.config().originalProperties());
            this.timeoutMs = dataCatalogConfig.catalogGraphQLTimeoutMs();
            this.maxLimitPerIteration = dataCatalogConfig.getCatalogMaxLimitPerIteration();
            this.maxComplexity = dataCatalogConfig.catalogGraphQLMaxComplexity();
            this.maxDepth = dataCatalogConfig.catalogGraphQLMaxDepth();
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate GraphQLExecutor", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphQL getGraphQL() {
        if (this.graphQL == null) {
            GraphQLExecutor graphQLExecutor = this;
            synchronized (graphQLExecutor) {
                if (this.graphQL == null) {
                    GraphQLSchema graphQLSchema = this.graphQLSchemaBuilder.getGraphQLSchema();
                    this.graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).queryExecutionStrategy((ExecutionStrategy)new AsyncBidirectionalContextExecutionStrategy(new DefaultDataFetcherExceptionHandler())).instrumentation(this.getInstrumentation()).build();
                }
            }
        }
        return this.graphQL;
    }

    private Instrumentation getInstrumentation() {
        return new ChainedInstrumentation(Arrays.asList(new MaxQueryDepthInstrumentation(this.maxDepth), new MaxQueryComplexityInstrumentation(this.maxComplexity)));
    }

    public ExecutionResult execute(String tenant, String requestId, String query) {
        return this.execute(tenant, requestId, query, null, false);
    }

    public ExecutionResult execute(String tenant, String requestId, String query, Map<String, Object> arguments, boolean refill) {
        QueryParser parser;
        try {
            parser = new QueryParser(query);
        }
        catch (InvalidSyntaxException e) {
            return new ExecutionResultImpl.Builder().addError((GraphQLError)new InvalidSyntaxError(Collections.singletonList(e.getLocation()), e.getMessage(), e.getSourcePreview(), e.getOffendingToken())).build();
        }
        if (refill && !parser.isIntrospectionQuery() && parser.isSingleQuery()) {
            long startTime = System.currentTimeMillis();
            Map<String, LimitOffset> userProvidedLimitOffsets = parser.getLimitOffsets();
            Map<String, LimitOffset> limitOffsets = this.getNewLimitOffsetsMap(userProvidedLimitOffsets);
            ExecutionResult interimResults = null;
            while (System.currentTimeMillis() - startTime < 2L * (long)this.timeoutMs) {
                ExecutionInput executionInput = this.getExecutionInput(tenant, requestId, query, arguments, limitOffsets);
                ExecutionResult result = this.getGraphQL().execute(executionInput);
                if (!this.stoppingConditionReached(interimResults = this.updateResults(interimResults, result), userProvidedLimitOffsets, limitOffsets, executionInput.getGraphQLContext())) continue;
                result = this.trimResults(interimResults, userProvidedLimitOffsets);
                return this.processGraphQLResults(result);
            }
            return this.timeoutResult(interimResults, userProvidedLimitOffsets);
        }
        ExecutionInput executionInput = this.getExecutionInput(tenant, requestId, query, arguments, null);
        ExecutionResult result = this.getGraphQL().execute(executionInput);
        return this.processGraphQLResults(result);
    }

    private ExecutionResult timeoutResult(ExecutionResult interimResults, Map<String, LimitOffset> userProvidedLimitOffsets) {
        ExecutionResultImpl.Builder result = ExecutionResultImpl.newExecutionResult();
        for (Map.Entry<String, LimitOffset> limitOffsetEntry : userProvidedLimitOffsets.entrySet()) {
            String alias = limitOffsetEntry.getKey().split(":")[1];
            ResultPath rootPath = ResultPath.rootPath();
            result.addError((GraphQLError)new DefaultGraphQLError(rootPath.segment(alias), new QueryTimeoutException("Maximum query duration of " + 2 * this.timeoutMs + " ms exceeded."), null));
        }
        return result.build();
    }

    private ExecutionResult trimResults(ExecutionResult interimResults, Map<String, LimitOffset> userProvidedLimitOffsets) {
        LinkedHashMap finalResultMap = new LinkedHashMap();
        if (interimResults.isDataPresent() && interimResults.getData() != null) {
            for (Map.Entry<String, LimitOffset> limitOffset : userProvidedLimitOffsets.entrySet()) {
                int limit = limitOffset.getValue().getLimit();
                int offset = limitOffset.getValue().getOffset();
                String key = limitOffset.getKey().split(":")[1];
                List resultList = (List)((Map)interimResults.getData()).get(key);
                ArrayList finalResultList = null;
                if (resultList != null) {
                    finalResultList = new ArrayList();
                    limit = Math.min(limit + offset, resultList.size());
                    for (int i = offset; i < limit; ++i) {
                        finalResultList.add(resultList.get(i));
                    }
                }
                finalResultMap.put(key, finalResultList);
            }
        }
        return new ExecutionResultImpl.Builder().from(interimResults).data(finalResultMap).build();
    }

    private boolean stoppingConditionReached(ExecutionResult interimResults, Map<String, LimitOffset> userProvidedLimitOffsets, Map<String, LimitOffset> limitOffsets, GraphQLContext graphQLContext) {
        boolean stopLoop = true;
        if (interimResults.getErrors() != null && interimResults.getErrors().size() > 0) {
            return true;
        }
        Map topLvlResultMap = (Map)interimResults.getData();
        for (Map.Entry<String, LimitOffset> pairEntry : userProvidedLimitOffsets.entrySet()) {
            String keys = pairEntry.getKey();
            int fetchedSize = (Integer)graphQLContext.get((Object)String.format("%s:%s", keys, "fetchedData"));
            LimitOffset limitOffset = limitOffsets.get(String.format("%s:%s", keys, "limitOffset"));
            boolean hasMoreData = fetchedSize >= limitOffset.getLimit();
            List entityResult = (List)topLvlResultMap.get(keys.split(":")[1]);
            LimitOffset usrlimitOffset = pairEntry.getValue();
            boolean needsMoreData = true;
            int resultCount = 0;
            if (entityResult != null) {
                resultCount = entityResult.size();
                boolean bl = needsMoreData = resultCount < usrlimitOffset.getLimit() + usrlimitOffset.getOffset();
            }
            if (!needsMoreData || !hasMoreData) continue;
            String limitOffsetKey = String.format("%s:%s", keys, "limitOffset");
            int newOffset = limitOffsets.get(limitOffsetKey).getLimit() + limitOffsets.get(limitOffsetKey).getOffset();
            int newLimit = Math.min(this.maxLimitPerIteration, Math.max(100, pairEntry.getValue().getLimit() + pairEntry.getValue().getOffset() - resultCount));
            limitOffsets.put(limitOffsetKey, new LimitOffset(newLimit, newOffset));
            stopLoop = false;
        }
        return stopLoop;
    }

    private ExecutionResult updateResults(ExecutionResult interimResults, ExecutionResult result) {
        if (interimResults == null) {
            interimResults = new ExecutionResultImpl.Builder().from(result).build();
            return interimResults;
        }
        Map intermResultData = (Map)interimResults.getData();
        if (result.getErrors() != null && result.getErrors().size() > 0) {
            return new ExecutionResultImpl.Builder().from(result).data((Object)intermResultData).addErrors(result.getErrors()).build();
        }
        if (result.isDataPresent() && result.getData() != null) {
            Map resultData = (Map)result.getData();
            for (Map.Entry entry : resultData.entrySet()) {
                if (intermResultData.containsKey(entry.getKey()) && intermResultData.get(entry.getKey()) != null) {
                    if (entry.getValue() == null) continue;
                    ((List)intermResultData.get(entry.getKey())).addAll((List)entry.getValue());
                    continue;
                }
                intermResultData.put(entry.getKey(), entry.getValue());
            }
        }
        return new ExecutionResultImpl.Builder().from(result).data((Object)intermResultData).build();
    }

    private Map<String, LimitOffset> getNewLimitOffsetsMap(Map<String, LimitOffset> userProvidedLimitOffsets) {
        LinkedHashMap<String, LimitOffset> result = new LinkedHashMap<String, LimitOffset>();
        for (Map.Entry<String, LimitOffset> entry : userProvidedLimitOffsets.entrySet()) {
            int startingLimit = Math.min(this.maxLimitPerIteration, Math.max(entry.getValue().getLimit(), entry.getValue().getLimit() + entry.getValue().getOffset()));
            result.put(String.format("%s:%s", entry.getKey(), "limitOffset"), new LimitOffset(startingLimit, 0));
        }
        return result;
    }

    ExecutionInput getExecutionInput(String tenant, String requestId, String query, Map<String, Object> arguments, Map<String, LimitOffset> limitOffsets) {
        ContainerRequestContext requestContext;
        Authentication authentication;
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput().query(query);
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (tenant != null) {
            context.put("tenant", tenant);
        }
        if (requestId != null) {
            context.put("request_id", requestId);
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) != null) {
            context.put("auth", authentication);
        }
        if ((requestContext = CatalogRequestContextHolder.getRequestContext()) != null) {
            context.put("request_context", requestContext);
        }
        if (limitOffsets != null) {
            context.putAll(limitOffsets);
            context.put("refill", true);
        }
        builder = builder.graphQLContext(context);
        if (arguments != null) {
            builder = builder.variables(arguments);
        }
        return builder.build();
    }

    private ExecutionResult processGraphQLResults(ExecutionResult result) {
        if (result.getErrors().size() > 0 || !result.isDataPresent()) {
            return result;
        }
        Map inputData = (Map)result.getData();
        LinkedHashMap outputData = new LinkedHashMap();
        inputData.forEach((key, value) -> {
            if (key.endsWith("_count") && value != null && !((List)value).isEmpty()) {
                int count = ((List)value).size();
                HashMap<String, Object> newValue = new HashMap<String, Object>((Map)((List)value).get(0));
                newValue.forEach((k, v) -> newValue.put((String)k, null));
                if (newValue.containsKey("entity_count")) {
                    newValue.put("entity_count", count);
                }
                outputData.put(key, Collections.singletonList(newValue));
            } else {
                outputData.put(key, value);
            }
        });
        return new ExecutionResultImpl.Builder().from(result).data(outputData).build();
    }
}

