/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema;

import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.InputValueWithState;
import graphql.schema.SelectedField;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.web.filters.CatalogRbacAuthorizationFilter;
import io.confluent.catalog.web.graphql.schema.GraphQLSchemaBuilder;
import io.confluent.catalog.web.graphql.schema.Logical;
import io.confluent.catalog.web.graphql.schema.PredicateFilter;
import io.confluent.catalog.web.graphql.schema.util.DataFetchingEnvironmentBuilder;
import io.confluent.catalog.web.graphql.schema.util.GraphQLSupport;
import io.confluent.catalog.web.graphql.schema.util.LimitOffset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.SortOrder;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLQueryFactory {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLQueryFactory.class);
    public static final String DESC = "desc";
    protected final AtlasDiscoveryService discoveryService;
    protected final AtlasTypeRegistry typeRegistry;
    protected final String entityTypeName;
    private final GraphQLImplementingType implementingType;

    private GraphQLQueryFactory(Builder builder) {
        this.discoveryService = builder.discoveryService;
        this.typeRegistry = builder.typeRegistry;
        this.entityTypeName = builder.entityTypeName;
        this.implementingType = builder.implementingType;
    }

    public List<AtlasEntityHeader> queryResult(DataFetchingEnvironment env) throws AtlasBaseException {
        GraphQLContext context = env.getGraphQlContext();
        String tenant = (String)context.get((Object)"tenant");
        List<String> attrs = env.getSelectionSet() != null ? env.getSelectionSet().getImmediateFields().stream().map(SelectedField::getName).filter(name -> !name.equals("__typename")).flatMap(name -> {
            if (name.equals("business_metadata")) {
                AtlasEntityType entityType;
                try {
                    entityType = (AtlasEntityType)this.typeRegistry.getType(this.entityTypeName);
                }
                catch (AtlasBaseException e2) {
                    return Stream.empty();
                }
                return entityType.getBusinessAttributes().entrySet().stream().flatMap(e -> ((Map)e.getValue()).keySet().stream().filter(attr -> !attr.equals("__bmName")).map(attr -> QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, (String)e.getKey()) + "." + attr));
            }
            return Stream.of(GraphQLSchemaBuilder.unalias(name));
        }).collect(Collectors.toList()) : Collections.emptyList();
        SearchParameters.FilterCriteria attrCriteria = GraphQLQueryFactory.getAttrCriteria(env, tenant);
        List<String> tags = GraphQLQueryFactory.getTags(env, tenant);
        String orderByAttribute = "qualifiedName";
        SortOrder orderByDirection = SortOrder.ASCENDING;
        Optional<Argument> orderByArg = GraphQLQueryFactory.getArgument(env.getField(), "order_by");
        if (orderByArg.isPresent()) {
            Object orderByValue = GraphQLQueryFactory.getValue(orderByArg.get(), env);
            if (orderByValue instanceof ArrayValue) {
                ObjectValue objectValue;
                ArrayValue orderByValues = (ArrayValue)orderByValue;
                if (orderByValues.getValues().size() > 0 && (objectValue = (ObjectValue)orderByValues.getValues().get(0)).getObjectFields().size() > 0) {
                    ObjectField objectField = (ObjectField)objectValue.getObjectFields().get(0);
                    orderByAttribute = objectField.getName();
                    orderByDirection = DESC.equals(((EnumValue)objectField.getValue()).getName()) ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                }
            } else {
                ObjectValue objectValue = (ObjectValue)orderByValue;
                if (objectValue.getObjectFields().size() > 0) {
                    ObjectField objectField = (ObjectField)objectValue.getObjectFields().get(0);
                    orderByAttribute = objectField.getName();
                    orderByDirection = DESC.equals(((EnumValue)objectField.getValue()).getName()) ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                }
            }
        }
        boolean deleted = false;
        Optional<Argument> deletedArg = GraphQLQueryFactory.getArgument(env.getField(), "deleted");
        if (deletedArg.isPresent()) {
            BooleanValue deletedValue = (BooleanValue)GraphQLQueryFactory.getValue(deletedArg.get(), env);
            deleted = deletedValue.isValue();
        }
        int limit = 0;
        int offset = 0;
        if (((Boolean)env.getGraphQlContext().getOrDefault((Object)"refill", (Object)false)).booleanValue()) {
            LimitOffset limitOffset = (LimitOffset)env.getGraphQlContext().get((Object)String.format("%s:%s:%s", env.getField().getName(), env.getField().getAlias() == null ? env.getField().getName() : env.getField().getAlias(), "limitOffset"));
            limit = limitOffset.getLimit();
            offset = limitOffset.getOffset();
        } else {
            Optional<Argument> offsetArg;
            Optional<Argument> limitArg = GraphQLQueryFactory.getArgument(env.getField(), "limit");
            if (limitArg.isPresent()) {
                IntValue limitValue = (IntValue)GraphQLQueryFactory.getValue(limitArg.get(), env);
                limit = limitValue.getValue().intValue();
            }
            if ((offsetArg = GraphQLQueryFactory.getArgument(env.getField(), "offset")).isPresent()) {
                IntValue offsetValue = (IntValue)GraphQLQueryFactory.getValue(offsetArg.get(), env);
                offset = offsetValue.getValue().intValue();
            }
        }
        AtlasSearchResult result = this.searchTypeUsingAttribute(tenant, this.entityTypeName, tags, attrs, attrCriteria, orderByAttribute, orderByDirection, deleted, limit, offset, env);
        return result.getEntities();
    }

    private AtlasSearchResult searchTypeUsingAttribute(String tenant, String type, List<String> tags, List<String> attrs, SearchParameters.FilterCriteria attrFilters, String orderByAttribute, SortOrder orderByDirection, boolean includeDeleted, int limit, int offset, DataFetchingEnvironment env) throws AtlasBaseException {
        AtlasSearchResult searchResult;
        SearchParameters searchParams = new SearchParameters();
        HashSet<String> attributes = new HashSet<String>(attrs);
        attributes.add("tenant");
        attributes.add("name");
        attributes.add("nameLower");
        attributes.add("qualifiedName");
        if (type.startsWith("sr_")) {
            attributes.add("context");
            attributes.add("id");
        }
        searchParams.setAttributes(attributes);
        ArrayList<SearchParameters.FilterCriteria> criteria = new ArrayList<SearchParameters.FilterCriteria>();
        criteria.add(attrFilters);
        SearchParameters.FilterCriteria tenantFilter = new SearchParameters.FilterCriteria();
        tenantFilter.setAttributeName("tenant");
        tenantFilter.setOperator(SearchParameters.Operator.EQ);
        tenantFilter.setAttributeValue(tenant);
        criteria.add(tenantFilter);
        ArrayList<SearchParameters.FilterCriteria> deprecatedTimeCriteria = new ArrayList<SearchParameters.FilterCriteria>();
        SearchParameters.FilterCriteria deprecatedTimeFilterZero = new SearchParameters.FilterCriteria();
        deprecatedTimeFilterZero.setAttributeName("deprecatedTime");
        deprecatedTimeFilterZero.setOperator(SearchParameters.Operator.EQ);
        deprecatedTimeFilterZero.setAttributeValue("0");
        deprecatedTimeCriteria.add(deprecatedTimeFilterZero);
        SearchParameters.FilterCriteria deprecatedTimeFilterNull = new SearchParameters.FilterCriteria();
        deprecatedTimeFilterNull.setAttributeName("deprecatedTime");
        deprecatedTimeFilterNull.setOperator(SearchParameters.Operator.IS_NULL);
        deprecatedTimeCriteria.add(deprecatedTimeFilterNull);
        SearchParameters.FilterCriteria deprecatedTimeFilters = new SearchParameters.FilterCriteria();
        deprecatedTimeFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        deprecatedTimeFilters.setCriterion(deprecatedTimeCriteria);
        criteria.add(deprecatedTimeFilters);
        SearchParameters.FilterCriteria filters = new SearchParameters.FilterCriteria();
        filters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        filters.setCriterion(criteria);
        searchParams.setTypeName(type);
        searchParams.setClassification(String.join((CharSequence)",", tags));
        searchParams.setEntityFilters(filters);
        searchParams.setExcludeDeletedEntities(!includeDeleted);
        searchParams.setOffset(offset);
        searchParams.setLimit(limit);
        searchParams.setSortBy(orderByAttribute);
        searchParams.setSortOrder(orderByDirection);
        long startTimeMs = System.currentTimeMillis();
        try {
            searchResult = this.discoveryService.searchWithParameters(searchParams);
        }
        catch (AtlasBaseException e) {
            logger.error("GraphQL search failed", (Throwable)e);
            if (AtlasErrorCode.UNKNOWN_CLASSIFICATION != e.getAtlasErrorCode()) {
                throw e;
            }
            searchResult = new AtlasSearchResult(searchParams);
        }
        long endTimeMs = System.currentTimeMillis();
        logger.info("GraphQLSearch type: {}, attr: {}, op: {}, by tag: {}, latency: {}, startTs: {}, endTs: {}", new Object[]{type, attrFilters.getAttributeName(), attrFilters.getOperator(), tags.size() > 0, endTimeMs - startTimeMs, startTimeMs, endTimeMs});
        if (((Boolean)env.getGraphQlContext().getOrDefault((Object)"refill", (Object)false)).booleanValue()) {
            int fetchedResult = 0;
            fetchedResult = CatalogRbacAuthorizationFilter.getPreRbacResultSize() == null ? (searchResult.getEntities() == null ? 0 : searchResult.getEntities().size()) : CatalogRbacAuthorizationFilter.getPreRbacResultSize();
            CatalogRbacAuthorizationFilter.removePreRbacResultSize();
            env.getGraphQlContext().put((Object)String.format("%s:%s:%s", env.getMergedField().getSingleField().getName(), env.getField().getAlias() == null ? env.getField().getName() : env.getField().getAlias(), "fetchedData"), (Object)fetchedResult);
        }
        return searchResult;
    }

    protected static List<SearchParameters.FilterCriteria> getBusinessMetadataCriteriaQuery(DataFetchingEnvironment environment, String tenant, ArrayValue value) {
        return value.getValues().stream().map(it -> GraphQLQueryFactory.getBusinessMetadataPredicate(environment, tenant, (ObjectValue)it)).collect(Collectors.toList());
    }

    protected static SearchParameters.FilterCriteria getBusinessMetadataPredicate(DataFetchingEnvironment environment, String tenant, ObjectValue value) {
        SearchParameters.FilterCriteria criteria = new SearchParameters.FilterCriteria();
        value.getObjectFields().forEach(it -> {
            LinkedHashMap<String, Object> valueArguments = new LinkedHashMap<String, Object>();
            valueArguments.put(it.getName(), environment.getArgument(it.getName()));
            DataFetchingEnvironment dataFetchingEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(valueArguments).build();
            Argument dataFetchingArgument = new Argument(it.getName(), it.getValue());
            Object filterValue = GraphQLQueryFactory.convertValue(dataFetchingEnvironment, dataFetchingArgument, it.getValue());
            if (it.getName().equals("name")) {
                criteria.setAttributeName(QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, filterValue.toString()));
            } else if (it.getName().equals("value")) {
                criteria.setOperator(SearchParameters.Operator.EQ);
                criteria.setAttributeValue(filterValue.toString());
            } else if (it.getName().equals("valuePrefix")) {
                criteria.setOperator(SearchParameters.Operator.STARTS_WITH);
                criteria.setAttributeValue(filterValue.toString());
            }
        });
        if (criteria.getAttributeValue() == null) {
            criteria.setOperator(SearchParameters.Operator.STARTS_WITH);
            criteria.setAttributeValue("");
        }
        return criteria;
    }

    protected static SearchParameters.FilterCriteria getAttrCriteria(DataFetchingEnvironment env, String tenant) {
        ArrayValue bmValue;
        List<SearchParameters.FilterCriteria> bmCriteria;
        SearchParameters.FilterCriteria attrCriteria = GraphQLQueryFactory.getCriteriaQuery(env, env.getField());
        Optional<Argument> bmArg = GraphQLQueryFactory.getArgument(env.getField(), "business_metadata");
        if (bmArg.isPresent() && !(bmCriteria = GraphQLQueryFactory.getBusinessMetadataCriteriaQuery(env, tenant, bmValue = (ArrayValue)GraphQLQueryFactory.getValue(bmArg.get(), env))).isEmpty()) {
            logger.info("GraphQL search by BM");
            ArrayList<SearchParameters.FilterCriteria> criterion = attrCriteria.getCriterion();
            if (criterion == null) {
                criterion = new ArrayList<SearchParameters.FilterCriteria>();
            }
            criterion.addAll(bmCriteria);
            attrCriteria = GraphQLQueryFactory.getCompoundPredicate(criterion, Logical.AND);
        }
        return attrCriteria;
    }

    protected static List<String> getTags(DataFetchingEnvironment env, String tenant) {
        List<String> tags = new ArrayList<String>();
        Optional<Argument> tagsArg = GraphQLQueryFactory.getArgument(env.getField(), "tags");
        if (tagsArg.isPresent()) {
            Object tagValue = GraphQLQueryFactory.getValue(tagsArg.get(), env);
            tags = tagValue instanceof ArrayValue ? ((ArrayValue)tagValue).getValues().stream().map(it -> QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, ((StringValue)it).getValue())).collect(Collectors.toList()) : Collections.singletonList(QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, ((StringValue)tagValue).getValue()));
        }
        return tags;
    }

    protected static SearchParameters.FilterCriteria getCriteriaQuery(DataFetchingEnvironment environment, Field field) {
        List<SearchParameters.FilterCriteria> predicates = GraphQLQueryFactory.getFieldPredicates(field, environment);
        return GraphQLQueryFactory.getCompoundPredicate(predicates, Logical.AND);
    }

    protected static List<SearchParameters.FilterCriteria> getFieldPredicates(Field field, DataFetchingEnvironment environment) {
        ArrayList<SearchParameters.FilterCriteria> predicates = new ArrayList<SearchParameters.FilterCriteria>();
        field.getArguments().stream().map(it -> GraphQLQueryFactory.getPredicate(field, environment, it)).filter(Objects::nonNull).forEach(predicates::add);
        return predicates;
    }

    protected static Optional<Argument> getArgument(Field selectedField, String argumentName) {
        return selectedField.getArguments().stream().filter(it -> it.getName().equals(argumentName)).findFirst();
    }

    protected static SearchParameters.FilterCriteria getPredicate(Field field, DataFetchingEnvironment environment, Argument argument) {
        if (!GraphQLSupport.isWhereArgument(argument)) {
            return null;
        }
        return GraphQLQueryFactory.getWherePredicate(GraphQLQueryFactory.argumentEnvironment(environment, argument), argument);
    }

    private static <R extends Value<?>> R getValue(Argument argument, DataFetchingEnvironment environment) {
        Value value = argument.getValue();
        if (value instanceof VariableReference) {
            Object variableValue = GraphQLQueryFactory.getVariableReferenceValue((VariableReference)value, environment);
            GraphQLArgument graphQLArgument = environment.getExecutionStepInfo().getFieldDefinition().getArgument(argument.getName());
            return (R)ValuesResolver.valueToLiteral((InputValueWithState)InputValueWithState.newExternalValue((Object)variableValue), (GraphQLType)graphQLArgument.getType(), (GraphQLContext)GraphQLContext.getDefault(), (Locale)Locale.getDefault());
        }
        return (R)value;
    }

    private static Object getVariableReferenceValue(VariableReference variableReference, DataFetchingEnvironment env) {
        return env.getVariables().get(variableReference.getName());
    }

    protected static SearchParameters.FilterCriteria getWherePredicate(DataFetchingEnvironment environment, Argument argument) {
        ObjectValue whereValue = (ObjectValue)GraphQLQueryFactory.getValue(argument, environment);
        if (whereValue.getChildren().isEmpty()) {
            return new SearchParameters.FilterCriteria();
        }
        Logical logical = GraphQLQueryFactory.extractLogical(argument);
        LinkedHashMap<String, Map> predicateArguments = new LinkedHashMap<String, Map>();
        predicateArguments.put(logical.symbol(), environment.getArguments());
        DataFetchingEnvironment predicateDataFetchingEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(predicateArguments).build();
        Argument predicateArgument = new Argument(logical.symbol(), (Value)whereValue);
        return GraphQLQueryFactory.getArgumentPredicate(predicateDataFetchingEnvironment, predicateArgument);
    }

    protected static SearchParameters.FilterCriteria getArgumentPredicate(DataFetchingEnvironment environment, Argument argument) {
        ObjectValue whereValue = (ObjectValue)GraphQLQueryFactory.getValue(argument, environment);
        if (whereValue.getChildren().isEmpty()) {
            return new SearchParameters.FilterCriteria();
        }
        Logical logical = GraphQLQueryFactory.extractLogical(argument);
        ArrayList<SearchParameters.FilterCriteria> predicates = new ArrayList<SearchParameters.FilterCriteria>();
        whereValue.getObjectFields().stream().filter(it -> Logical.symbols().contains(it.getName())).map(it -> {
            Map<String, Object> arguments = GraphQLQueryFactory.getFieldArguments(environment, it, argument);
            if (it.getValue() instanceof ArrayValue) {
                return GraphQLQueryFactory.getArgumentsPredicate(GraphQLQueryFactory.argumentEnvironment(environment, arguments), new Argument(it.getName(), it.getValue()));
            }
            return GraphQLQueryFactory.getArgumentPredicate(GraphQLQueryFactory.argumentEnvironment(environment, arguments), new Argument(it.getName(), it.getValue()));
        }).forEach(predicates::add);
        whereValue.getObjectFields().stream().filter(it -> !Logical.symbols().contains(it.getName())).map(it -> {
            Map<String, Object> args = GraphQLQueryFactory.getFieldArguments(environment, it, argument);
            Argument arg = new Argument(it.getName(), it.getValue());
            return GraphQLQueryFactory.getObjectFieldPredicate(environment, logical, it, arg, args);
        }).filter(Objects::nonNull).forEach(predicates::add);
        return GraphQLQueryFactory.getCompoundPredicate(predicates, logical);
    }

    protected static SearchParameters.FilterCriteria getObjectFieldPredicate(DataFetchingEnvironment environment, Logical logical, ObjectField objectField, Argument argument, Map<String, Object> arguments) {
        return GraphQLQueryFactory.getLogicalPredicate(objectField.getName(), objectField, GraphQLQueryFactory.argumentEnvironment(environment, arguments), argument);
    }

    protected static SearchParameters.FilterCriteria getArgumentsPredicate(DataFetchingEnvironment environment, Argument argument) {
        ArrayValue whereValue = (ArrayValue)GraphQLQueryFactory.getValue(argument, environment);
        if (whereValue.getValues().isEmpty()) {
            return new SearchParameters.FilterCriteria();
        }
        Logical logical = GraphQLQueryFactory.extractLogical(argument);
        ArrayList<SearchParameters.FilterCriteria> predicates = new ArrayList<SearchParameters.FilterCriteria>();
        List arguments = (List)environment.getArgument(logical.symbol());
        List values = whereValue.getValues().stream().map(ObjectValue.class::cast).collect(Collectors.toList());
        List tuples = IntStream.range(0, values.size()).mapToObj(i -> new AbstractMap.SimpleEntry(values.get(i), arguments.get(i))).collect(Collectors.toList());
        tuples.stream().flatMap(e -> ((ObjectValue)e.getKey()).getObjectFields().stream().filter(it -> Logical.symbols().contains(it.getName())).map(it -> {
            Map args = (Map)e.getValue();
            Argument arg = new Argument(it.getName(), it.getValue());
            if (it.getValue() instanceof ArrayValue) {
                return GraphQLQueryFactory.getArgumentsPredicate(GraphQLQueryFactory.argumentEnvironment(environment, args), arg);
            }
            return GraphQLQueryFactory.getArgumentPredicate(GraphQLQueryFactory.argumentEnvironment(environment, args), arg);
        })).forEach(predicates::add);
        tuples.stream().flatMap(e -> ((ObjectValue)e.getKey()).getObjectFields().stream().filter(it -> !Logical.symbols().contains(it.getName())).map(it -> {
            Map args = (Map)e.getValue();
            Argument arg = new Argument(it.getName(), it.getValue());
            return GraphQLQueryFactory.getObjectFieldPredicate(environment, logical, it, arg, args);
        })).filter(Objects::nonNull).forEach(predicates::add);
        return GraphQLQueryFactory.getCompoundPredicate(predicates, logical);
    }

    private static Map<String, Object> getFieldArguments(DataFetchingEnvironment environment, ObjectField field, Argument argument) {
        Map arguments;
        if (environment.getArgument(argument.getName()) instanceof Collection) {
            Collection list = (Collection)environment.getArgument(argument.getName());
            arguments = list.stream().filter(args -> args.get(field.getName()) != null).findFirst().orElse((Map)list.stream().findFirst().get());
        } else {
            arguments = (Map)environment.getArgument(argument.getName());
        }
        return arguments;
    }

    private static Logical extractLogical(Argument argument) {
        return Optional.of(argument.getName()).filter(it -> Logical.symbols().contains(it)).map(Logical::get).orElse(Logical.AND);
    }

    private static SearchParameters.FilterCriteria getLogicalPredicate(String fieldName, ObjectField objectField, DataFetchingEnvironment environment, Argument argument) {
        ObjectValue expressionValue = objectField.getValue() instanceof ObjectValue ? (ObjectValue)objectField.getValue() : new ObjectValue(Collections.singletonList(objectField));
        if (expressionValue.getChildren().isEmpty()) {
            return new SearchParameters.FilterCriteria();
        }
        Logical logical = GraphQLQueryFactory.extractLogical(argument);
        ArrayList<SearchParameters.FilterCriteria> predicates = new ArrayList<SearchParameters.FilterCriteria>();
        if (expressionValue.getObjectFields().stream().anyMatch(it -> !PredicateFilter.Criteria.symbols().contains(it.getName()))) {
            GraphQLFieldDefinition fieldDefinition = GraphQLQueryFactory.getFieldDefinition(environment.getGraphQLSchema(), (GraphQLFieldsContainer)GraphQLQueryFactory.getImplementingType(environment), new Field(fieldName));
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
            Argument arg = new Argument(logical.symbol(), (Value)expressionValue);
            if (Logical.symbols().contains(argument.getName())) {
                args.put(logical.symbol(), environment.getArgument(argument.getName()));
            } else {
                args.put(logical.symbol(), environment.getArgument(fieldName));
            }
            return GraphQLQueryFactory.getArgumentPredicate(GraphQLQueryFactory.wherePredicateEnvironment(environment, fieldDefinition, args), arg);
        }
        expressionValue.getObjectFields().stream().filter(it -> PredicateFilter.Criteria.symbols().contains(it.getName())).map(it -> GraphQLQueryFactory.getPredicateFilter(new ObjectField(fieldName, it.getValue()), GraphQLQueryFactory.argumentEnvironment(environment, argument), new Argument(it.getName(), it.getValue()))).sorted().map(it -> it.toFilterCriteria(environment)).filter(Objects::nonNull).forEach(predicates::add);
        return GraphQLQueryFactory.getCompoundPredicate(predicates, logical);
    }

    private static SearchParameters.FilterCriteria getCompoundPredicate(List<SearchParameters.FilterCriteria> predicates, Logical logical) {
        if (predicates.isEmpty()) {
            return new SearchParameters.FilterCriteria();
        }
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        SearchParameters.FilterCriteria criteria = new SearchParameters.FilterCriteria();
        switch (logical) {
            case OR: {
                criteria.setCondition(SearchParameters.FilterCriteria.Condition.OR);
                break;
            }
            case AND: {
                criteria.setCondition(SearchParameters.FilterCriteria.Condition.AND);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        criteria.setCriterion(predicates);
        return criteria;
    }

    private static PredicateFilter getPredicateFilter(ObjectField objectField, DataFetchingEnvironment environment, Argument argument) {
        PredicateFilter.Criteria option = PredicateFilter.Criteria.get(argument.getName());
        LinkedHashMap<String, Object> valueArguments = new LinkedHashMap<String, Object>();
        valueArguments.put(objectField.getName(), environment.getArgument(argument.getName()));
        DataFetchingEnvironment dataFetchingEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(valueArguments).build();
        Argument dataFetchingArgument = new Argument(objectField.getName(), argument.getValue());
        Object filterValue = GraphQLQueryFactory.convertValue(dataFetchingEnvironment, dataFetchingArgument, argument.getValue());
        return new PredicateFilter(objectField.getName(), filterValue, option);
    }

    protected static DataFetchingEnvironment argumentEnvironment(DataFetchingEnvironment environment, Map<String, Object> arguments) {
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(arguments).build();
    }

    protected static DataFetchingEnvironment argumentEnvironment(DataFetchingEnvironment environment, Argument argument) {
        Map arguments = (Map)environment.getArgument(argument.getName());
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(arguments).build();
    }

    protected static DataFetchingEnvironment wherePredicateEnvironment(DataFetchingEnvironment environment, GraphQLFieldDefinition fieldDefinition, Map<String, Object> arguments) {
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(arguments).fieldDefinition(fieldDefinition).fieldType(fieldDefinition.getType()).build();
    }

    protected static Object convertValue(DataFetchingEnvironment environment, Argument argument, Value value) {
        if (value instanceof NullValue) {
            return value;
        }
        if (value instanceof StringValue) {
            Object convertedValue = environment.getArgument(argument.getName());
            if (convertedValue != null) {
                return convertedValue;
            }
            return ((StringValue)value).getValue();
        }
        if (value instanceof VariableReference) {
            return environment.getVariables().get(((VariableReference)value).getName());
        }
        if (value instanceof ArrayValue) {
            Collection arrayValue = (Collection)environment.getArgument(argument.getName());
            if (arrayValue != null) {
                if (arrayValue.stream().allMatch(it -> it instanceof Collection)) {
                    return arrayValue.iterator().next();
                }
                if (arrayValue.stream().anyMatch(it -> it instanceof Value)) {
                    return arrayValue.stream().map(it -> GraphQLQueryFactory.convertValue(environment, argument, (Value)it)).collect(Collectors.toList());
                }
                return arrayValue;
            }
            return ((ArrayValue)value).getValues().stream().map(it -> GraphQLQueryFactory.convertValue(environment, argument, it)).collect(Collectors.toList());
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof ObjectValue) {
            Map values = (Map)environment.getArgument(argument.getName());
            return values;
        }
        return value;
    }

    private static GraphQLImplementingType getImplementingType(DataFetchingEnvironment environment) {
        GraphQLOutputType outputType = environment.getFieldType();
        if (outputType instanceof GraphQLList) {
            outputType = ((GraphQLList)outputType).getWrappedType();
        }
        if (outputType instanceof GraphQLImplementingType) {
            return (GraphQLImplementingType)outputType;
        }
        return null;
    }

    protected static GraphQLFieldDefinition getFieldDefinition(GraphQLSchema schema, GraphQLFieldsContainer parentType, Field field) {
        if (schema.getQueryType() == parentType) {
            if (field.getName().equals(Introspection.SchemaMetaFieldDef.getName())) {
                return Introspection.SchemaMetaFieldDef;
            }
            if (field.getName().equals(Introspection.TypeMetaFieldDef.getName())) {
                return Introspection.TypeMetaFieldDef;
            }
        }
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
            return Introspection.TypeNameMetaFieldDef;
        }
        GraphQLFieldDefinition fieldDefinition = parentType.getFieldDefinition(field.getName());
        if (fieldDefinition != null) {
            return fieldDefinition;
        }
        throw new GraphQLException("unknown field " + field.getName());
    }

    public GraphQLImplementingType getImplementingType() {
        return this.implementingType;
    }

    public static IDiscoveryServiceStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IDiscoveryServiceStage,
    ITypeRegistryStage,
    IEntityTypeNameStage,
    IEntityObjectTypeStage,
    IBuildStage {
        private AtlasDiscoveryService discoveryService;
        private AtlasTypeRegistry typeRegistry;
        private String entityTypeName;
        private GraphQLImplementingType implementingType;

        private Builder() {
        }

        @Override
        public ITypeRegistryStage withDiscoveryService(AtlasDiscoveryService discoveryService) {
            this.discoveryService = discoveryService;
            return this;
        }

        @Override
        public IEntityTypeNameStage withTypeRegistry(AtlasTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
            return this;
        }

        @Override
        public IEntityObjectTypeStage withEntityTypeName(String entityTypeName) {
            this.entityTypeName = entityTypeName;
            return this;
        }

        @Override
        public IBuildStage withImplementingType(GraphQLImplementingType implementingType) {
            this.implementingType = implementingType;
            return this;
        }

        @Override
        public GraphQLQueryFactory build() {
            return new GraphQLQueryFactory(this);
        }
    }

    public static interface IBuildStage {
        public GraphQLQueryFactory build();
    }

    public static interface IEntityObjectTypeStage {
        public IBuildStage withImplementingType(GraphQLImplementingType var1);
    }

    public static interface IEntityTypeNameStage {
        public IEntityObjectTypeStage withEntityTypeName(String var1);
    }

    public static interface ITypeRegistryStage {
        public IEntityTypeNameStage withTypeRegistry(AtlasTypeRegistry var1);
    }

    public static interface IDiscoveryServiceStage {
        public ITypeRegistryStage withDiscoveryService(AtlasDiscoveryService var1);
    }
}

