/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema;

import com.google.common.collect.EnumHashBiMap;
import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import io.confluent.catalog.util.QualifiedNameGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.model.discovery.SearchParameters;

class PredicateFilter
implements Comparable<PredicateFilter> {
    private final String field;
    private final Object typedValue;
    private final Criteria criteria;

    public PredicateFilter(String field, Object value, Criteria criteria) {
        this.field = field;
        this.typedValue = value;
        this.criteria = criteria;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.typedValue;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    public int compareTo(PredicateFilter o) {
        return this.getField().compareTo(o.getField());
    }

    public SearchParameters.FilterCriteria toFilterCriteria(DataFetchingEnvironment environment) {
        SearchParameters.FilterCriteria attrCriteria = new SearchParameters.FilterCriteria();
        attrCriteria.setAttributeName(this.field);
        switch (this.criteria) {
            case LT: {
                attrCriteria.setOperator(SearchParameters.Operator.LT);
                break;
            }
            case GT: {
                attrCriteria.setOperator(SearchParameters.Operator.GT);
                break;
            }
            case LTE: {
                attrCriteria.setOperator(SearchParameters.Operator.LTE);
                break;
            }
            case GTE: {
                attrCriteria.setOperator(SearchParameters.Operator.GTE);
                break;
            }
            case EQ: {
                attrCriteria.setOperator(SearchParameters.Operator.EQ);
                break;
            }
            case STARTS_WITH: {
                attrCriteria.setOperator(SearchParameters.Operator.STARTS_WITH);
                break;
            }
            case IN: {
                attrCriteria.setOperator(SearchParameters.Operator.IN);
                break;
            }
            case BETWEEN: {
                attrCriteria.setOperator(SearchParameters.Operator.TIME_RANGE);
                Map map = (Map)this.typedValue;
                Date start = (Date)map.get("start");
                Date end = (Date)map.get("end");
                attrCriteria.setAttributeValue(start.getTime() + "," + end.getTime());
                break;
            }
            case SINCE: {
                attrCriteria.setOperator(SearchParameters.Operator.TIME_RANGE);
                attrCriteria.setAttributeValue(this.typedValue.toString().toUpperCase(Locale.ROOT));
            }
        }
        if (attrCriteria.getAttributeValue() == null) {
            String value = this.getValueAsString();
            if ("qualifiedName".equals(this.field)) {
                GraphQLContext context = environment.getGraphQlContext();
                String tenant = (String)context.get((Object)"tenant");
                value = QualifiedNameGenerator.ensurePrefix(tenant, QualifiedNameGenerator.NAME_DELIMITER, value);
            }
            attrCriteria.setAttributeValue(value);
        }
        return attrCriteria;
    }

    private String getValueAsString() {
        return PredicateFilter.getValueAsString(this.typedValue);
    }

    private static String getValueAsString(Object typedValue) {
        if (typedValue instanceof String) {
            return (String)typedValue;
        }
        if (typedValue instanceof Number) {
            return typedValue.toString();
        }
        if (typedValue instanceof Date) {
            return String.valueOf(((Date)typedValue).getTime());
        }
        if (typedValue instanceof Collection) {
            return ((Collection)typedValue).stream().map(PredicateFilter::getValueAsString).collect(Collectors.joining(" "));
        }
        return typedValue.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateFilter that = (PredicateFilter)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.typedValue, that.typedValue) && this.criteria == that.criteria;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.typedValue, this.criteria});
    }

    public static enum Criteria {
        LT("_lt"),
        GT("_gt"),
        LTE("_lte"),
        GTE("_gte"),
        EQ("_eq"),
        STARTS_WITH("_starts_with"),
        IN("_in"),
        BETWEEN("_between"),
        SINCE("_since");

        private static final EnumHashBiMap<Criteria, String> lookup;
        private final String symbol;

        private Criteria(String symbol) {
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        public static Criteria get(String symbol) {
            return (Criteria)((Object)lookup.inverse().get((Object)symbol));
        }

        public static Set<String> symbols() {
            return lookup.inverse().keySet();
        }

        public String toString() {
            return this.symbol();
        }

        static {
            lookup = EnumHashBiMap.create(Criteria.class);
            for (Criteria type : Criteria.values()) {
                lookup.put((Enum)type, (Object)type.symbol());
            }
        }
    }
}

