/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema.timeout;

import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import io.confluent.catalog.web.graphql.schema.timeout.MaxQueryInstrumentationState;
import io.confluent.catalog.web.graphql.schema.timeout.TimeoutDataFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxQueryDurationInstrumentation
extends SimpleInstrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(MaxQueryDurationInstrumentation.class);
    private long maxDuration;

    public MaxQueryDurationInstrumentation(long maxDuration) {
        LOG.info("Loaded max query duration instrumentation.");
        this.maxDuration = maxDuration;
    }

    public InstrumentationState createState() {
        return new MaxQueryInstrumentationState();
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        MaxQueryInstrumentationState state = (MaxQueryInstrumentationState)parameters.getInstrumentationState();
        if (state.getTime() > this.maxDuration) {
            LOG.warn("Max duration: {}, current time: {}", (Object)this.maxDuration, (Object)state.getTime());
            return new TimeoutDataFetcher(this.maxDuration);
        }
        return super.instrumentDataFetcher(dataFetcher, parameters);
    }
}

