/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema.timeout;

import graphql.schema.AsyncDataFetcher;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.confluent.catalog.web.graphql.schema.timeout.QueryTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimeoutAsyncDataFetcher<T>
extends AsyncDataFetcher<T> {
    private static final ScheduledExecutorService TIMEOUT_SCHEDULER = Executors.newScheduledThreadPool(1);
    private final long maxDuration;

    public static <T> AsyncDataFetcher<T> timeoutAsync(DataFetcher<T> wrappedDataFetcher, long maxDuration) {
        return new TimeoutAsyncDataFetcher<T>(wrappedDataFetcher, maxDuration);
    }

    public static <T> AsyncDataFetcher<T> timeoutAsync(DataFetcher<T> wrappedDataFetcher, Executor executor, long maxDuration) {
        return new TimeoutAsyncDataFetcher<T>(wrappedDataFetcher, executor, maxDuration);
    }

    public TimeoutAsyncDataFetcher(DataFetcher<T> wrappedDataFetcher, long maxDuration) {
        super(wrappedDataFetcher);
        this.maxDuration = maxDuration;
    }

    public TimeoutAsyncDataFetcher(DataFetcher<T> wrappedDataFetcher, Executor executor, long maxDuration) {
        super(wrappedDataFetcher, executor);
        this.maxDuration = maxDuration;
    }

    public CompletableFuture<T> get(DataFetchingEnvironment environment) {
        CompletableFuture fetchingFuture = super.get(environment);
        CompletableFuture timeoutFuture = new CompletableFuture();
        ScheduledFuture<?> scheduledTimeout = TIMEOUT_SCHEDULER.schedule(() -> timeoutFuture.completeExceptionally(new QueryTimeoutException("Maximum query duration of " + this.maxDuration + " ms exceeded.")), this.maxDuration, TimeUnit.MILLISECONDS);
        fetchingFuture.whenComplete((res, ex) -> scheduledTimeout.cancel(false));
        return CompletableFuture.anyOf(fetchingFuture, timeoutFuture);
    }
}

