/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema.util;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicApi;
import graphql.execution.Async;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldValueInfo;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.ResultPath;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.util.FpKit;
import io.confluent.catalog.web.graphql.schema.util.BidirectionalContext;
import java.util.ArrayList;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;

@PublicApi
public class AsyncBidirectionalContextExecutionStrategy
extends AsyncExecutionStrategy {
    public AsyncBidirectionalContextExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        OptionalInt size = FpKit.toSize(iterableValues);
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, () -> executionStepInfo, iterableValues);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext completeListCtx = SimpleInstrumentationContext.nonNullCtx((InstrumentationContext)instrumentation.beginFieldListComplete(instrumentationParams, executionContext.getInstrumentationState()));
        ArrayList<FieldValueInfo> fieldValueInfos = new ArrayList<FieldValueInfo>(size.orElse(1));
        int index = 0;
        for (Object item2 : iterableValues) {
            ResultPath indexedPath = parameters.getPath().segment(index);
            ExecutionStepInfo stepInfoForListElement = this.executionStepInfoFactory.newExecutionStepInfoForListElement(executionStepInfo, index);
            NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, stepInfoForListElement);
            int finalIndex = index;
            FetchedValue value = this.unboxPossibleDataFetcherResult(executionContext, parameters, item2);
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(stepInfoForListElement).nonNullFieldValidator(nonNullableFieldValidator).listSize(size.orElse(-1)).localContext(value.getLocalContext()).currentListIndex(finalIndex).path(indexedPath).source(value.getFetchedValue()));
            FieldValueInfo fieldValueInfo = this.completeValue(executionContext, newParameters);
            Object ctx = value.getLocalContext();
            if (ctx instanceof BidirectionalContext) {
                BidirectionalContext localContext = (BidirectionalContext)ctx;
                if (localContext.isSkip()) {
                    localContext.setSkip(false);
                } else {
                    fieldValueInfos.add(fieldValueInfo);
                }
            } else {
                fieldValueInfos.add(fieldValueInfo);
            }
            ++index;
        }
        CompletableFuture resultsFuture = Async.each(fieldValueInfos, (item, i) -> item.getFieldValue());
        CompletableFuture overallResult = new CompletableFuture();
        completeListCtx.onDispatched(overallResult);
        resultsFuture.whenComplete((results, exception) -> {
            if (exception != null) {
                ExecutionResult executionResult = this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                completeListCtx.onCompleted((Object)executionResult, exception);
                return;
            }
            ArrayList<Object> completedResults = new ArrayList<Object>(results.size());
            for (ExecutionResult completedValue : results) {
                completedResults.add(completedValue.getData());
            }
            ExecutionResultImpl executionResult = new ExecutionResultImpl(completedResults, executionContext.getErrors());
            overallResult.complete(executionResult);
        });
        overallResult.whenComplete((arg_0, arg_1) -> ((InstrumentationContext)completeListCtx).onCompleted(arg_0, arg_1));
        return FieldValueInfo.newFieldValueInfo((FieldValueInfo.CompleteValueType)FieldValueInfo.CompleteValueType.LIST).fieldValue(overallResult).fieldValueInfos(fieldValueInfos).build();
    }
}

