/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema.util;

import graphql.language.Argument;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.IntValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.parser.Parser;
import io.confluent.catalog.web.graphql.schema.util.LimitOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasConfiguration;

public class QueryParser {
    Map<String, LimitOffset> limitsOffsets;
    private boolean isIntrospectionQuery = false;
    private boolean isSingleQuery = false;
    private String query;
    Parser parser;
    Document doc;

    public QueryParser(String query) {
        this.query = query;
        this.parser = new Parser();
        this.limitsOffsets = new HashMap<String, LimitOffset>();
        this.parse();
    }

    private void parse() {
        if (this.query.isEmpty()) {
            this.isIntrospectionQuery = true;
            return;
        }
        this.doc = this.parser.parseDocument(this.query);
        OperationDefinition operationDefinition = (OperationDefinition)this.doc.getDefinitions().get(0);
        if (operationDefinition.getName() != null && operationDefinition.getName().equals("IntrospectionQuery")) {
            this.isIntrospectionQuery = true;
            return;
        }
        List selections = operationDefinition.getSelectionSet().getSelections();
        if (selections.size() == 1) {
            this.isSingleQuery = true;
            for (Selection selection : selections) {
                Field field = (Field)selection;
                String name = field.getName();
                String alias = field.getAlias() == null ? name : field.getAlias();
                int limit = AtlasConfiguration.SEARCH_DEFAULT_LIMIT.getInt();
                int offset = 0;
                for (Argument arg : field.getArguments()) {
                    if (arg.getName().equalsIgnoreCase("limit")) {
                        limit = ((IntValue)arg.getValue()).getValue().intValueExact();
                        continue;
                    }
                    if (!arg.getName().equalsIgnoreCase("offset")) continue;
                    offset = ((IntValue)arg.getValue()).getValue().intValueExact();
                }
                LimitOffset limitAndOffset = new LimitOffset(limit, offset);
                this.limitsOffsets.put(String.format("%s:%s", name, alias), limitAndOffset);
            }
        }
    }

    public boolean isIntrospectionQuery() {
        return this.isIntrospectionQuery;
    }

    public boolean isSingleQuery() {
        return this.isSingleQuery;
    }

    public Map<String, LimitOffset> getLimitOffsets() {
        return this.limitsOffsets;
    }
}

