/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.confluent.catalog.web.rest.entities.SearchParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchResult
implements Serializable {
    private SearchParams searchParameters;
    private List<String> types;
    private List<AtlasEntityHeader> entities;
    private Map<String, AtlasEntityHeader> referredEntities;

    public SearchResult() {
    }

    public SearchResult(SearchParams searchParameters) {
        if (searchParameters != null) {
            this.setSearchParameters(searchParameters);
            this.setEntities(null);
            this.setReferredEntities(null);
        }
    }

    public SearchParams getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(SearchParams searchParameters) {
        this.searchParameters = searchParameters;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public List<AtlasEntityHeader> getEntities() {
        return this.entities;
    }

    public void setEntities(List<AtlasEntityHeader> entities) {
        this.entities = entities;
    }

    public Map<String, AtlasEntityHeader> getReferredEntities() {
        return this.referredEntities;
    }

    public void setReferredEntities(Map<String, AtlasEntityHeader> referredEntities) {
        this.referredEntities = referredEntities;
    }

    public int hashCode() {
        return Objects.hash(this.searchParameters, this.entities, this.referredEntities);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return Objects.equals(this.searchParameters, that.searchParameters) && Objects.equals(this.entities, that.entities) && Objects.equals(this.referredEntities, that.referredEntities);
    }

    public void addEntity(AtlasEntityHeader newEntity) {
        if (this.entities == null) {
            this.entities = new ArrayList<AtlasEntityHeader>();
        }
        if (this.entities.isEmpty()) {
            this.entities.add(newEntity);
        } else {
            this.removeEntity(newEntity);
            this.entities.add(newEntity);
        }
    }

    public void removeEntity(AtlasEntityHeader entity) {
        List<AtlasEntityHeader> entities = this.entities;
        if (CollectionUtils.isNotEmpty(entities)) {
            Iterator<AtlasEntityHeader> iter = entities.iterator();
            while (iter.hasNext()) {
                AtlasEntityHeader currEntity = iter.next();
                if (!StringUtils.equals((String)currEntity.getGuid(), (String)entity.getGuid())) continue;
                iter.remove();
            }
        }
    }

    public String toString() {
        return "SearchResult{searchParameters='" + this.searchParameters + '\'' + ", types=" + this.types + ", entities=" + this.entities + ", referredEntities=" + this.referredEntities + '}';
    }
}

