/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.exceptions;

import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.RestConstraintViolationException;

public class RestInvalidTagOperationException
extends RestConstraintViolationException {
    public static final int ERROR_CODE = 42251;
    public static final String INVALID_TAG_OPERATION_MESSAGE_FORMAT = "The operation for tag: %s is invalid because the schema has embedded tags.";

    public RestInvalidTagOperationException(String tag) {
        super(String.format(INVALID_TAG_OPERATION_MESSAGE_FORMAT, tag), 42251);
    }

    public static ErrorMessage toErrorMessage(String tagName) {
        return new ErrorMessage(42251, String.format(INVALID_TAG_OPERATION_MESSAGE_FORMAT, tagName));
    }
}

