/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.resources;

import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.storage.MetadataRegistry;
import io.confluent.catalog.util.RbacConstants;
import io.confluent.catalog.web.rest.resources.SchemaRegistryResource;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="catalog/v1")
@Singleton
@Service
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"})
public class CatalogResource
extends SchemaRegistryResource {
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
    private final MetadataRegistry registry;
    private static final Logger LOG = LoggerFactory.getLogger(CatalogResource.class);
    private static final String CORE_PATH = "catalog/v1";
    private static final String REPUBLISH_PATH = "/entity-notifications-snapshot";

    @Inject
    public CatalogResource(SchemaRegistry schemaRegistry, MetadataRegistry registry) {
        super(schemaRegistry);
        this.registry = registry;
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getRequestRbacPermissionEntity(ContainerRequestContext requestContext) {
        String cluster = this.getSchemaRegistry().tenant();
        UriInfo uri = requestContext.getUriInfo();
        if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)CORE_PATH) && StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)REPUBLISH_PATH)) {
            List<SchemaRegistryResource.RbacPermissionAction> permissionList = Arrays.asList(new SchemaRegistryResource.RbacPermissionAction("EnvironmentStreamCatalog", RbacConstants.RbacResourceTypes.EnvStreamCatalog, RbacConstants.RbacOperations.PublishNotifications));
            return new SchemaRegistryResource.RbacPermissionEntity(permissionList, cluster);
        }
        return null;
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getResponseRbacPermissionEntity(ContainerRequestContext requestContext, ContainerResponseContext responseContext, String resourceMethod) {
        return null;
    }

    @GET
    @Path(value="/ready")
    @Hidden
    public boolean ready() {
        SchemaAtlasHook hook = (SchemaAtlasHook)this.getSchemaRegistry().properties().get("hook");
        return hook.ready();
    }

    @GET
    @Path(value="/synced")
    @Hidden
    public boolean synced() {
        SchemaAtlasHook hook = (SchemaAtlasHook)this.getSchemaRegistry().properties().get("hook");
        return hook.synced();
    }

    @POST
    @Path(value="/entity-notifications-snapshot")
    @DocumentedName(value="notifyEntityEvents")
    @Operation(summary="Republish all entities events.", description="Republish all entities events.", responses={@ApiResponse(responseCode="204", description="The notification was successful."), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public void republishAllEntities(@Context HttpHeaders headers, @Suspended AsyncResponse asyncResponse) {
        String tenant = headers.getHeaderString("tenant");
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        headerProperties.put("tenant", tenant);
        try {
            this.registry.republishOrForward("Snapshot_" + tenant, tenant, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while snapshot", (Throwable)e);
        }
    }
}

