/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.catalog.storage.MetadataRegistry;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.web.rest.resources.EntityResource;
import io.confluent.catalog.web.rest.resources.SchemaRegistryResource;
import io.confluent.catalog.web.util.Servlets;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="catalog/v1/entity")
@Singleton
@Service
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"})
public class ExtendedEntityResource
extends SchemaRegistryResource {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedEntityResource.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final MetadataRegistry registry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    @Inject
    public ExtendedEntityResource(SchemaRegistry schemaRegistry, MetadataRegistry registry) {
        super(schemaRegistry);
        this.registry = registry;
    }

    @POST
    @DocumentedName(value="createOrUpdateEntity")
    public void createOrUpdate(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasBaseException {
        LOG.debug("Create entity: {}", (Object)entity);
        if (entity == null || entity.getEntity() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entity to update"});
        }
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        ExtendedEntityResource.ensureEntityCreate(entity.getEntity(), tenant);
        if (entity.getReferredEntities() != null) {
            for (AtlasEntity referredEntity : entity.getReferredEntities().values()) {
                ExtendedEntityResource.ensureEntityCreate(referredEntity, tenant);
            }
        }
        try {
            EntityMutationResponse ret = this.registry.createOrUpdateEntityOrForward(tenant, entity, headerProperties);
            asyncResponse.resume((Object)ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating entity", (Throwable)e);
        }
    }

    protected static void ensureEntityCreate(AtlasEntity entity, String tenant) throws AtlasBaseException {
        EntityResource.ensureEntityUpdate(entity, tenant);
        String name = (String)entity.getAttribute("name");
        if (name != null) {
            entity.setAttribute("nameLower", (Object)name.toLowerCase(Locale.ROOT));
        }
    }

    @DELETE
    @Path(value="/type/{typeName}/name/{qualifiedName}")
    @DocumentedName(value="deleteEntityByTypeAndName")
    public void deleteByUniqueAttributes(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @PathParam(value="typeName") String typeName, @PathParam(value="qualifiedName") String qualifiedName, @QueryParam(value="purge") boolean purge) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        Servlets.validateQueryParamLength("qualifiedName", qualifiedName);
        LOG.debug("Delete entity: typeName {}, qualifiedName {}", (Object)typeName, (Object)qualifiedName);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        try {
            this.registry.deleteOrPurgeEntityOrForward(tenant, typeName, entityQualifiedName, purge, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting tag", (Throwable)e);
        }
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getRequestRbacPermissionEntity(ContainerRequestContext requestContext) {
        return null;
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getResponseRbacPermissionEntity(ContainerRequestContext requestContext, ContainerResponseContext responseContext, String resourceMethod) {
        return null;
    }
}

