/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.resources;

import io.confluent.catalog.util.RbacConstants;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;

public abstract class SchemaRegistryResource {
    private SchemaRegistry schemaRegistry;

    public SchemaRegistryResource(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public abstract RbacPermissionEntity getRequestRbacPermissionEntity(ContainerRequestContext var1) throws Exception;

    public abstract RbacPermissionEntity getResponseRbacPermissionEntity(ContainerRequestContext var1, ContainerResponseContext var2, String var3) throws Exception;

    public SchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    protected static RbacConstants.RbacOperations getRbacOperation(String httpMethod) {
        switch (httpMethod.toUpperCase()) {
            case "GET": {
                return RbacConstants.RbacOperations.Read;
            }
            case "DELETE": {
                return RbacConstants.RbacOperations.Delete;
            }
            case "PUT": 
            case "POST": {
                return RbacConstants.RbacOperations.Write;
            }
        }
        throw new RuntimeException("Invalid http Method for RBAC operation mapping");
    }

    public static class RbacPermissionAction {
        public String resourceName;
        public RbacConstants.RbacResourceTypes resourceType;
        public RbacConstants.RbacOperations operation;

        public RbacPermissionAction(String resourceName, RbacConstants.RbacResourceTypes resourceType, RbacConstants.RbacOperations operation) {
            this.resourceName = resourceName;
            this.resourceType = resourceType;
            this.operation = operation;
        }
    }

    public static class RbacPermissionEntity {
        public List<RbacPermissionAction> resourceList;
        public String cluster;

        public RbacPermissionEntity(List<RbacPermissionAction> resourceList, String cluster) {
            this.resourceList = resourceList;
            this.cluster = cluster;
        }
    }
}

