/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.resources;

import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.client.autthorizer.CatalogAuthorizerClient;
import io.confluent.catalog.metrics.TenantMetricsService;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.util.RbacConstants;
import io.confluent.catalog.web.filters.CatalogRbacAuthorizationFilter;
import io.confluent.catalog.web.filters.CatalogRequestContextHolder;
import io.confluent.catalog.web.filters.CatalogRequestFilter;
import io.confluent.catalog.web.rest.entities.SearchParams;
import io.confluent.catalog.web.rest.entities.SearchResult;
import io.confluent.catalog.web.rest.entities.TimeRangeType;
import io.confluent.catalog.web.rest.resources.SchemaRegistryResource;
import io.confluent.catalog.web.util.Servlets;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.SortOrder;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizerFactory;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="catalog/v1/search")
@Singleton
@Service
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"})
public class SearchResource
extends SchemaRegistryResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private final AtlasDiscoveryService discoveryService;
    private final int maxFullTextQueryLength;
    private final int maxDslQueryLength;
    private final TenantMetricsService tenantMetricsService;
    private CatalogAuthorizerClient authorizerRestClient;
    private CatalogRbacAuthorizationFilter catalogRbacAuthorizationFilter;
    private DataCatalogConfig dataCatalogConfig;

    @Inject
    public SearchResource(SchemaRegistry schemaRegistry, AtlasDiscoveryService discoveryService, Configuration config, TenantMetricsService tenantMetricsService, AtlasEntityStore entityStore) {
        block9: {
            super(schemaRegistry);
            this.authorizerRestClient = null;
            this.catalogRbacAuthorizationFilter = null;
            try {
                this.dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
                this.discoveryService = discoveryService;
                this.maxFullTextQueryLength = config.getInt("atlas.graph.fulltext-max-query-str-length", 4096);
                this.maxDslQueryLength = config.getInt("atlas.graph.dsl-max-query-str-length", 4096);
                this.tenantMetricsService = tenantMetricsService;
                if (!this.dataCatalogConfig.isCatalogRbacEnabled()) break block9;
                String authorizerClassName = this.dataCatalogConfig.getRbacAuthorizerClassName();
                if (authorizerClassName.isEmpty()) {
                    throw new RestConfigException("Authorizer class name not set");
                }
                Class<?> authorizerClientObject = Class.forName(authorizerClassName);
                this.authorizerRestClient = (CatalogAuthorizerClient)authorizerClientObject.newInstance();
                this.authorizerRestClient.init(schemaRegistry);
                try {
                    this.catalogRbacAuthorizationFilter = (CatalogRbacAuthorizationFilter)AtlasAuthorizerFactory.getAtlasAuthorizer();
                }
                catch (AtlasAuthorizationException e) {
                    LOG.error("Unable to enable RBAC for CatalogRbacAuthorizationFilter", (Throwable)e);
                }
                if (this.catalogRbacAuthorizationFilter != null) {
                    this.catalogRbacAuthorizationFilter.setRbacEnabled(true);
                    this.catalogRbacAuthorizationFilter.setAuthorizerRestClient(this.authorizerRestClient);
                    this.catalogRbacAuthorizationFilter.setSchemaRegistry((KafkaSchemaRegistry)schemaRegistry);
                    this.catalogRbacAuthorizationFilter.setEntityStore(entityStore);
                }
            }
            catch (RestConfigException e) {
                throw new IllegalArgumentException("Could not instantiate SearchResource", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @GET
    @Path(value="/basic")
    @PerformanceMetric(value="catalog.search.basic")
    @Operation(summary="Retrieve data for the specified fulltext query.", description="Retrieve data for the specified fulltext query.", responses={@ApiResponse(responseCode="200", description="On successful fulltext query with some results, might return an empty list if execution succeeded without any results", content={@Content(schema=@Schema(implementation=SearchResult.class))}), @ApiResponse(responseCode="400", description="Invalid fulltext or query parameters"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="searchCatalogUsingBasicQuery")
    public SearchResult searchUsingBasic(@Parameter(description="The full-text query") @QueryParam(value="query") String query, @Parameter(description="Limit the result to only entities of specified types") @QueryParam(value="type") List<String> types, @QueryParam(value="types") String oldTypes, @Parameter(description="One of more additional attributes to return in the response") @QueryParam(value="attr") List<String> attrs, @QueryParam(value="attrs") String oldAttrs, @Parameter(description="Limit the result to only entities with the given tag") @QueryParam(value="tag") List<String> tags, @Parameter(description="The type of time range search, default is CUSTOM") @QueryParam(value="timeRangeType") TimeRangeType timeRangeType, @Parameter(description="The attribute for a time range search") @QueryParam(value="timeRangeAttr") String timeRangeAttr, @Parameter(description="The start for a custom time range search in ms since the epoch") @QueryParam(value="timeRangeStart") long timeRangeStart, @Parameter(description="The end for a custom time range search in ms since the epoch") @QueryParam(value="timeRangeEnd") long timeRangeEnd, @Parameter(description="An attribute to sort by") @DefaultValue(value="qualifiedName") @QueryParam(value="sortBy") String sortByAttribute, @Parameter(description="Sort order, either ASCENDING (default) or DESCENDING") @DefaultValue(value="ASCENDING") @QueryParam(value="sortOrder") SortOrder sortOrder, @Parameter(description="Whether to include deleted entities") @QueryParam(value="deleted") boolean includeDeleted, @Parameter(description="Limit the result set to only include the specified number of entries") @QueryParam(value="limit") int limit, @Parameter(description="Start offset of the result set (useful for pagination)") @QueryParam(value="offset") int offset) throws AtlasBaseException {
        List<String> allTypes;
        Servlets.validateQueryParamLength("query", query);
        Servlets.validateQueryParamLength("types", oldTypes);
        Servlets.validateQueryParamLength("attrs", oldAttrs);
        Servlets.validateQueryParamLength("sortBy", sortByAttribute);
        if (StringUtils.isNotEmpty((CharSequence)query) && query.length() > this.maxFullTextQueryLength) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_QUERY_LENGTH, new String[]{"atlas.graph.fulltext-max-query-str-length"});
        }
        List<String> allAttrs = oldAttrs != null ? Arrays.asList(oldAttrs.split(",")) : attrs;
        List<String> list = allTypes = oldTypes != null ? Arrays.asList(oldTypes.split(",")) : types;
        if (allTypes.isEmpty()) {
            allTypes = Collections.singletonList("cf_entity");
        }
        LOG.info("Search basic: query {}, types {}, attrs {}, tag {}, sortBy {}, sortOrder {}, deleted {}, limit {}, offset {}", new Object[]{query, allTypes, allAttrs, tags, sortByAttribute, sortOrder, includeDeleted, limit, offset});
        ArrayList<AtlasEntityHeader> entities = new ArrayList<AtlasEntityHeader>();
        HashMap<String, AtlasEntityHeader> referredEntities = new HashMap<String, AtlasEntityHeader>();
        AtlasSearchResult result = this.searchWithParameters(allTypes, tags, query, allAttrs, timeRangeType, timeRangeAttr, timeRangeStart, timeRangeEnd, sortByAttribute, sortOrder, includeDeleted, limit, offset);
        if (result.getEntities() != null) {
            entities.addAll(result.getEntities());
        }
        if (result.getReferredEntities() != null) {
            referredEntities.putAll(result.getReferredEntities());
        }
        SearchParams sp = new SearchParams();
        sp.setIncludeDeleted(includeDeleted);
        sp.setLimit(limit);
        sp.setOffset(offset);
        SearchResult sr = new SearchResult(sp);
        sr.setTypes(allTypes);
        sr.setEntities(entities);
        if (referredEntities.size() > 0) {
            sr.setReferredEntities(referredEntities);
        }
        LOG.info("Search basic result: entities {}, referredEntities {}", (Object)entities.size(), (Object)referredEntities.size());
        return sr;
    }

    private AtlasSearchResult searchWithParameters(List<String> types, List<String> tags, String query, List<String> attrs, TimeRangeType timeRangeType, String timeRangeAttr, long timeRangeStart, long timeRangeEnd, String sortByAttribute, SortOrder sortOrder, boolean includeDeleted, int limit, int offset) throws AtlasBaseException {
        if (!tags.isEmpty()) {
            tags = tags.stream().map(tag -> QualifiedNameGenerator.ensureTypeTenantPrefix(this.getSchemaRegistry().tenant(), tag)).collect(Collectors.toList());
        }
        SearchParameters searchParams = new SearchParameters();
        HashSet<String> attributes = new HashSet<String>(attrs);
        attributes.add("tenant");
        attributes.add("name");
        attributes.add("nameLower");
        attributes.add("qualifiedName");
        if (types.stream().allMatch(s -> s.startsWith("sr_"))) {
            attributes.add("context");
            attributes.add("id");
        }
        searchParams.setAttributes(attributes);
        ArrayList<SearchParameters.FilterCriteria> criteria = new ArrayList<SearchParameters.FilterCriteria>();
        if (query != null && !query.isEmpty()) {
            SearchParameters.FilterCriteria attrFilter = new SearchParameters.FilterCriteria();
            attrFilter.setAttributeName("nameLower");
            attrFilter.setOperator(SearchParameters.Operator.STARTS_WITH);
            attrFilter.setAttributeValue(query.toLowerCase(Locale.ROOT));
            criteria.add(attrFilter);
        }
        SearchParameters.FilterCriteria tenantFilter = new SearchParameters.FilterCriteria();
        tenantFilter.setAttributeName("tenant");
        tenantFilter.setOperator(SearchParameters.Operator.EQ);
        tenantFilter.setAttributeValue(this.getSchemaRegistry().tenant());
        criteria.add(tenantFilter);
        SearchParameters.FilterCriteria timeRangeFilter = this.createTimeRangeFilter(timeRangeType, timeRangeAttr, timeRangeStart, timeRangeEnd);
        if (timeRangeFilter != null) {
            criteria.add(timeRangeFilter);
        }
        ArrayList<SearchParameters.FilterCriteria> deprecatedTimeCriteria = new ArrayList<SearchParameters.FilterCriteria>();
        SearchParameters.FilterCriteria deprecatedTimeFilterZero = new SearchParameters.FilterCriteria();
        deprecatedTimeFilterZero.setAttributeName("deprecatedTime");
        deprecatedTimeFilterZero.setOperator(SearchParameters.Operator.EQ);
        deprecatedTimeFilterZero.setAttributeValue("0");
        deprecatedTimeCriteria.add(deprecatedTimeFilterZero);
        SearchParameters.FilterCriteria deprecatedTimeFilterNull = new SearchParameters.FilterCriteria();
        deprecatedTimeFilterNull.setAttributeName("deprecatedTime");
        deprecatedTimeFilterNull.setOperator(SearchParameters.Operator.IS_NULL);
        deprecatedTimeCriteria.add(deprecatedTimeFilterNull);
        SearchParameters.FilterCriteria deprecatedTimeFilters = new SearchParameters.FilterCriteria();
        deprecatedTimeFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        deprecatedTimeFilters.setCriterion(deprecatedTimeCriteria);
        criteria.add(deprecatedTimeFilters);
        SearchParameters.FilterCriteria filters = new SearchParameters.FilterCriteria();
        filters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        filters.setCriterion(criteria);
        searchParams.setTypeName(String.join((CharSequence)",", types));
        searchParams.setClassification(String.join((CharSequence)",", tags));
        searchParams.setEntityFilters(filters);
        searchParams.setExcludeDeletedEntities(!includeDeleted);
        searchParams.setOffset(offset);
        searchParams.setLimit(limit);
        if (!SearchResource.isWildCardSearch(tags)) {
            searchParams.setSortBy(sortByAttribute);
            searchParams.setSortOrder(sortOrder);
        }
        return this.search(searchParams);
    }

    private SearchParameters.FilterCriteria createTimeRangeFilter(TimeRangeType timeRangeType, String timeRangeAttr, long timeRangeStart, long timeRangeEnd) {
        if (timeRangeAttr == null || timeRangeType == null && timeRangeStart == 0L && timeRangeEnd == 0L) {
            return null;
        }
        SearchParameters.FilterCriteria timeRangeFilter = new SearchParameters.FilterCriteria();
        timeRangeFilter.setAttributeName(timeRangeAttr);
        timeRangeFilter.setOperator(SearchParameters.Operator.TIME_RANGE);
        if (timeRangeType == null || timeRangeType == TimeRangeType.CUSTOM) {
            if (timeRangeEnd == 0L) {
                timeRangeEnd = Long.MAX_VALUE;
            }
            timeRangeFilter.setAttributeValue(timeRangeStart + "," + timeRangeEnd);
        } else {
            timeRangeFilter.setAttributeValue(timeRangeType.name());
        }
        return timeRangeFilter;
    }

    @GET
    @Path(value="/attribute")
    @PerformanceMetric(value="catalog.search.attribute")
    @Operation(summary="Retrieve data for the specified attribute search query.", description="Retrieve data for the specified attribute search query.", responses={@ApiResponse(responseCode="200", description="On successful search query with some results, might return an empty list if execution succeeded without any results", content={@Content(schema=@Schema(implementation=SearchResult.class))}), @ApiResponse(responseCode="400", description="Invalid wildcard or query parameters"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="searchCatalogUsingAttributes")
    public SearchResult searchUsingAttribute(@Parameter(description="Limit the result to only entities of specified types") @QueryParam(value="type") List<String> types, @QueryParam(value="types") String oldTypes, @Parameter(description="One of more additional attributes to return in the response") @QueryParam(value="attr") List<String> attrs, @QueryParam(value="attrs") String oldAttrs, @Parameter(description="The attribute to search") @QueryParam(value="attrName") List<String> attrNames, @Parameter(description="The prefix for the attribute value to search") @QueryParam(value="attrValuePrefix") List<String> attrValuePrefixes, @Parameter(description="Limit the result to only entities tagged with the given tag") @QueryParam(value="tag") List<String> tags, @Parameter(description="The type of time range search, default is CUSTOM") @QueryParam(value="timeRangeType") TimeRangeType timeRangeType, @Parameter(description="The attribute for a time range search") @QueryParam(value="timeRangeAttr") String timeRangeAttr, @Parameter(description="The start for a custom time range search in ms since the epoch") @QueryParam(value="timeRangeStart") long timeRangeStart, @Parameter(description="The end for a custom time range search in ms since the epoch") @QueryParam(value="timeRangeEnd") long timeRangeEnd, @Parameter(description="An attribute to sort by") @DefaultValue(value="qualifiedName") @QueryParam(value="sortBy") String sortByAttribute, @Parameter(description="Sort order, either ASCENDING (default) or DESCENDING") @DefaultValue(value="ASCENDING") @QueryParam(value="sortOrder") SortOrder sortOrder, @Parameter(description="Whether to include deleted entities") @QueryParam(value="deleted") boolean includeDeleted, @Parameter(description="Limit the result set to only include the specified number of entries") @QueryParam(value="limit") int limit, @Parameter(description="Start offset of the result set (useful for pagination)") @QueryParam(value="offset") int offset) throws AtlasBaseException {
        List<String> allTypes;
        Servlets.validateQueryParamLength("types", oldTypes);
        Servlets.validateQueryParamLength("attrs", oldAttrs);
        Servlets.validateQueryParamLength("sortBy", sortByAttribute);
        List<String> allAttrs = oldAttrs != null ? Arrays.asList(oldAttrs.split(",")) : attrs;
        List<String> list = allTypes = oldTypes != null ? Arrays.asList(oldTypes.split(",")) : types;
        if (allTypes.isEmpty()) {
            allTypes = Collections.singletonList("cf_entity");
        }
        LOG.info("Search by attribute: types {}, attrs {}, attrName {}, attrValuePrefix {}, tag {} sortBy {}, sortOrder {}, deleted {}, limit {}, offset {}", new Object[]{allTypes, allAttrs, attrNames, attrValuePrefixes, tags, sortByAttribute, sortOrder, includeDeleted, limit, offset});
        ArrayList<AtlasEntityHeader> entities = new ArrayList<AtlasEntityHeader>();
        HashMap<String, AtlasEntityHeader> referredEntities = new HashMap<String, AtlasEntityHeader>();
        AtlasSearchResult result = this.searchTypeUsingAttribute(allTypes, allAttrs, attrNames, attrValuePrefixes, tags, timeRangeType, timeRangeAttr, timeRangeStart, timeRangeEnd, sortByAttribute, sortOrder, includeDeleted, limit, offset);
        if (result.getEntities() != null) {
            entities.addAll(result.getEntities());
        }
        if (result.getReferredEntities() != null) {
            referredEntities.putAll(result.getReferredEntities());
        }
        SearchParams sp = new SearchParams();
        sp.setIncludeDeleted(includeDeleted);
        sp.setLimit(limit);
        sp.setOffset(offset);
        SearchResult sr = new SearchResult(sp);
        sr.setTypes(allTypes);
        sr.setEntities(entities);
        if (referredEntities.size() > 0) {
            sr.setReferredEntities(referredEntities);
        }
        LOG.info("Search by attribute result: entities {}, referredEntities {}", (Object)entities.size(), (Object)referredEntities.size());
        return sr;
    }

    @GET
    @Path(value="/tagEntityCount")
    @Operation(responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public Map<String, Object> getTagDefsAndEntityCount(@Context HttpHeaders headers) {
        Map<String, Map> resultTags;
        String tenant = this.getSchemaRegistry().tenant();
        ContainerRequestContext requestContext = CatalogRequestContextHolder.getRequestContext();
        String authHeader = requestContext.getHeaderString("Authorization");
        Map<String, Map<String, Set<AtlasEntityHeader>>> entitiesByTagDef = this.tenantMetricsService.getEntitiesByTagDef(tenant);
        if (this.dataCatalogConfig.isCatalogRbacEnabled()) {
            Map<String, Map<String, Set<AtlasEntityHeader>>> filteredByTagDefsRbac = this.filterByTagDefsRbac(tenant, authHeader, entitiesByTagDef, requestContext);
            Map<String, Map<String, Set<AtlasEntityHeader>>> filteredByEntitiesRbac = this.filterByEntitiesRbac(authHeader, filteredByTagDefsRbac);
            resultTags = filteredByEntitiesRbac.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> ((Set)innerEntry.getValue()).size()))));
        } else {
            resultTags = entitiesByTagDef.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> ((Set)innerEntry.getValue()).size()))));
        }
        HashMap<String, Object> tagDataForTenant = new HashMap<String, Object>();
        tagDataForTenant.put("tag_def_count", resultTags.size());
        ArrayList tagDefs = new ArrayList();
        for (Map.Entry<String, Map> tagDefEntry : resultTags.entrySet()) {
            int totalCount = 0;
            HashMap<String, Object> tagDef = new HashMap<String, Object>();
            tagDef.put("name", tagDefEntry.getKey());
            for (Map.Entry associatedEntity : tagDefEntry.getValue().entrySet()) {
                tagDef.put((String)associatedEntity.getKey() + "_count", associatedEntity.getValue());
                totalCount += ((Integer)associatedEntity.getValue()).intValue();
            }
            tagDef.put("total_entity_count", totalCount);
            tagDefs.add(tagDef);
        }
        tagDataForTenant.put("tagDefs", tagDefs);
        return tagDataForTenant;
    }

    private AtlasSearchResult searchTypeUsingAttribute(List<String> types, List<String> attrs, List<String> attrNames, List<String> attrValuePrefixes, List<String> tags, TimeRangeType timeRangeType, String timeRangeAttr, long timeRangeStart, long timeRangeEnd, String sortByAttribute, SortOrder sortOrder, boolean includeDeleted, int limit, int offset) throws AtlasBaseException {
        if (attrNames.size() != attrValuePrefixes.size()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Number of attrName and attrValuePrefix parameters do not match"});
        }
        for (String attrName : attrNames) {
            Servlets.validateQueryParamLength("attrName", attrName);
        }
        for (String attrValuePrefix : attrValuePrefixes) {
            Servlets.validateQueryParamLength("attrValuePrefix", attrValuePrefix);
        }
        if (!tags.isEmpty()) {
            tags = tags.stream().map(tag -> QualifiedNameGenerator.ensureTypeTenantPrefix(this.getSchemaRegistry().tenant(), tag)).collect(Collectors.toList());
        }
        SearchParameters searchParams = new SearchParameters();
        HashSet<String> attributes = new HashSet<String>(attrs);
        attributes.add("tenant");
        attributes.add("name");
        attributes.add("nameLower");
        attributes.add("qualifiedName");
        if (types.stream().allMatch(s -> s.startsWith("sr_"))) {
            attributes.add("context");
            attributes.add("id");
        }
        searchParams.setAttributes(attributes);
        ArrayList<SearchParameters.FilterCriteria> attrCriteria = new ArrayList<SearchParameters.FilterCriteria>();
        for (int i = 0; i < attrNames.size(); ++i) {
            String attrName = attrNames.get(i);
            if (StringUtils.isEmpty((CharSequence)attrName)) {
                attrName = "qualifiedName";
            }
            if (attrName.contains(".")) {
                attrName = QualifiedNameGenerator.ensureTypeTenantPrefix(this.getSchemaRegistry().tenant(), attrName);
            }
            String attrValuePrefix = attrValuePrefixes.get(i);
            if ("qualifiedName".equals(attrName)) {
                String tenant = this.getSchemaRegistry().tenant();
                attrValuePrefix = QualifiedNameGenerator.ensurePrefix(tenant, QualifiedNameGenerator.NAME_DELIMITER, attrValuePrefix);
            }
            SearchParameters.FilterCriteria attrFilter = new SearchParameters.FilterCriteria();
            attrFilter.setAttributeName(attrName);
            attrFilter.setOperator(SearchParameters.Operator.STARTS_WITH);
            attrFilter.setAttributeValue(attrValuePrefix);
            attrCriteria.add(attrFilter);
        }
        ArrayList<SearchParameters.FilterCriteria> criteria = new ArrayList<SearchParameters.FilterCriteria>();
        SearchParameters.FilterCriteria attrFilters = new SearchParameters.FilterCriteria();
        attrFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        attrFilters.setCriterion(attrCriteria);
        criteria.add(attrFilters);
        SearchParameters.FilterCriteria tenantFilter = new SearchParameters.FilterCriteria();
        tenantFilter.setAttributeName("tenant");
        tenantFilter.setOperator(SearchParameters.Operator.EQ);
        tenantFilter.setAttributeValue(this.getSchemaRegistry().tenant());
        criteria.add(tenantFilter);
        SearchParameters.FilterCriteria timeRangeFilter = this.createTimeRangeFilter(timeRangeType, timeRangeAttr, timeRangeStart, timeRangeEnd);
        if (timeRangeFilter != null) {
            criteria.add(timeRangeFilter);
        }
        ArrayList<SearchParameters.FilterCriteria> deprecatedTimeCriteria = new ArrayList<SearchParameters.FilterCriteria>();
        SearchParameters.FilterCriteria deprecatedTimeFilterZero = new SearchParameters.FilterCriteria();
        deprecatedTimeFilterZero.setAttributeName("deprecatedTime");
        deprecatedTimeFilterZero.setOperator(SearchParameters.Operator.EQ);
        deprecatedTimeFilterZero.setAttributeValue("0");
        deprecatedTimeCriteria.add(deprecatedTimeFilterZero);
        SearchParameters.FilterCriteria deprecatedTimeFilterNull = new SearchParameters.FilterCriteria();
        deprecatedTimeFilterNull.setAttributeName("deprecatedTime");
        deprecatedTimeFilterNull.setOperator(SearchParameters.Operator.IS_NULL);
        deprecatedTimeCriteria.add(deprecatedTimeFilterNull);
        SearchParameters.FilterCriteria deprecatedTimeFilters = new SearchParameters.FilterCriteria();
        deprecatedTimeFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        deprecatedTimeFilters.setCriterion(deprecatedTimeCriteria);
        criteria.add(deprecatedTimeFilters);
        SearchParameters.FilterCriteria filters = new SearchParameters.FilterCriteria();
        filters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        filters.setCriterion(criteria);
        searchParams.setTypeName(String.join((CharSequence)",", types));
        searchParams.setClassification(String.join((CharSequence)",", tags));
        searchParams.setEntityFilters(filters);
        searchParams.setExcludeDeletedEntities(!includeDeleted);
        searchParams.setOffset(offset);
        searchParams.setLimit(limit);
        if (!SearchResource.isWildCardSearch(tags)) {
            searchParams.setSortBy(sortByAttribute);
            searchParams.setSortOrder(sortOrder);
        }
        return this.search(searchParams);
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getRequestRbacPermissionEntity(ContainerRequestContext requestContext) {
        return null;
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getResponseRbacPermissionEntity(ContainerRequestContext requestContext, ContainerResponseContext responseContext, String resourceMethod) {
        return null;
    }

    private AtlasSearchResult search(SearchParameters searchParams) throws AtlasBaseException {
        AtlasSearchResult searchResult;
        try {
            searchResult = this.discoveryService.searchWithParameters(searchParams);
        }
        catch (AtlasBaseException e) {
            LOG.error("Atlas search failed", (Throwable)e);
            if (AtlasErrorCode.UNKNOWN_CLASSIFICATION != e.getAtlasErrorCode()) {
                throw e;
            }
            searchResult = new AtlasSearchResult(searchParams);
        }
        return searchResult;
    }

    private static boolean isWildCardSearch(List<String> tagNames) {
        if (CollectionUtils.isNotEmpty(tagNames)) {
            return tagNames.stream().anyMatch(tag -> tag.contains("*"));
        }
        return false;
    }

    private Map<String, Map<String, Set<AtlasEntityHeader>>> filterByTagDefsRbac(String cluster, String authHeader, Map<String, Map<String, Set<AtlasEntityHeader>>> entitiesByTagDef, ContainerRequestContext requestContext) {
        LOG.info("RBAC check for {} tag defs", (Object)entitiesByTagDef.size());
        return entitiesByTagDef.entrySet().stream().filter(entry -> this.authorizeTagDefRead(cluster, (String)entry.getKey(), authHeader, requestContext)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Map<String, Set<AtlasEntityHeader>>> filterByEntitiesRbac(String authHeader, Map<String, Map<String, Set<AtlasEntityHeader>>> entitiesByTagDef) {
        return entitiesByTagDef.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, outerEntry -> ((Map)outerEntry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> {
            Set<AtlasEntityHeader> deepCopiedEntities = ((Set)innerEntry.getValue()).stream().map(AtlasEntityHeader::new).collect(Collectors.toSet());
            LOG.info("RBAC check for {} {}", (Object)deepCopiedEntities.size(), innerEntry.getKey());
            this.catalogRbacAuthorizationFilter.scrubEntities(authHeader, deepCopiedEntities);
            return deepCopiedEntities.stream().filter(entity -> !entity.getGuid().equals("-1")).collect(Collectors.toSet());
        }))));
    }

    private boolean authorizeTagDefRead(String cluster, String tagDef, String authHeader, ContainerRequestContext requestContext) {
        List<CatalogAuthorizerClient.CatalogAuthorizerResponse> responses;
        CatalogAuthorizerClient.CatalogAuthorizerRequest request;
        SchemaRegistryResource.RbacPermissionEntity permissionEntity = new SchemaRegistryResource.RbacPermissionEntity(Collections.singletonList(new SchemaRegistryResource.RbacPermissionAction(tagDef, RbacConstants.RbacResourceTypes.CatalogTagDefinition, RbacConstants.RbacOperations.Read)), cluster);
        try {
            request = CatalogRequestFilter.getAuthorizeRequests(permissionEntity);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Failed to construct AuthorizerRequest", (Throwable)e);
            return false;
        }
        if (request.getActions().isEmpty()) {
            return true;
        }
        try {
            responses = this.authorizerRestClient.authorize(requestContext, authHeader, request);
        }
        catch (CatalogAuthorizerClient.CatalogAuthorizerRestClientException e) {
            LOG.error("Failed to authorize", (Throwable)e);
            return false;
        }
        for (CatalogAuthorizerClient.CatalogAuthorizerResponse response : responses) {
            if (response.getResult() == CatalogAuthorizerClient.CatalogAuthorizeResult.ALLOWED) continue;
            LOG.info("Authorization not allowed for resource:{} operation: {}", (Object)response.getResourceName(), (Object)response.getOperation());
            return false;
        }
        return true;
    }
}

