/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.catalog.storage.MetadataRegistry;
import io.confluent.catalog.util.CatalogTenantUtils;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.util.RbacConstants;
import io.confluent.catalog.web.rest.entities.BusinessMetadataDefResponse;
import io.confluent.catalog.web.rest.entities.TagDefResponse;
import io.confluent.catalog.web.rest.resources.SchemaRegistryResource;
import io.confluent.catalog.web.util.Servlets;
import io.confluent.catalog.web.util.Types;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="catalog/v1/types")
@Singleton
@Service
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"})
public class TypesResource
extends SchemaRegistryResource {
    private static final Logger LOG = LoggerFactory.getLogger(TypesResource.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CORE_PATH = "catalog/v1/types";
    private static final String TAGDEFS_PATH = "/tagdefs";
    private static final String BUSINESSMETADATADEFS_PATH = "/businessmetadatadefs";
    private final MetadataRegistry registry;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasDiscoveryService discoveryService;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
    private final int tenantMaxTagDefs;

    @Inject
    public TypesResource(SchemaRegistry schemaRegistry, MetadataRegistry registry, AtlasTypeRegistry typeRegistry, AtlasDiscoveryService discoveryService) {
        super(schemaRegistry);
        try {
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
            this.registry = registry;
            this.typeRegistry = typeRegistry;
            this.discoveryService = discoveryService;
            this.tenantMaxTagDefs = dataCatalogConfig.catalogTenantMaxTagDefs();
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate TypesResource", e);
        }
    }

    @GET
    @Path(value="/tagdefs")
    @PerformanceMetric(value="catalog.types.get-tagdefs")
    @Operation(summary="Bulk retrieval API for retrieving tag definitions.", description="Bulk retrieval API for retrieving tag definitions.", responses={@ApiResponse(responseCode="200", description="The tag definitions", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TagDefResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="getAllTagDefs")
    public List<TagDefResponse> getAllTagDefs(@Parameter(description="The prefix of a tag definition name") @QueryParam(value="prefix") String prefix, @QueryParam(value="substring") String substring) throws AtlasBaseException {
        Servlets.validateQueryParamLength("prefix", prefix);
        Servlets.validateQueryParamLength("substring", substring);
        LOG.debug("Get tag defs: prefix {}", (Object)prefix);
        String tenantPrefix = QualifiedNameGenerator.ensureTypeTenantPrefix(this.getSchemaRegistry().tenant(), prefix != null ? prefix : "");
        String typeTenantPrefix = CatalogTenantUtils.tenantToEscaped(this.getSchemaRegistry().tenant()) + "__";
        ArrayList<TagDefResponse> tagDefs = new ArrayList<TagDefResponse>();
        for (AtlasClassificationType classificationType : this.typeRegistry.getAllClassificationTypes()) {
            String typeName;
            if (!classificationType.getTypeName().startsWith(tenantPrefix) || !StringUtils.isEmpty((CharSequence)substring) && !StringUtils.containsIgnoreCase((CharSequence)(typeName = classificationType.getTypeName().replaceFirst(typeTenantPrefix, "")), (CharSequence)substring)) continue;
            TagDef tagDef = new TagDef(classificationType.getClassificationDef());
            tagDefs.add(new TagDefResponse(tagDef));
        }
        return tagDefs;
    }

    @GET
    @Path(value="/tagdefs/{tagName}")
    @PerformanceMetric(value="catalog.types.get-tagdef")
    @Operation(summary="Get the tag definition with the given name.", description="Get the tag definition with the given name.", responses={@ApiResponse(responseCode="200", description="The tag definition", content={@Content(schema=@Schema(implementation=TagDef.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Tag definition not found"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="getTagDefByName")
    public TagDef getTagDefByName(@Parameter(description="The name of the tag definiton") @PathParam(value="tagName") String tagName) throws AtlasBaseException {
        LOG.debug("Get tag def: tagName {}", (Object)tagName);
        String tenant = this.getSchemaRegistry().tenant();
        String qualifiedTagName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, tagName);
        return this.registry.getTagDef(tenant, qualifiedTagName);
    }

    @POST
    @Path(value="/tagdefs")
    @PerformanceMetric(value="catalog.types.create-tagdefs")
    @Operation(summary="Bulk create API for tag definitions.", description="Bulk create API for tag definitions.", responses={@ApiResponse(responseCode="200", description="The tag definitions. Errored tag definitions will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TagDefResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="createTagDefs")
    public void createTagDefs(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The tag definitions to create") List<TagDef> tagDefs) throws AtlasBaseException {
        LOG.debug("Create tag defs: defs {}", tagDefs);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        if (this.getTagDefCount(tenant) + (long)tagDefs.size() > (long)this.tenantMaxTagDefs) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Tag Definition Limit Exceeded"});
        }
        for (TagDef tagDef : tagDefs) {
            tagDef.ensureTenantPrefix(tenant);
            if (tagDef.getAttributeDefs() == null || tagDef.getAttributeDefs().isEmpty()) continue;
            for (AtlasStructDef.AtlasAttributeDef attrDef : tagDef.getAttributeDefs()) {
                Types.setDefaultMaxStrLength(attrDef);
                attrDef.setIsIndexable(true);
            }
        }
        try {
            List<TagDefResponse> ret = this.registry.createTagDefsOrForward(this.getSchemaRegistry().tenant(), tagDefs, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating tag definitions", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/tagdefs")
    @PerformanceMetric(value="catalog.types.update-tagdefs")
    @Operation(summary="Bulk update API for tag definitions.", description="Bulk update API for tag definitions.", responses={@ApiResponse(responseCode="200", description="The tag definitions. Errored tag definitions will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TagDefResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="updateTagDefs")
    public void updateTagDefs(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The tag definitions to update") List<TagDef> tagDefs) throws AtlasBaseException {
        LOG.debug("Update tag defs: defs {}", tagDefs);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        for (TagDef tagDef : tagDefs) {
            tagDef.ensureTenantPrefix(tenant);
            if (tagDef.getAttributeDefs() == null || tagDef.getAttributeDefs().isEmpty()) continue;
            for (AtlasStructDef.AtlasAttributeDef attrDef : tagDef.getAttributeDefs()) {
                Types.setDefaultMaxStrLength(attrDef);
                attrDef.setIsIndexable(true);
            }
        }
        try {
            List<TagDefResponse> ret = this.registry.updateTagDefsOrForward(this.getSchemaRegistry().tenant(), tagDefs, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while updating tag definitions", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/tagdefs/{tagName}")
    @PerformanceMetric(value="catalog.types.delete-tagdef")
    @Operation(summary="Delete API for tag definition identified by its name.", description="Delete API for tag definition identified by its name.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="deleteTagDef")
    public void deleteTagDef(@Parameter(description="The name of the tag definition") @PathParam(value="tagName") String tagName, @Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers) throws AtlasBaseException {
        LOG.debug("Delete tag def: tagName {}", (Object)tagName);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        String qualifiedTagName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, tagName);
        try {
            this.registry.deleteTagDefOrForward(this.getSchemaRegistry().tenant(), qualifiedTagName, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting tag definition", (Throwable)e);
        }
    }

    @POST
    @Path(value="/businessmetadatadefs")
    @PerformanceMetric(value="catalog.types.create-businessmetadatadefs")
    @Operation(summary="Bulk create API for business metadata definitions.", description="Bulk create API for business metadata definitions.", responses={@ApiResponse(responseCode="200", description="The business metadata definitions. Errored business metadata definitions will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BusinessMetadataDefResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="createBusinessMetadataDefs")
    public void createBusinessMetadataDefs(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The business metadata definitions to create") List<AtlasBusinessMetadataDef> bmDefs) throws AtlasBaseException {
        LOG.debug("Create business metadata definitions: defs {}", bmDefs);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        for (AtlasBusinessMetadataDef bmDef : bmDefs) {
            bmDef.setName(QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, bmDef.getName()));
            if (bmDef.getAttributeDefs() != null && !bmDef.getAttributeDefs().isEmpty()) {
                for (AtlasStructDef.AtlasAttributeDef attrDef : bmDef.getAttributeDefs()) {
                    Types.setDefaultMaxStrLength(attrDef);
                    Types.setDefaultApplicableEntityTypes(attrDef);
                    attrDef.setIsIndexable(true);
                }
            }
            bmDef.addAttribute(Types.createInternalBMNameAttribute());
        }
        try {
            List<BusinessMetadataDefResponse> ret = this.registry.createBusinessMetadataDefsOrForward(this.getSchemaRegistry().tenant(), bmDefs, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating business metadata definitions", (Throwable)e);
        }
    }

    @GET
    @Path(value="/businessmetadatadefs")
    @PerformanceMetric(value="catalog.types.get-businessmetadatadefs")
    @Operation(summary="Bulk retrieval API for retrieving business metadata definitions.", description="Bulk retrieval API for retrieving business metadata definitions.", responses={@ApiResponse(responseCode="200", description="The business metadata definitions", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BusinessMetadataDefResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="getAllBusinessMetadataDefs")
    public List<BusinessMetadataDefResponse> getAllBusinessMetadataDefs(@Parameter(description="The prefix of a business metadata definition name") @QueryParam(value="prefix") String prefix) throws AtlasBaseException {
        Servlets.validateQueryParamLength("prefix", prefix);
        LOG.debug("Get business metadata definitions: prefix {}", (Object)prefix);
        String tenantPrefix = QualifiedNameGenerator.ensureTypeTenantPrefix(this.getSchemaRegistry().tenant(), prefix != null ? prefix : "");
        ArrayList<BusinessMetadataDefResponse> bmDefs = new ArrayList<BusinessMetadataDefResponse>();
        for (AtlasBusinessMetadataType bmType : this.typeRegistry.getAllBusinessMetadataTypes()) {
            if (!bmType.getTypeName().startsWith(tenantPrefix)) continue;
            bmDefs.add(new BusinessMetadataDefResponse(bmType.getBusinessMetadataDef()));
        }
        return bmDefs;
    }

    @GET
    @Path(value="/businessmetadatadefs/{bmName}")
    @PerformanceMetric(value="catalog.types.get-businessmetadatadef")
    @Operation(summary="Get the business metadata definition with the given name.", description="Get the business metadata definition with the given name.", responses={@ApiResponse(responseCode="200", description="The business metadata definition", content={@Content(schema=@Schema(implementation=AtlasBusinessMetadataDef.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Business metadata definition not found"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="getBusinessMetadataDefByName")
    public AtlasBusinessMetadataDef getBusinessMetadataDefByName(@Parameter(description="The name of the business metadata definition") @PathParam(value="bmName") String bmName) throws AtlasBaseException {
        LOG.debug("Get business metadata definition: bmName {}", (Object)bmName);
        String tenant = this.getSchemaRegistry().tenant();
        String qualifiedBMName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, bmName);
        return this.registry.getBusinessMetadataDef(tenant, qualifiedBMName);
    }

    @PUT
    @Path(value="/businessmetadatadefs")
    @PerformanceMetric(value="catalog.types.update-businessmetadatadefs")
    @Operation(summary="Bulk update API for business metadata definitions.", description="Bulk update API for business metadata definitions.", responses={@ApiResponse(responseCode="200", description="The business metadata definitions. Errored business metadata definitions will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BusinessMetadataDefResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="updateBusinessMetadataDefs")
    public void updateBusinessMetadataDefs(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The business metadata definitions to update") List<AtlasBusinessMetadataDef> bmDefs) throws AtlasBaseException {
        LOG.debug("Update business metadata definitions: defs {}", bmDefs);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        for (AtlasBusinessMetadataDef bmDef : bmDefs) {
            bmDef.setName(QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, bmDef.getName()));
            if (bmDef.getAttributeDefs() != null && !bmDef.getAttributeDefs().isEmpty()) {
                for (AtlasStructDef.AtlasAttributeDef attrDef : bmDef.getAttributeDefs()) {
                    Types.setDefaultMaxStrLength(attrDef);
                    Types.setDefaultApplicableEntityTypes(attrDef);
                    attrDef.setIsIndexable(true);
                }
            }
            bmDef.addAttribute(Types.createInternalBMNameAttribute());
        }
        try {
            List<BusinessMetadataDefResponse> ret = this.registry.updateBusinessMetadataDefsOrForward(this.getSchemaRegistry().tenant(), bmDefs, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while updating business metadata definitions", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/businessmetadatadefs/{bmName}")
    @PerformanceMetric(value="catalog.types.delete-businessmetadatadef")
    @Operation(summary="Delete API for business metadata definition identified by its name.", description="Delete API for business metadata definition identified by its name.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="deleteBusinessMetadataDef")
    public void deleteBusinessMetadataDef(@Parameter(description="The name of the business metadata definition") @PathParam(value="bmName") String bmName, @Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers) throws AtlasBaseException {
        LOG.debug("Delete business metadata definition: bmName {}", (Object)bmName);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        String qualifiedBMName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, bmName);
        this.checkBusinessMetadataRef(qualifiedBMName);
        try {
            this.registry.deleteBusinessMetadataDefOrForward(this.getSchemaRegistry().tenant(), qualifiedBMName, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting business metadata definition", (Throwable)e);
        }
    }

    private long getTagDefCount(String tenant) {
        Collection classificationDefNames = this.typeRegistry.getAllClassificationDefNames();
        if (classificationDefNames == null || classificationDefNames.isEmpty()) {
            return 0L;
        }
        String tenantPrefix = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, "");
        return classificationDefNames.stream().filter(name -> name.startsWith(tenantPrefix)).count();
    }

    private void checkBusinessMetadataRef(String typeName) throws AtlasBaseException {
        AtlasBusinessMetadataDef businessMetadataDef = this.typeRegistry.getBusinessMetadataDefByName(typeName);
        if (businessMetadataDef != null) {
            List attributeDefs = businessMetadataDef.getAttributeDefs();
            for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefs) {
                Set applicableTypes;
                String qualifiedName;
                String vertexPropertyName = AtlasStructType.AtlasAttribute.generateVertexPropertyName((AtlasStructDef)businessMetadataDef, (AtlasStructDef.AtlasAttributeDef)attributeDef, (String)(qualifiedName = AtlasStructType.AtlasAttribute.getQualifiedAttributeName((AtlasStructDef)businessMetadataDef, (String)attributeDef.getName())));
                if (!this.isBusinessAttributePresent(vertexPropertyName, applicableTypes = (Set)AtlasJson.fromJson((String)attributeDef.getOption("applicableEntityTypes"), Set.class))) continue;
                throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{typeName});
            }
        }
    }

    private boolean isBusinessAttributePresent(String attrName, Set<String> applicableTypes) throws AtlasBaseException {
        SearchParameters.FilterCriteria criteria = new SearchParameters.FilterCriteria();
        criteria.setAttributeName(attrName);
        criteria.setOperator(SearchParameters.Operator.NOT_EMPTY);
        SearchParameters.FilterCriteria entityFilters = new SearchParameters.FilterCriteria();
        entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        entityFilters.setCriterion(Collections.singletonList(criteria));
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setTypeName(String.join((CharSequence)",", applicableTypes));
        searchParameters.setExcludeDeletedEntities(true);
        searchParameters.setIncludeSubClassifications(false);
        searchParameters.setEntityFilters(entityFilters);
        searchParameters.setAttributes(Collections.singleton(attrName));
        searchParameters.setOffset(0);
        searchParameters.setLimit(1);
        AtlasSearchResult atlasSearchResult = this.discoveryService.searchWithParameters(searchParameters);
        return CollectionUtils.isNotEmpty((Collection)atlasSearchResult.getEntities());
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getRequestRbacPermissionEntity(ContainerRequestContext requestContext) throws IOException {
        RbacConstants.RbacResourceTypes resourceType;
        String cluster = this.getSchemaRegistry().tenant();
        RbacConstants.RbacOperations operation = TypesResource.getRbacOperation(requestContext.getMethod());
        UriInfo uri = requestContext.getUriInfo();
        if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)"catalog/v1/types/tagdefs")) {
            resourceType = RbacConstants.RbacResourceTypes.CatalogTagDefinition;
        } else if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)"catalog/v1/types/businessmetadatadefs")) {
            resourceType = RbacConstants.RbacResourceTypes.CatalogBusinessMetadataDefinition;
        } else {
            return null;
        }
        List<SchemaRegistryResource.RbacPermissionAction> permissionList = null;
        String httpMethod = requestContext.getMethod();
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT")) {
            permissionList = this.getResourcesFromRequestBody(requestContext, operation, resourceType);
        } else if (httpMethod.equalsIgnoreCase("DELETE")) {
            permissionList = this.getResourcesFromRequestPath(requestContext, operation, resourceType);
        } else {
            return null;
        }
        return new SchemaRegistryResource.RbacPermissionEntity(permissionList, cluster);
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getResponseRbacPermissionEntity(ContainerRequestContext requestContext, ContainerResponseContext responseContext, String resourceMethod) {
        String httpMethod = requestContext.getMethod();
        if (!httpMethod.equalsIgnoreCase("GET")) {
            return null;
        }
        String cluster = this.getSchemaRegistry().tenant();
        RbacConstants.RbacOperations operation = TypesResource.getRbacOperation(requestContext.getMethod());
        List<SchemaRegistryResource.RbacPermissionAction> permissionList = null;
        switch (resourceMethod) {
            case "getAllTagDefs": {
                permissionList = this.getAllTagDefsRbacPermissionActionList(responseContext, cluster, RbacConstants.RbacResourceTypes.CatalogTagDefinition, operation);
                break;
            }
            case "getTagDefByName": {
                permissionList = this.getTagDefsByNameRbacPermissionActionList(responseContext, cluster, RbacConstants.RbacResourceTypes.CatalogTagDefinition, operation);
                break;
            }
            case "getAllBusinessMetadataDefs": {
                permissionList = this.getBMDefsRbacPermissionActionList(responseContext, cluster, RbacConstants.RbacResourceTypes.CatalogBusinessMetadataDefinition, operation);
                break;
            }
            case "getBusinessMetadataDefByName": {
                permissionList = this.getBMDefsByNameRbacPermissionActionList(responseContext, cluster, RbacConstants.RbacResourceTypes.CatalogBusinessMetadataDefinition, operation);
                break;
            }
            default: {
                return null;
            }
        }
        return permissionList != null ? new SchemaRegistryResource.RbacPermissionEntity(permissionList, cluster) : null;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getAllTagDefsRbacPermissionActionList(ContainerResponseContext responseContext, String tenant, RbacConstants.RbacResourceTypes resourceType, RbacConstants.RbacOperations operation) {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> actions = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        if (responseContext.getEntity() == null || !(responseContext.getEntity() instanceof List)) {
            return null;
        }
        String typeTenantPrefix = CatalogTenantUtils.tenantToEscaped(tenant) + "__";
        List tagDefResponses = (List)responseContext.getEntity();
        for (TagDefResponse response : tagDefResponses) {
            if (response.getName() == null) continue;
            actions.add(new SchemaRegistryResource.RbacPermissionAction(response.getName().replaceFirst(typeTenantPrefix, ""), resourceType, operation));
        }
        return actions;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getTagDefsByNameRbacPermissionActionList(ContainerResponseContext responseContext, String tenant, RbacConstants.RbacResourceTypes resourceType, RbacConstants.RbacOperations operation) {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> actions = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        if (!(responseContext.getEntity() instanceof TagDef)) {
            return null;
        }
        String typeTenantPrefix = CatalogTenantUtils.tenantToEscaped(tenant) + "__";
        TagDef tagDef = (TagDef)((Object)responseContext.getEntity());
        if (tagDef.getName() != null) {
            actions.add(new SchemaRegistryResource.RbacPermissionAction(tagDef.getName().replaceFirst(typeTenantPrefix, ""), resourceType, operation));
        }
        return actions;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getTagDefResourcesFromRequestPath(ContainerRequestContext requestContext, RbacConstants.RbacOperations operation, RbacConstants.RbacResourceTypes resourceType, String tenant) {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> requests = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        String tagName = Servlets.getPathParameter(requestContext.getUriInfo(), "tagName");
        if (tagName != null && !tagName.isEmpty()) {
            requests.add(new SchemaRegistryResource.RbacPermissionAction(tagName, resourceType, operation));
        }
        return requests;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getBMDefResourcesFromRequestPath(ContainerRequestContext requestContext, RbacConstants.RbacOperations operation, RbacConstants.RbacResourceTypes resourceType, String tenant) {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> requests = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        String bmName = Servlets.getPathParameter(requestContext.getUriInfo(), "bmName");
        if (bmName != null && !bmName.isEmpty()) {
            requests.add(new SchemaRegistryResource.RbacPermissionAction(bmName, resourceType, operation));
        }
        return requests;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getBMDefsRbacPermissionActionList(ContainerResponseContext responseContext, String tenant, RbacConstants.RbacResourceTypes resourceType, RbacConstants.RbacOperations operation) {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> actions = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        if (!(responseContext.getEntity() instanceof List)) {
            return null;
        }
        String typeTenantPrefix = CatalogTenantUtils.tenantToEscaped(tenant) + "__";
        List defResponses = (List)responseContext.getEntity();
        for (BusinessMetadataDefResponse response : defResponses) {
            if (response.getName() == null) continue;
            actions.add(new SchemaRegistryResource.RbacPermissionAction(response.getName().replaceFirst(typeTenantPrefix, ""), resourceType, operation));
        }
        return actions;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getBMDefsByNameRbacPermissionActionList(ContainerResponseContext responseContext, String tenant, RbacConstants.RbacResourceTypes resourceType, RbacConstants.RbacOperations operation) {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> actions = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        if (!(responseContext.getEntity() instanceof AtlasBusinessMetadataDef)) {
            return null;
        }
        String typeTenantPrefix = CatalogTenantUtils.tenantToEscaped(tenant) + "__";
        AtlasBusinessMetadataDef bmDef = (AtlasBusinessMetadataDef)responseContext.getEntity();
        if (bmDef.getName() != null) {
            actions.add(new SchemaRegistryResource.RbacPermissionAction(bmDef.getName().replaceFirst(typeTenantPrefix, ""), resourceType, operation));
        }
        return actions;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getResourcesFromRequestPath(ContainerRequestContext requestContext, RbacConstants.RbacOperations operation, RbacConstants.RbacResourceTypes resourceType) {
        String tenant = this.getSchemaRegistry().tenant();
        if (resourceType.equals((Object)RbacConstants.RbacResourceTypes.CatalogTagDefinition)) {
            return this.getTagDefResourcesFromRequestPath(requestContext, operation, resourceType, tenant);
        }
        if (resourceType.equals((Object)RbacConstants.RbacResourceTypes.CatalogBusinessMetadataDefinition)) {
            return this.getBMDefResourcesFromRequestPath(requestContext, operation, resourceType, tenant);
        }
        return null;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getResourcesFromRequestBody(ContainerRequestContext requestContext, RbacConstants.RbacOperations operation, RbacConstants.RbacResourceTypes resourceType) throws IOException {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> requests = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        String json = IOUtils.toString((InputStream)requestContext.getEntityStream(), (Charset)Charsets.UTF_8);
        if (resourceType.equals((Object)RbacConstants.RbacResourceTypes.CatalogTagDefinition)) {
            List tagDefs = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<TagDef>>(){});
            for (TagDef tagDef : tagDefs) {
                requests.add(new SchemaRegistryResource.RbacPermissionAction(tagDef.getName(), resourceType, operation));
            }
        } else if (resourceType.equals((Object)RbacConstants.RbacResourceTypes.CatalogBusinessMetadataDefinition)) {
            List bmDefs = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<AtlasBusinessMetadataDef>>(){});
            for (AtlasBusinessMetadataDef bmDef : bmDefs) {
                requests.add(new SchemaRegistryResource.RbacPermissionAction(bmDef.getName(), resourceType, operation));
            }
        }
        InputStream in = IOUtils.toInputStream((String)json, (Charset)StandardCharsets.UTF_8);
        requestContext.setEntityStream(in);
        return requests;
    }
}

