/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BrokerStartupStatus;
import io.confluent.rest.BrokerStartupStatusHandle;
import io.confluent.rest.ControllerInternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerStartupStatusHandler
extends Handler.Abstract {
    private static final Logger log = LoggerFactory.getLogger(ControllerInternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final BrokerStartupStatusHandle brokerStartupStatusHandle;

    public BrokerStartupStatusHandler(BrokerStartupStatusHandle brokerStartupStatusHandle) {
        this.brokerStartupStatusHandle = Objects.requireNonNull(brokerStartupStatusHandle);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String target = request.getHttpURI().getPath();
        if (target.endsWith("/status")) {
            log.debug("Handling startup status query");
            try {
                boolean started = this.brokerStartupStatusHandle.started();
                if (started) {
                    BrokerStartupStatus status = new BrokerStartupStatus(started);
                    ResponseContainer.dataResponse(status).write(OBJECT_MAPPER, response);
                } else {
                    this.sendErrorResponse(412, "Broker startup not complete", response);
                }
            }
            catch (Exception e) {
                String failureMessage = "Failed to retrieve and write broker startup status";
                log.error(failureMessage, (Throwable)e);
                this.sendErrorResponse(500, failureMessage, response);
            }
        }
        return true;
    }

    private void sendErrorResponse(int statusCode, String failureMessage, Response response) throws IOException {
        ResponseContainer.ErrorResponse resp = new ResponseContainer.ErrorResponse(0, statusCode, failureMessage);
        ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
    }
}

