/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class RewindTierTopicConsumerRequest {
    @JsonProperty(value="partition_to_position")
    final Map<Integer, Map<Long, Optional<Integer>>> partitionToPosition;
    @JsonProperty(value="force_stop")
    final boolean forceStop;
    @JsonProperty(value="policy")
    final byte policy;

    @JsonCreator
    public RewindTierTopicConsumerRequest(@JsonProperty(value="partition_to_position", required=false) Map<Integer, Map<Long, Optional<Integer>>> partitionToPosition, @JsonProperty(value="force_stop", required=true) boolean forceStop, @JsonProperty(value="policy", required=true) byte policy) {
        this.partitionToPosition = partitionToPosition;
        this.forceStop = forceStop;
        this.policy = policy;
    }

    public String toString() {
        return "RewindTierTopicConsumerRequest{partitionToPosition=" + this.partitionToPositionToString() + "forceStop=" + this.forceStop + "policy=" + this.policy + "}";
    }

    private String partitionToPositionToString() {
        if (this.partitionToPosition == null) {
            return "null";
        }
        return this.partitionToPosition.entrySet().stream().map(entry -> {
            Integer topicPartition = (Integer)entry.getKey();
            String offsetAndEpoch = ((Map)entry.getValue()).entrySet().stream().findFirst().map(position -> {
                Optional epochOpt = (Optional)position.getValue();
                int epoch = epochOpt.orElse(-1);
                return String.format("(offset=%d,epoch=%d)", position.getKey(), epoch);
            }).orElse("(offset=null,epoch=null)");
            return String.format("tp=%s:%s", topicPartition, offsetAndEpoch);
        }).collect(Collectors.joining(", "));
    }
}

