/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.CheckReadyControllerHandle;
import io.confluent.rest.CheckReadyControllerStatus;
import io.confluent.rest.ControllerInternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerReadyHandler
extends Handler.Abstract {
    private static final Logger log = LoggerFactory.getLogger(ControllerInternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final CheckReadyControllerHandle checkReadyControllerHandle;

    public ControllerReadyHandler(CheckReadyControllerHandle checkReadyControllerHandle) {
        this.checkReadyControllerHandle = Objects.requireNonNull(checkReadyControllerHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        AtomicReference<Callback> callbackReference = new AtomicReference<Callback>(callback);
        try {
            String target = request.getHttpURI().getPath();
            if (target.endsWith("/status")) {
                log.debug("Handling readiness status query");
                this.handleReadinessQuery(response, callbackReference);
            }
        }
        finally {
            Optional.ofNullable(callbackReference.getAndSet(null)).ifPresent(Callback::succeeded);
        }
        return true;
    }

    private void handleReadinessQuery(Response response, AtomicReference<Callback> callback) throws IOException {
        try {
            CheckReadyControllerStatus status = this.checkReadyControllerHandle.generateReadinessStatus();
            ResponseContainer.dataResponse(status).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            String failureMessage = "Failed to retrieve and write controller readiness information";
            log.error(failureMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = ControllerReadyHandler.genericErrorResponse(failureMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            Optional.ofNullable(callback.getAndSet(null)).ifPresent(c -> c.failed((Throwable)e));
        }
    }

    private static ResponseContainer.ErrorResponse genericErrorResponse(String message) {
        return new ResponseContainer.ErrorResponse(0, 500, message);
    }
}

