/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public final class TierTopicHeadDataLossDetectionRequest {
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="tier_topic_partitions_allow_list")
    private final Set<TopicPartition> tierTopicPartitionsAllowList;

    @JsonCreator
    public TierTopicHeadDataLossDetectionRequest(@JsonProperty(value="identifier", required=true) String identifier, @JsonProperty(value="tier_topic_partitions_allow_list") Set<TopicPartition> tierTopicPartitionsAllowList) {
        this.identifier = identifier;
        this.tierTopicPartitionsAllowList = tierTopicPartitionsAllowList;
    }

    @JsonProperty(value="identifier", required=true)
    public String identifier() {
        return this.identifier;
    }

    @JsonProperty(value="tier_topic_partitions_allow_list", required=true)
    public Set<TopicPartition> tierTopicPartitionsAllowList() {
        return this.tierTopicPartitionsAllowList;
    }

    public String toString() {
        return String.format("TierTopicHeadDataLossDetectionRequest{identifier=%s, tierTopicPartitionsAllowList=[%s]}", this.identifier, this.topicPartitionsToString());
    }

    private String topicPartitionsToString() {
        return this.tierTopicPartitionsAllowList.stream().map(tp -> String.format(tp.toString(), new Object[0])).collect(Collectors.joining(", "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierTopicHeadDataLossDetectionRequest that = (TierTopicHeadDataLossDetectionRequest)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.tierTopicPartitionsAllowList, that.tierTopicPartitionsAllowList);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.tierTopicPartitionsAllowList);
    }
}

