/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.client.plugins.ssl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.List;

public class CertificateIdsJsonConfig {
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private final String issuer;
    private final List<String> serialNumbers;

    @JsonCreator
    public CertificateIdsJsonConfig(@JsonProperty(value="issuer") String issuer, @JsonProperty(value="serial_numbers") List<String> serialNumbers) {
        this.issuer = issuer;
        this.serialNumbers = serialNumbers;
    }

    public String issuer() {
        return this.issuer;
    }

    public List<String> serialNumbers() {
        return this.serialNumbers;
    }

    public static CertificateIdsJsonConfig[] fromJson(String json) throws JsonProcessingException {
        if (json == null || json.trim().isEmpty()) {
            return new CertificateIdsJsonConfig[0];
        }
        return (CertificateIdsJsonConfig[])JSON_SERDE.readValue(json, CertificateIdsJsonConfig[].class);
    }

    public static String toJson(CertificateIdsJsonConfig[] certificateIdsJsonConfig) throws JsonProcessingException {
        return JSON_SERDE.writeValueAsString((Object)certificateIdsJsonConfig);
    }

    static {
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JSON_SERDE.registerModule((Module)new Jdk8Module());
    }
}

