/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.client.plugins.ssl;

import io.confluent.kafka.client.plugins.ssl.ConfluentTrustManager;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkLinkTrustManager
extends ConfluentTrustManager {
    private static final Logger log = LoggerFactory.getLogger(NetworkLinkTrustManager.class);
    private final String brokerSessionUuid;

    public NetworkLinkTrustManager(Map<String, ?> configs, X509ExtendedTrustManager defaultTrustManager) {
        super(configs, defaultTrustManager);
        this.brokerSessionUuid = NetworkLinkTrustManager.getBrokerSessionUuid(configs);
    }

    @Override
    protected boolean verifySubjectAltName(String name) throws CertificateException {
        return super.verifySubjectAltName(name) && this.getNetworkRoutes().allowsDNSDomainSuffix(name);
    }

    private TrafficNetworkIdRoutes getNetworkRoutes() throws CertificateException {
        TrafficNetworkIdRoutes routes = TrafficNetworkIdRoutesStore.getRoutes((String)this.brokerSessionUuid);
        if (routes == null) {
            String errorMsg = "Traffic network routes are not available";
            log.trace("The certificate verification failed due to: {}", (Object)errorMsg);
            throw new CertificateException(errorMsg);
        }
        return routes;
    }

    private static String getBrokerSessionUuid(Map<String, ?> configs) {
        Object uuidConfigValue = configs.get("broker.session.uuid");
        if (uuidConfigValue == null) {
            throw new ConfigException("broker.session.uuid is not set");
        }
        return uuidConfigValue.toString();
    }
}

