/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.oauth;

import io.confluent.kafka.clients.plugins.auth.oauth.FilteringDnsResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;

public class ClusterLinkHttpAccessTokenRetriever
extends HttpJwtRetriever {
    private final URL tokenEndpointUrl;

    public ClusterLinkHttpAccessTokenRetriever(String clientId, String clientSecret, String scope, String tokenEndpointUrl, boolean urlencodeHeader) {
        super(clientId, clientSecret, scope, urlencodeHeader);
        try {
            this.tokenEndpointUrl = new URL(tokenEndpointUrl);
        }
        catch (MalformedURLException e) {
            throw new ConfigException(String.format("The OAuth token endpoint URL (%s) is malformed: %s", tokenEndpointUrl, e.getMessage()));
        }
    }

    public String retrieve() throws JwtRetrieverException {
        boolean hasViolatingIpAddress;
        try {
            FilteringDnsResolver dnsResolver = new FilteringDnsResolver(true, true, true, Collections.emptyList(), Collections.emptyList());
            hasViolatingIpAddress = dnsResolver.hasViolatingIpAddress(this.tokenEndpointUrl.getHost());
        }
        catch (UnknownHostException e) {
            throw new JwtRetrieverException("Failed to resolve tokenEndpointUrl: " + String.valueOf(this.tokenEndpointUrl) + ": " + String.valueOf(e));
        }
        if (hasViolatingIpAddress) {
            throw new JwtRetrieverException("tokenEndpointUrl: " + String.valueOf(this.tokenEndpointUrl) + " contains invalid IP address");
        }
        return super.retrieve();
    }
}

