/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import io.confluent.security.authorizer.utils.JsonMapper;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequest {
    private static final Logger log = LoggerFactory.getLogger(RestRequest.class);
    private static ObjectMapper objectMapper = JsonMapper.objectMapper();
    static final String API_ENDPOINT = "/security/1.0";
    private UriBuilder builder;
    private HttpCredentialProvider credentialProvider;
    private TypeReference<?> responseReference;
    private String method = "GET";
    private Object request;

    RestRequest(String protocol, String path) {
        this.builder = UriBuilder.fromPath((String)API_ENDPOINT).path(path).scheme(protocol);
    }

    void configureConnection(HttpURLConnection connection) throws ProtocolException {
        if (this.credentialProvider != null) {
            connection.setRequestProperty("Authorization", String.join((CharSequence)" ", this.credentialProvider.getScheme(), this.credentialProvider.getCredentials()));
        }
        if (this.request != null) {
            connection.setDoOutput(true);
        }
        connection.setDoInput(true);
        connection.setRequestMethod(this.method);
    }

    URI build(String host) {
        return this.builder.host(host).build(new Object[0]);
    }

    URL build() throws MalformedURLException {
        return this.builder.build(new Object[0]).toURL();
    }

    void writeRequestBody(OutputStream out) throws IOException {
        if (this.request != null) {
            objectMapper.writeValue(out, this.request);
        }
    }

    <T> T readResponse(InputStream in) throws IOException {
        if (this.responseReference != null) {
            return (T)objectMapper.readValue(in, this.responseReference);
        }
        return null;
    }

    void setHost(String host) {
        this.builder.host(host);
    }

    void setPort(int port) {
        this.builder.port(port);
    }

    public void setCredentialProvider(HttpCredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public void setRequestMethod(String method) {
        this.method = method;
    }

    public void addPath(String path) {
        this.builder.path(path);
    }

    public void setPath(String path) {
        this.builder.replacePath(API_ENDPOINT).path(path);
    }

    public void addQueryParam(String name, Object ... params) {
        this.builder.queryParam(name, params);
    }

    public void setRequest(Object body) {
        this.request = body;
    }

    public void setResponse(TypeReference responseFormat) {
        this.responseReference = responseFormat;
    }
}

