/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContext {
    private final Map<String, Object> context = new HashMap<String, Object>();
    private static final Logger log = LoggerFactory.getLogger(SecurityContext.class);
    public static final String REQ_ID = "req_id";
    public static final long DEFAULT_REQ_ID = -1L;

    public static SecurityContext fromMap(Map<String, Object> context) {
        SecurityContext ctx = new SecurityContext();
        ctx.addAll(context);
        return ctx;
    }

    public Map<String, Object> getContextMap() {
        return Collections.unmodifiableMap(this.context);
    }

    public Object add(String key, Object val) {
        return this.context.put(key, val);
    }

    public Object add(Map.Entry<String, Object> entry) {
        return this.context.put(entry.getKey(), entry.getValue());
    }

    public void addAll(Map<String, Object> entries) {
        this.context.putAll(entries);
    }

    public String strVal(String key, String defValue) {
        return this.typeVal(key, String.class, defValue);
    }

    public String strVal(String key, String defValue, boolean emptyIsNull) {
        String val = this.typeVal(key, String.class);
        if (val == null || val.trim().equals("") && emptyIsNull) {
            return defValue;
        }
        return val;
    }

    public Integer intVal(String key, Integer defValue) {
        return this.typeVal(key, Integer.class, defValue);
    }

    public Double doubleVal(String key, Double defValue) {
        return this.typeVal(key, Double.class, defValue);
    }

    public Boolean boolVal(String key, Boolean defValue) {
        return this.typeVal(key, Boolean.class, defValue);
    }

    public <T> T typeVal(String key, Class<T> type, T defValue) {
        T val = this.typeVal(key, type);
        return val != null ? val : defValue;
    }

    private <T> T typeVal(String key, Class<T> type) {
        if (!this.context.containsKey(key)) {
            return null;
        }
        Object val = this.context.get(key);
        try {
            return type.cast(val);
        }
        catch (ClassCastException e) {
            log.error(String.format("Could not cast value for key %s to type %s", key, type.getName()), (Throwable)e);
            return null;
        }
    }

    public <T> T get(Function<Map<String, Object>, T> mapper) {
        return mapper.apply(Collections.unmodifiableMap(this.context));
    }

    public long getReqId() {
        if (this.context.containsKey(REQ_ID)) {
            return (Long)this.context.get(REQ_ID);
        }
        return -1L;
    }
}

