/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.util.Map;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;

public class AvroConverter
implements Converter {
    public static final String SCHEMAS_CACHE_SIZE_CONFIG = "schemas.cache.config";
    private static final int SCHEMAS_CACHE_SIZE_DEFAULT = 1000;
    private SchemaRegistryClient schemaRegistry;
    private Serializer serializer;
    private Deserializer deserializer;
    private boolean isKey;
    private AvroData avroData;

    public AvroConverter() {
    }

    public AvroConverter(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        Object url = configs.get("schema.registry.url");
        if (url == null) {
            throw new ConfigException("Missing Schema registry url!");
        }
        Object maxSchemaObject = configs.get("max.schemas.per.subject");
        if (this.schemaRegistry == null) {
            this.schemaRegistry = maxSchemaObject == null ? new CachedSchemaRegistryClient((String)url, 1000) : new CachedSchemaRegistryClient((String)url, ((Integer)maxSchemaObject).intValue());
        }
        int schemaCacheSize = 1000;
        Boolean schemaCacheSizeObj = configs.containsKey(SCHEMAS_CACHE_SIZE_CONFIG);
        if (schemaCacheSizeObj != null && schemaCacheSizeObj instanceof Integer) {
            schemaCacheSize = (Integer)((Object)schemaCacheSizeObj);
        }
        this.serializer = new Serializer(this.schemaRegistry);
        this.deserializer = new Deserializer(this.schemaRegistry);
        this.avroData = new AvroData(schemaCacheSize);
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        try {
            return this.serializer.serialize(topic, this.isKey, this.avroData.fromConnectData(schema, value));
        }
        catch (SerializationException e) {
            throw new DataException("Failed to serialize Avro data: ", (Throwable)e);
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        try {
            GenericContainer deserialized = this.deserializer.deserialize(topic, this.isKey, value);
            if (deserialized == null) {
                return SchemaAndValue.NULL;
            }
            if (deserialized instanceof IndexedRecord) {
                return this.avroData.toConnectData(deserialized.getSchema(), (Object)deserialized);
            }
            if (deserialized instanceof NonRecordContainer) {
                return this.avroData.toConnectData(deserialized.getSchema(), ((NonRecordContainer)deserialized).getValue());
            }
            throw new DataException("Unsupported type returned by deserialization");
        }
        catch (SerializationException e) {
            throw new DataException("Failed to deserialize data to Avro: ", (Throwable)e);
        }
    }

    private static class Deserializer
    extends AbstractKafkaAvroDeserializer {
        public Deserializer(SchemaRegistryClient client) {
            this.schemaRegistry = client;
        }

        public GenericContainer deserialize(String topic, boolean isKey, byte[] payload) {
            return this.deserializeWithSchemaAndVersion(topic, isKey, payload);
        }
    }

    private static class Serializer
    extends AbstractKafkaAvroSerializer {
        public Serializer(SchemaRegistryClient client) {
            this.schemaRegistry = client;
        }

        public byte[] serialize(String topic, boolean isKey, Object value) {
            return this.serializeImpl(Serializer.getSubjectName((String)topic, (boolean)isKey), value);
        }
    }
}

