/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.elasticsearch;

import com.sun.security.auth.module.Krb5LoginModule;
import io.confluent.connect.elasticsearch.ElasticsearchSinkConnectorConfig;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.connect.errors.ConnectException;
import org.elasticsearch.client.RestClientBuilder;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCallbackHandler
implements RestClientBuilder.HttpClientConfigCallback {
    private static final Logger log = LoggerFactory.getLogger(ConfigCallbackHandler.class);
    private static final Oid SPNEGO_OID = ConfigCallbackHandler.spnegoOid();
    private final ElasticsearchSinkConnectorConfig config;

    public ConfigCallbackHandler(ElasticsearchSinkConnectorConfig config) {
        this.config = config;
    }

    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder builder) {
        RequestConfig requestConfig = RequestConfig.custom().setContentCompressionEnabled(this.config.compression()).setConnectTimeout(this.config.connectionTimeoutMs()).setConnectionRequestTimeout(this.config.readTimeoutMs()).setSocketTimeout(this.config.readTimeoutMs()).build();
        builder.setConnectionManager((NHttpClientConnectionManager)this.createConnectionManager()).setDefaultRequestConfig(requestConfig);
        this.configureAuthentication(builder);
        if (this.config.isKerberosEnabled()) {
            this.configureKerberos(builder);
        }
        if (this.config.isSslEnabled()) {
            this.configureSslContext(builder);
        }
        if (this.config.isKerberosEnabled() && this.config.isSslEnabled()) {
            log.info("Using Kerberos and SSL connection to {}.", this.config.connectionUrls());
        } else if (this.config.isKerberosEnabled()) {
            log.info("Using Kerberos connection to {}.", this.config.connectionUrls());
        } else if (this.config.isSslEnabled()) {
            log.info("Using SSL connection to {}.", this.config.connectionUrls());
        } else {
            log.info("Using unsecured connection to {}.", this.config.connectionUrls());
        }
        return builder;
    }

    private void configureAuthentication(HttpAsyncClientBuilder builder) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (this.config.isAuthenticatedConnection()) {
            this.config.connectionUrls().forEach(arg_0 -> this.lambda$configureAuthentication$0((CredentialsProvider)credentialsProvider, arg_0));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if (this.config.isBasicProxyConfigured()) {
            HttpHost proxy = new HttpHost(this.config.proxyHost(), this.config.proxyPort());
            builder.setProxy(proxy);
            if (this.config.isProxyWithAuthenticationConfigured()) {
                credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(this.config.proxyUsername(), this.config.proxyPassword().value()));
            }
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    private PoolingNHttpClientConnectionManager createConnectionManager() {
        try {
            PoolingNHttpClientConnectionManager cm;
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setConnectTimeout(this.config.connectionTimeoutMs()).setSoTimeout(this.config.readTimeoutMs()).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            if (this.config.isSslEnabled()) {
                HostnameVerifier hostnameVerifier = this.config.shouldDisableHostnameVerification() ? new NoopHostnameVerifier() : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                Registry reg = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(this.sslContext(), hostnameVerifier)).build();
                cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, reg);
            } else {
                cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            }
            int maxPerRoute = Math.max(10, this.config.maxInFlightRequests() * 2);
            cm.setDefaultMaxPerRoute(maxPerRoute);
            cm.setMaxTotal(maxPerRoute * this.config.connectionUrls().size());
            log.debug("Connection pool config: maxPerRoute: {}, maxTotal {}", (Object)cm.getDefaultMaxPerRoute(), (Object)cm.getMaxTotal());
            return cm;
        }
        catch (IOReactorException e) {
            throw new ConnectException("Unable to open ElasticsearchClient.", (Throwable)e);
        }
    }

    private HttpAsyncClientBuilder configureKerberos(HttpAsyncClientBuilder builder) {
        GSSManager gssManager = GSSManager.getInstance();
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory()).build();
        builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        try {
            LoginContext loginContext = this.loginContext();
            GSSCredential credential = Subject.doAs(loginContext.getSubject(), () -> gssManager.createCredential(null, 0, SPNEGO_OID, 1));
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate"), (Credentials)new KerberosCredentials(credential));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        catch (PrivilegedActionException e) {
            throw new ConnectException((Throwable)e);
        }
        return builder;
    }

    private void configureSslContext(HttpAsyncClientBuilder builder) {
        HostnameVerifier hostnameVerifier = this.config.shouldDisableHostnameVerification() ? new NoopHostnameVerifier() : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        SSLContext sslContext = this.sslContext();
        builder.setSSLContext(sslContext);
        builder.setSSLHostnameVerifier(hostnameVerifier);
        builder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslContext, hostnameVerifier));
    }

    private SSLContext sslContext() {
        SslFactory sslFactory = new SslFactory(ConnectionMode.CLIENT, null, false);
        sslFactory.configure(this.config.sslConfigs());
        try {
            log.debug("Trying AK 2.2 SslFactory methods.");
            return (SSLContext)SslFactory.class.getDeclaredMethod("sslContext", new Class[0]).invoke((Object)sslFactory, new Object[0]);
        }
        catch (Exception e) {
            Object sslEngine;
            log.debug("Could not find AK 2.2 SslFactory methods. Trying AK 2.3+ methods for SslFactory.");
            try {
                sslEngine = SslFactory.class.getDeclaredMethod("sslEngineBuilder", new Class[0]).invoke((Object)sslFactory, new Object[0]);
                log.debug("Using AK 2.2-2.5 SslFactory methods.");
            }
            catch (Exception ex) {
                log.debug("Could not find AK 2.3-2.5 SslFactory methods. Trying AK 2.6+ methods for SslFactory.");
                try {
                    sslEngine = SslFactory.class.getDeclaredMethod("sslEngineFactory", new Class[0]).invoke((Object)sslFactory, new Object[0]);
                    log.debug("Using AK 2.6+ SslFactory methods.");
                }
                catch (Exception exc) {
                    throw new ConnectException("Failed to find methods for SslFactory.", (Throwable)exc);
                }
            }
            try {
                return (SSLContext)sslEngine.getClass().getDeclaredMethod("sslContext", new Class[0]).invoke(sslEngine, new Object[0]);
            }
            catch (Exception ex) {
                throw new ConnectException("Could not create SSLContext.", (Throwable)ex);
            }
        }
    }

    private LoginContext loginContext() throws PrivilegedActionException {
        Configuration conf = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, ConfigCallbackHandler.this.kerberosConfigs())};
            }
        };
        return AccessController.doPrivileged(() -> {
            Subject subject = new Subject(false, Collections.singleton(new KerberosPrincipal(this.config.kerberosUserPrincipal())), new HashSet(), new HashSet());
            LoginContext loginContext = new LoginContext("ElasticsearchSinkConnector", subject, null, conf);
            loginContext.login();
            return loginContext;
        });
    }

    private Map<String, Object> kerberosConfigs() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("useTicketCache", "true");
        configs.put("renewTGT", "true");
        configs.put("useKeyTab", "true");
        configs.put("keyTab", this.config.keytabPath());
        configs.put("refreshKrb5Config", "true");
        configs.put("principal", this.config.kerberosUserPrincipal());
        configs.put("storeKey", "false");
        configs.put("doNotPrompt", "true");
        return configs;
    }

    private static Oid spnegoOid() {
        try {
            return new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gsse) {
            throw new ConnectException((Throwable)gsse);
        }
    }

    private /* synthetic */ void lambda$configureAuthentication$0(CredentialsProvider credentialsProvider, String url) {
        credentialsProvider.setCredentials(new AuthScope(HttpHost.create((String)url)), (Credentials)new UsernamePasswordCredentials(this.config.username(), this.config.password().value()));
    }
}

