/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.elasticsearch;

import io.confluent.connect.elasticsearch.ElasticsearchSinkConnectorConfig;
import io.confluent.connect.elasticsearch.ElasticsearchSinkTask;
import io.confluent.connect.elasticsearch.Validator;
import io.confluent.connect.elasticsearch.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkConnector;

public class ElasticsearchSinkConnector
extends SinkConnector {
    private Map<String, String> configProperties;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> props) throws ConnectException {
        try {
            this.configProperties = props;
            new ElasticsearchSinkConnectorConfig(props);
        }
        catch (ConfigException e) {
            throw new ConnectException("Couldn't start ElasticsearchSinkConnector due to configuration error", (Throwable)e);
        }
    }

    public Class<? extends Task> taskClass() {
        return ElasticsearchSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        HashMap<String, String> taskProps = new HashMap<String, String>();
        taskProps.putAll(this.configProperties);
        for (int i = 0; i < maxTasks; ++i) {
            taskConfigs.add(taskProps);
        }
        return taskConfigs;
    }

    public void stop() throws ConnectException {
    }

    public ConfigDef config() {
        return ElasticsearchSinkConnectorConfig.CONFIG;
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Validator validator = new Validator(connectorConfigs);
        return validator.validate();
    }
}

