/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

class EnumRecommender<T extends Enum<?>>
implements ConfigDef.Validator,
ConfigDef.Recommender {
    private final Set<String> validValues;
    private final Class<T> enumClass;

    public EnumRecommender(Class<T> enumClass) {
        this.enumClass = enumClass;
        LinkedHashSet<String> validEnums = new LinkedHashSet<String>();
        for (Enum o : (Enum[])enumClass.getEnumConstants()) {
            String key = o.toString().toLowerCase();
            validEnums.add(key);
        }
        this.validValues = Collections.unmodifiableSet(validEnums);
    }

    public void ensureValid(String key, Object value) {
        if (value == null) {
            return;
        }
        String enumValue = value.toString().toLowerCase();
        if (value != null && !this.validValues.contains(enumValue)) {
            throw new ConfigException(key, value, "Value must be one of: " + this);
        }
    }

    public String toString() {
        return this.validValues.toString();
    }

    public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
        return Collections.unmodifiableList(new ArrayList<String>(this.validValues));
    }

    public boolean visible(String name, Map<String, Object> connectorConfigs) {
        return true;
    }
}

