/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.elasticsearch;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class Mapping {
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String BYTE_TYPE = "byte";
    public static final String BINARY_TYPE = "binary";
    public static final String SHORT_TYPE = "short";
    public static final String INTEGER_TYPE = "integer";
    public static final String LONG_TYPE = "long";
    public static final String FLOAT_TYPE = "float";
    public static final String DOUBLE_TYPE = "double";
    public static final String STRING_TYPE = "string";
    public static final String TEXT_TYPE = "text";
    public static final String KEYWORD_TYPE = "keyword";
    public static final String DATE_TYPE = "date";
    private static final String DEFAULT_VALUE_FIELD = "null_value";
    private static final String FIELDS_FIELD = "fields";
    private static final String IGNORE_ABOVE_FIELD = "ignore_above";
    public static final String KEY_FIELD = "key";
    private static final String KEYWORD_FIELD = "keyword";
    private static final String PROPERTIES_FIELD = "properties";
    private static final String TYPE_FIELD = "type";
    public static final String VALUE_FIELD = "value";

    public static XContentBuilder buildMapping(Schema schema) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            Mapping.buildMapping(schema, builder);
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ConnectException("Failed to build mapping for schema " + schema, (Throwable)e);
        }
    }

    private static XContentBuilder buildMapping(Schema schema, XContentBuilder builder) throws IOException {
        if (schema == null) {
            throw new DataException("Cannot infer mapping without schema.");
        }
        XContentBuilder logicalConversion = Mapping.inferLogicalMapping(builder, schema);
        if (logicalConversion != null) {
            return logicalConversion;
        }
        Schema.Type schemaType = schema.type();
        switch (schema.type()) {
            case ARRAY: {
                return Mapping.buildMapping(schema.valueSchema(), builder);
            }
            case MAP: {
                return Mapping.buildMap(schema, builder);
            }
            case STRUCT: {
                return Mapping.buildStruct(schema, builder);
            }
        }
        return Mapping.inferPrimitive(builder, Mapping.getElasticsearchType(schemaType), schema.defaultValue());
    }

    private static void addTextMapping(XContentBuilder builder) throws IOException {
        builder.startObject(FIELDS_FIELD);
        builder.startObject("keyword");
        builder.field(TYPE_FIELD, "keyword");
        builder.field(IGNORE_ABOVE_FIELD, 256);
        builder.endObject();
        builder.endObject();
    }

    private static XContentBuilder buildMap(Schema schema, XContentBuilder builder) throws IOException {
        builder.startObject(PROPERTIES_FIELD);
        builder.startObject(KEY_FIELD);
        Mapping.buildMapping(schema.keySchema(), builder);
        builder.endObject();
        builder.startObject(VALUE_FIELD);
        Mapping.buildMapping(schema.valueSchema(), builder);
        builder.endObject();
        return builder.endObject();
    }

    private static XContentBuilder buildStruct(Schema schema, XContentBuilder builder) throws IOException {
        builder.startObject(PROPERTIES_FIELD);
        for (Field field : schema.fields()) {
            builder.startObject(field.name());
            Mapping.buildMapping(field.schema(), builder);
            builder.endObject();
        }
        return builder.endObject();
    }

    private static XContentBuilder inferPrimitive(XContentBuilder builder, String type, Object defaultValue) throws IOException {
        if (type == null) {
            throw new DataException(String.format("Invalid primitive type %s.", type));
        }
        builder.field(TYPE_FIELD, type);
        if (type.equals(TEXT_TYPE)) {
            Mapping.addTextMapping(builder);
        }
        if (defaultValue == null) {
            return builder;
        }
        switch (type) {
            case "byte": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Byte)defaultValue).byteValue());
            }
            case "short": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Short)defaultValue).shortValue());
            }
            case "integer": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Integer)defaultValue).intValue());
            }
            case "long": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Long)defaultValue).longValue());
            }
            case "float": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Float)defaultValue).floatValue());
            }
            case "double": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Double)defaultValue).doubleValue());
            }
            case "boolean": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Boolean)defaultValue).booleanValue());
            }
            case "date": {
                return builder.field(DEFAULT_VALUE_FIELD, ((Date)defaultValue).getTime());
            }
            case "string": 
            case "text": 
            case "binary": {
                return builder;
            }
        }
        throw new DataException("Invalid primitive type " + type + ".");
    }

    private static XContentBuilder inferLogicalMapping(XContentBuilder builder, Schema schema) throws IOException {
        if (schema.name() == null) {
            return null;
        }
        switch (schema.name()) {
            case "org.apache.kafka.connect.data.Date": 
            case "org.apache.kafka.connect.data.Time": 
            case "org.apache.kafka.connect.data.Timestamp": {
                return Mapping.inferPrimitive(builder, DATE_TYPE, schema.defaultValue());
            }
            case "org.apache.kafka.connect.data.Decimal": {
                Double defaultValue = schema.defaultValue() != null ? Double.valueOf(((BigDecimal)schema.defaultValue()).doubleValue()) : null;
                return Mapping.inferPrimitive(builder, DOUBLE_TYPE, defaultValue);
            }
        }
        return null;
    }

    protected static String getElasticsearchType(Schema.Type schemaType) {
        switch (schemaType) {
            case BOOLEAN: {
                return BOOLEAN_TYPE;
            }
            case INT8: {
                return BYTE_TYPE;
            }
            case INT16: {
                return SHORT_TYPE;
            }
            case INT32: {
                return INTEGER_TYPE;
            }
            case INT64: {
                return LONG_TYPE;
            }
            case FLOAT32: {
                return FLOAT_TYPE;
            }
            case FLOAT64: {
                return DOUBLE_TYPE;
            }
            case STRING: {
                return TEXT_TYPE;
            }
            case BYTES: {
                return BINARY_TYPE;
            }
        }
        return null;
    }
}

