/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.elasticsearch;

import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger log = LoggerFactory.getLogger(RetryUtil.class);
    public static final long MAX_RETRY_TIME_MS = TimeUnit.HOURS.toMillis(24L);

    public static long computeRandomRetryWaitTimeInMillis(int retryAttempts, long initialRetryBackoffMs) {
        if (initialRetryBackoffMs < 0L) {
            return 0L;
        }
        if (retryAttempts < 0) {
            return initialRetryBackoffMs;
        }
        long maxRetryTime = RetryUtil.computeRetryWaitTimeInMillis(retryAttempts, initialRetryBackoffMs);
        return ThreadLocalRandom.current().nextLong(0L, maxRetryTime);
    }

    public static long computeRetryWaitTimeInMillis(int retryAttempts, long initialRetryBackoffMs) {
        if (initialRetryBackoffMs < 0L) {
            return 0L;
        }
        if (retryAttempts <= 0) {
            return initialRetryBackoffMs;
        }
        if (retryAttempts > 32) {
            return MAX_RETRY_TIME_MS;
        }
        long result = initialRetryBackoffMs << retryAttempts;
        return result < 0L ? MAX_RETRY_TIME_MS : Math.min(MAX_RETRY_TIME_MS, result);
    }

    public static <T> T callWithRetries(String description, Callable<T> function, int maxTotalAttempts, long initialBackoff) {
        return RetryUtil.callWithRetries(description, function, maxTotalAttempts, initialBackoff, Time.SYSTEM);
    }

    protected static <T> T callWithRetries(String description, Callable<T> function, int maxTotalAttempts, long initialBackoff, Time clock) {
        assert (description != null);
        assert (function != null);
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                log.trace("Try {} (attempt {} of {})", new Object[]{description, attempt, maxTotalAttempts});
                T call = function.call();
                return call;
            }
            catch (Exception e) {
                if (attempt >= maxTotalAttempts) {
                    String msg = String.format("Failed to %s due to '%s' after %d attempt(s)", description, e, attempt);
                    log.error(msg, (Throwable)e);
                    throw new ConnectException(msg, (Throwable)e);
                }
                long backoff = RetryUtil.computeRandomRetryWaitTimeInMillis(attempt, initialBackoff);
                log.warn("Failed to {} due to {}. Retrying attempt ({}/{}) after backoff of {} ms", new Object[]{description, e.getCause(), attempt, maxTotalAttempts, backoff});
                log.trace("Failed to {} due to exception :: {} and its stacktrace {}  Retrying attempt ({}/{}) after backoff of {} ms", new Object[]{description, e, e.getStackTrace(), attempt, maxTotalAttempts, backoff});
                log.trace("exception::", (Throwable)e);
                clock.sleep(backoff);
                continue;
            }
            break;
        }
    }
}

