/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.elasticsearch;

import io.confluent.connect.elasticsearch.ElasticsearchClient;
import io.confluent.connect.elasticsearch.OffsetState;
import io.confluent.connect.elasticsearch.OffsetTracker;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.sink.SinkRecord;

public class SyncOffsetTracker
implements OffsetTracker {
    private ElasticsearchClient client;

    public SyncOffsetTracker(ElasticsearchClient client) {
        this.client = client;
    }

    @Override
    public SyncOffsetState addPendingRecord(SinkRecord record) {
        return new SyncOffsetState();
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> offsets(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        this.client.waitForInFlightRequests();
        return this.client.isFailed() ? Collections.emptyMap() : currentOffsets;
    }

    static class SyncOffsetState
    implements OffsetState {
        SyncOffsetState() {
        }

        @Override
        public void markProcessed() {
        }

        @Override
        public boolean isProcessed() {
            return false;
        }

        @Override
        public long offset() {
            return -1L;
        }
    }
}

