/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.source.ColumnMapping;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlDatabaseDialect
extends GenericDatabaseDialect {
    private final Logger log = LoggerFactory.getLogger(PostgreSqlDatabaseDialect.class);
    static final String JSON_TYPE_NAME = "json";
    static final String JSONB_TYPE_NAME = "jsonb";
    static final String UUID_TYPE_NAME = "uuid";
    private static final Set<String> CAST_TYPES = Collections.unmodifiableSet(Utils.mkSet((Object[])new String[]{"json", "jsonb", "uuid"}));

    public PostgreSqlDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    @Override
    protected void initializePreparedStatement(PreparedStatement stmt) throws SQLException {
        super.initializePreparedStatement(stmt);
        this.log.trace("Initializing PreparedStatement fetch direction to FETCH_FORWARD for '{}'", (Object)stmt);
        stmt.setFetchDirection(1000);
    }

    @Override
    public String addFieldToSchema(ColumnDefinition columnDefn, SchemaBuilder builder) {
        String fieldName = this.fieldNameFor(columnDefn);
        switch (columnDefn.type()) {
            case -7: {
                boolean optional = columnDefn.isOptional();
                int numBits = columnDefn.precision();
                Schema schema = numBits <= 1 ? (optional ? Schema.OPTIONAL_BOOLEAN_SCHEMA : Schema.BOOLEAN_SCHEMA) : (numBits <= 8 ? (optional ? Schema.OPTIONAL_INT8_SCHEMA : Schema.INT8_SCHEMA) : (optional ? Schema.OPTIONAL_BYTES_SCHEMA : Schema.BYTES_SCHEMA));
                builder.field(fieldName, schema);
                return fieldName;
            }
            case 1111: {
                if (this.isJsonType(columnDefn)) {
                    builder.field(fieldName, columnDefn.isOptional() ? Schema.OPTIONAL_STRING_SCHEMA : Schema.STRING_SCHEMA);
                    return fieldName;
                }
                if (!UUID.class.getName().equals(columnDefn.classNameForType())) break;
                builder.field(fieldName, columnDefn.isOptional() ? Schema.OPTIONAL_STRING_SCHEMA : Schema.STRING_SCHEMA);
                return fieldName;
            }
        }
        return super.addFieldToSchema(columnDefn, builder);
    }

    @Override
    protected DatabaseDialect.ColumnConverter columnConverterFor(ColumnMapping mapping, ColumnDefinition defn, int col, boolean isJdbc4) {
        ColumnDefinition columnDefn = mapping.columnDefn();
        switch (columnDefn.type()) {
            case -7: {
                int numBits = columnDefn.precision();
                if (numBits <= 1) {
                    return rs -> rs.getBoolean(col);
                }
                if (numBits <= 8) {
                    return rs -> rs.getByte(col);
                }
                return rs -> rs.getBytes(col);
            }
            case 1111: {
                if (this.isJsonType(columnDefn)) {
                    return rs -> rs.getString(col);
                }
                if (!UUID.class.getName().equals(columnDefn.classNameForType())) break;
                return rs -> rs.getString(col);
            }
        }
        return super.columnConverterFor(mapping, defn, col, isJdbc4);
    }

    protected boolean isJsonType(ColumnDefinition columnDefn) {
        String typeName = columnDefn.typeName();
        return JSON_TYPE_NAME.equalsIgnoreCase(typeName) || JSONB_TYPE_NAME.equalsIgnoreCase(typeName);
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: 
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "REAL";
            }
            case FLOAT64: {
                return "DOUBLE PRECISION";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "TEXT";
            }
            case BYTES: {
                return "BYTEA";
            }
            case ARRAY: {
                SinkRecordField childField = new SinkRecordField(field.schema().valueSchema(), field.name(), field.isPrimaryKey());
                return this.getSqlType(childField) + "[]";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildInsertStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns, TableDefinition definition) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("INSERT INTO ");
        builder.append(table);
        builder.append(" (");
        builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder.append(") VALUES (");
        builder.appendList().delimitedBy(",").transformedBy(this.columnValueVariables(definition)).of(keyColumns, nonKeyColumns);
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String buildUpdateStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns, TableDefinition definition) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("UPDATE ");
        builder.append(table);
        builder.append(" SET ");
        builder.appendList().delimitedBy(", ").transformedBy(this.columnNamesWithValueVariables(definition)).of(nonKeyColumns);
        if (!keyColumns.isEmpty()) {
            builder.append(" WHERE ");
            builder.appendList().delimitedBy(" AND ").transformedBy(ExpressionBuilder.columnNamesWith(" = ?")).of(keyColumns);
        }
        return builder.toString();
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns, TableDefinition definition) {
        ExpressionBuilder.Transform<ColumnId> transform = (builder, col) -> builder.appendColumnName(col.name()).append("=EXCLUDED.").appendColumnName(col.name());
        ExpressionBuilder builder2 = this.expressionBuilder();
        builder2.append("INSERT INTO ");
        builder2.append(table);
        builder2.append(" (");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder2.append(") VALUES (");
        builder2.appendList().delimitedBy(",").transformedBy(this.columnValueVariables(definition)).of(keyColumns, nonKeyColumns);
        builder2.append(") ON CONFLICT (");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns);
        if (nonKeyColumns.isEmpty()) {
            builder2.append(") DO NOTHING");
        } else {
            builder2.append(") DO UPDATE SET ");
            builder2.appendList().delimitedBy(",").transformedBy(transform).of(nonKeyColumns);
        }
        return builder2.toString();
    }

    @Override
    protected void formatColumnValue(ExpressionBuilder builder, String schemaName, Map<String, String> schemaParameters, Schema.Type type, Object value) {
        if (schemaName == null && Schema.Type.BOOLEAN.equals((Object)type)) {
            builder.append((Boolean)value != false ? "TRUE" : "FALSE");
        } else {
            super.formatColumnValue(builder, schemaName, schemaParameters, type, value);
        }
    }

    @Override
    protected boolean maybeBindPrimitive(PreparedStatement statement, int index, Schema schema, Object value) throws SQLException {
        switch (schema.type()) {
            case ARRAY: {
                List<Object> valueCollection;
                Class<?> valueClass = value.getClass();
                Object[] newValue = null;
                if (Collection.class.isAssignableFrom(valueClass)) {
                    valueCollection = (List<Object>)value;
                } else if (valueClass.isArray()) {
                    valueCollection = Arrays.asList((Object[])value);
                } else {
                    throw new DataException(String.format("Type '%s' is not supported for Array.", valueClass.getName()));
                }
                switch (schema.valueSchema().type()) {
                    case INT8: {
                        newValue = valueCollection.stream().map(o -> ((Byte)o).shortValue()).toArray(Short[]::new);
                        break;
                    }
                    case INT32: {
                        newValue = valueCollection.toArray(new Integer[0]);
                        break;
                    }
                    case INT16: {
                        newValue = valueCollection.toArray(new Short[0]);
                        break;
                    }
                    case BOOLEAN: {
                        newValue = valueCollection.toArray(new Boolean[0]);
                        break;
                    }
                    case STRING: {
                        newValue = valueCollection.toArray(new String[0]);
                        break;
                    }
                    case FLOAT64: {
                        newValue = valueCollection.toArray(new Double[0]);
                        break;
                    }
                    case FLOAT32: {
                        newValue = valueCollection.toArray(new Float[0]);
                        break;
                    }
                    case INT64: {
                        newValue = valueCollection.toArray(new Long[0]);
                        break;
                    }
                }
                if (newValue == null) break;
                statement.setObject(index, (Object)newValue, 2003);
                return true;
            }
        }
        return super.maybeBindPrimitive(statement, index, schema, value);
    }

    protected ExpressionBuilder.Transform<ColumnId> columnNamesWithValueVariables(TableDefinition defn) {
        return (builder, columnId) -> {
            builder.appendColumnName(columnId.name());
            builder.append(" = ?");
            builder.append(this.valueTypeCast(defn, (ColumnId)columnId));
        };
    }

    protected ExpressionBuilder.Transform<ColumnId> columnValueVariables(TableDefinition defn) {
        return (builder, columnId) -> {
            builder.append("?");
            builder.append(this.valueTypeCast(defn, (ColumnId)columnId));
        };
    }

    protected String valueTypeCast(TableDefinition tableDefn, ColumnId columnId) {
        String typeName;
        ColumnDefinition defn;
        if (tableDefn != null && (defn = tableDefn.definitionForColumn(columnId.name())) != null && (typeName = defn.typeName()) != null && CAST_TYPES.contains(typeName = typeName.toLowerCase())) {
            return "::" + typeName;
        }
        return "";
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(PostgreSqlDatabaseDialect.class.getSimpleName(), "postgresql");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new PostgreSqlDatabaseDialect(config);
        }
    }
}

