/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Schema;

public class SybaseDatabaseDialect
extends GenericDatabaseDialect {
    public SybaseDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    @Override
    protected boolean useCatalog() {
        return true;
    }

    @Override
    protected String currentTimestampDatabaseQuery() {
        return "select getdate()";
    }

    @Override
    protected String checkConnectionQuery() {
        return "SELECT 1";
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "decimal(38," + field.schemaParameters().get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "date";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "time";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "datetime";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "smallint";
            }
            case INT16: {
                return "smallint";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "bigint";
            }
            case FLOAT32: {
                return "real";
            }
            case FLOAT64: {
                return "float";
            }
            case BOOLEAN: {
                if (field.isOptional()) {
                    return "tinyint";
                }
                return "bit";
            }
            case STRING: {
                if (field.isPrimaryKey()) {
                    return "varchar(512)";
                }
                return "text";
            }
            case BYTES: {
                return "image";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    protected boolean maybeBindPrimitive(PreparedStatement statement, int index, Schema schema, Object value) throws SQLException {
        switch (schema.type()) {
            case INT8: {
                if (!(value instanceof Number)) break;
                statement.setShort(index, ((Number)value).shortValue());
                return true;
            }
        }
        return super.maybeBindPrimitive(statement, index, schema, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyDdlStatements(Connection connection, List<String> statements) throws SQLException {
        boolean autoCommit = connection.getAutoCommit();
        if (!autoCommit) {
            connection.setAutoCommit(true);
        }
        try (Statement statement = connection.createStatement();){
            for (String ddlStatement : statements) {
                statement.executeUpdate(ddlStatement);
            }
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<ColumnId> primaryKeyColumns(Connection connection, String catalogPattern, String schemaPattern, String tablePattern) throws SQLException {
        boolean autoCommit = connection.getAutoCommit();
        try {
            if (!autoCommit) {
                connection.setAutoCommit(true);
            }
            Set<ColumnId> set = super.primaryKeyColumns(connection, catalogPattern, schemaPattern, tablePattern);
            return set;
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    @Override
    public String buildDropTableStatement(TableId table, DropOptions options) {
        ExpressionBuilder builder = this.expressionBuilder();
        if (options.ifExists()) {
            builder.append("IF EXISTS (");
            builder.append("SELECT 1 FROM sysobjects ");
            if (table.schemaName() != null) {
                builder.append("INNER JOIN sysusers ON sysobjects.uid=sysusers.uid ");
                builder.append("WHERE sysusers.name='");
                builder.append(table.schemaName());
                builder.append("' AND sysobjects.name='");
                builder.append(table.tableName());
            } else {
                builder.append("WHERE name='");
                builder.append(table.tableName());
            }
            builder.append("' AND type='U') ");
        }
        builder.append("DROP TABLE ");
        builder.append(table);
        return builder.toString();
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("ALTER TABLE ");
        builder.append(table);
        builder.append(" ADD");
        this.writeColumnsSpec(builder, fields);
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("merge into ");
        builder.append(table);
        builder.append(" AS target using (select ");
        builder.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNamesWithPrefix("? AS ")).of(keyColumns, nonKeyColumns);
        builder.append(") AS incoming on (");
        builder.appendList().delimitedBy(" and ").transformedBy(this::transformAs).of(keyColumns);
        builder.append(")");
        if (nonKeyColumns != null && !nonKeyColumns.isEmpty()) {
            builder.append(" when matched then update set ");
            builder.appendList().delimitedBy(",").transformedBy(this::transformUpdate).of(nonKeyColumns);
        }
        builder.append(" when not matched then insert (");
        builder.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNames()).of(nonKeyColumns, keyColumns);
        builder.append(") values (");
        builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNamesWithPrefix("incoming.")).of(nonKeyColumns, keyColumns);
        builder.append(")");
        return builder.toString();
    }

    private void transformAs(ExpressionBuilder builder, ColumnId col) {
        builder.append("target.").appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
    }

    private void transformUpdate(ExpressionBuilder builder, ColumnId col) {
        builder.appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(SybaseDatabaseDialect.class.getSimpleName(), "microsoft:sqlserver", "sqlserver", "jtds:sybase");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new SybaseDatabaseDialect(config);
        }
    }
}

