/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.sink.DbStructure;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.PreparedStatementBinder;
import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedRecords {
    private static final Logger log = LoggerFactory.getLogger(BufferedRecords.class);
    private final String tableName;
    private final JdbcSinkConfig config;
    private final DbDialect dbDialect;
    private final DbStructure dbStructure;
    private final Connection connection;
    private List<SinkRecord> records = new ArrayList<SinkRecord>();
    private SchemaPair currentSchemaPair;
    private FieldsMetadata fieldsMetadata;
    private PreparedStatement preparedStatement;
    private PreparedStatementBinder preparedStatementBinder;

    public BufferedRecords(JdbcSinkConfig config, String tableName, DbDialect dbDialect, DbStructure dbStructure, Connection connection) {
        this.tableName = tableName;
        this.config = config;
        this.dbDialect = dbDialect;
        this.dbStructure = dbStructure;
        this.connection = connection;
    }

    public List<SinkRecord> add(SinkRecord record) throws SQLException {
        List<Object> flushed;
        SchemaPair schemaPair = new SchemaPair(record.keySchema(), record.valueSchema());
        if (this.currentSchemaPair == null) {
            this.currentSchemaPair = schemaPair;
            this.fieldsMetadata = FieldsMetadata.extract(this.tableName, this.config.pkMode, this.config.pkFields, this.config.fieldsWhitelist, this.currentSchemaPair);
            this.dbStructure.createOrAmendIfNecessary(this.config, this.connection, this.tableName, this.fieldsMetadata);
            String insertSql = this.getInsertSql();
            log.debug("{} sql: {}", (Object)this.config.insertMode, (Object)insertSql);
            this.close();
            this.preparedStatement = this.connection.prepareStatement(insertSql);
            this.preparedStatementBinder = new PreparedStatementBinder(this.preparedStatement, this.config.pkMode, schemaPair, this.fieldsMetadata);
        }
        if (this.currentSchemaPair.equals(schemaPair)) {
            this.records.add(record);
            flushed = this.records.size() >= this.config.batchSize ? this.flush() : Collections.emptyList();
        } else {
            flushed = this.flush();
            this.currentSchemaPair = null;
            flushed.addAll(this.add(record));
        }
        return flushed;
    }

    public List<SinkRecord> flush() throws SQLException {
        if (this.records.isEmpty()) {
            return new ArrayList<SinkRecord>();
        }
        for (SinkRecord record : this.records) {
            this.preparedStatementBinder.bindRecord(record);
        }
        int totalUpdateCount = 0;
        for (int updateCount : this.preparedStatement.executeBatch()) {
            totalUpdateCount += updateCount;
        }
        if (totalUpdateCount != this.records.size()) {
            switch (this.config.insertMode) {
                case INSERT: {
                    throw new ConnectException(String.format("Update count (%d) did not sum up to total number of records inserted (%d)", totalUpdateCount, this.records.size()));
                }
                case UPSERT: {
                    log.trace("Upserted records:{} resulting in in totalUpdateCount:{}", (Object)this.records.size(), (Object)totalUpdateCount);
                }
            }
        }
        List<SinkRecord> flushedRecords = this.records;
        this.records = new ArrayList<SinkRecord>();
        return flushedRecords;
    }

    public void close() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
            this.preparedStatement = null;
        }
    }

    private String getInsertSql() {
        switch (this.config.insertMode) {
            case INSERT: {
                return this.dbDialect.getInsert(this.tableName, this.fieldsMetadata.keyFieldNames, this.fieldsMetadata.nonKeyFieldNames);
            }
            case UPSERT: {
                if (this.fieldsMetadata.keyFieldNames.isEmpty()) {
                    throw new ConnectException(String.format("Write to table '%s' in UPSERT mode requires key field names to be known, check the primary key configuration", this.tableName));
                }
                return this.dbDialect.getUpsertQuery(this.tableName, this.fieldsMetadata.keyFieldNames, this.fieldsMetadata.nonKeyFieldNames);
            }
        }
        throw new ConnectException("Invalid insert mode");
    }
}

